/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.util;

import java.net.URL;
import java.util.HashMap;
import org.jfree.util.Log;
import org.jfree.xml.util.AbstractModelReader;
import org.jfree.xml.util.AttributeDefinition;
import org.jfree.xml.util.AttributeHandler;
import org.jfree.xml.util.ConstructorDefinition;
import org.jfree.xml.util.GenericObjectFactory;
import org.jfree.xml.util.LookupDefinition;
import org.jfree.xml.util.ObjectDescriptionException;
import org.jfree.xml.util.PropertyDefinition;

public class ObjectFactoryLoader
extends AbstractModelReader {
    private HashMap registry = new HashMap();
    private GenericObjectFactory objectFactory;
    private Class target;

    public ObjectFactoryLoader(URL uRL) throws ObjectDescriptionException {
        this.parseXml(uRL);
    }

    protected boolean startObjectDefinition(String string, String string2) {
        this.target = this.loadClass(string);
        if (this.target == null) {
            Log.warn(new Log.SimpleMessage("Failed to load class ", string));
            return false;
        }
        this.objectFactory = new GenericObjectFactory(this.target);
        this.objectFactory.setRegisterName(string2);
        return true;
    }

    protected void handleAttributeDefinition(String string, String string2, String string3) throws ObjectDescriptionException {
        AttributeHandler attributeHandler = this.loadAttributeHandler(string3);
        this.objectFactory.addAttributeDefinition(new AttributeDefinition(string, string2, attributeHandler));
    }

    protected void handleElementDefinition(String string, String string2) throws ObjectDescriptionException {
        this.objectFactory.addPropertyDefinition(new PropertyDefinition(string, string2));
    }

    protected void handleLookupDefinition(String string, String string2) throws ObjectDescriptionException {
        LookupDefinition lookupDefinition = new LookupDefinition(string, string2);
        this.objectFactory.addLookupDefinition(lookupDefinition);
    }

    protected void endObjectDefinition() throws ObjectDescriptionException {
        this.registry.put(this.target, this.objectFactory);
    }

    protected void handleConstructorDefinition(String string, String string2) {
        Class clazz = this.loadClass(string2);
        this.objectFactory.addConstructorDefinition(new ConstructorDefinition(string, clazz));
    }

    private AttributeHandler loadAttributeHandler(String string) throws ObjectDescriptionException {
        Class clazz = this.loadClass(string);
        try {
            return (AttributeHandler)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new ObjectDescriptionException("Invalid attribute handler specified: " + string);
        }
    }

    public boolean canHandle(Class clazz) {
        return this.registry.containsKey(clazz);
    }

    public GenericObjectFactory getFactoryForClass(Class clazz) {
        GenericObjectFactory genericObjectFactory = (GenericObjectFactory)this.registry.get(clazz);
        return genericObjectFactory.getInstance();
    }
}

