/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.writer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import org.jfree.xml.util.Base64;
import org.jfree.xml.util.ObjectFactoryLoader;
import org.jfree.xml.writer.AttributeList;
import org.jfree.xml.writer.XMLWriter;
import org.jfree.xml.writer.XmlWriteHandler;
import org.jfree.xml.writer.coretypes.BasicStrokeWriteHandler;
import org.jfree.xml.writer.coretypes.ColorWriteHandler;
import org.jfree.xml.writer.coretypes.FontWriteHandler;
import org.jfree.xml.writer.coretypes.GenericWriteHandler;
import org.jfree.xml.writer.coretypes.GradientPaintWriteHandler;
import org.jfree.xml.writer.coretypes.Point2DWriteHandler;

public abstract class RootXmlWriteHandler {
    private static final String TYPE_ATTR = "type";
    private static final String TYPE_ATTR_VALUE = "base64";
    private static final String CLASS_ATTR = "class";
    private HashMap classToHandlerMapping = new HashMap();
    static /* synthetic */ Class class$java$awt$Font;
    static /* synthetic */ Class class$java$awt$GradientPaint;
    static /* synthetic */ Class class$java$awt$geom$Point2D$Float;
    static /* synthetic */ Class class$java$awt$geom$Point2D$Double;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$java$awt$BasicStroke;

    public RootXmlWriteHandler() {
        this.addMapping(class$java$awt$Font == null ? (class$java$awt$Font = RootXmlWriteHandler.class$("java.awt.Font")) : class$java$awt$Font, new FontWriteHandler(this));
        this.addMapping(class$java$awt$GradientPaint == null ? (class$java$awt$GradientPaint = RootXmlWriteHandler.class$("java.awt.GradientPaint")) : class$java$awt$GradientPaint, new GradientPaintWriteHandler(this));
        this.addMapping(class$java$awt$geom$Point2D$Float == null ? (class$java$awt$geom$Point2D$Float = RootXmlWriteHandler.class$("java.awt.geom.Point2D$Float")) : class$java$awt$geom$Point2D$Float, new Point2DWriteHandler(this));
        this.addMapping(class$java$awt$geom$Point2D$Double == null ? (class$java$awt$geom$Point2D$Double = RootXmlWriteHandler.class$("java.awt.geom.Point2D$Double")) : class$java$awt$geom$Point2D$Double, new Point2DWriteHandler(this));
        this.addMapping(class$java$awt$Color == null ? (class$java$awt$Color = RootXmlWriteHandler.class$("java.awt.Color")) : class$java$awt$Color, new ColorWriteHandler(this));
        this.addMapping(class$java$awt$BasicStroke == null ? (class$java$awt$BasicStroke = RootXmlWriteHandler.class$("java.awt.BasicStroke")) : class$java$awt$BasicStroke, new BasicStrokeWriteHandler(this));
    }

    public abstract ObjectFactoryLoader getFactoryLoader();

    protected void addMapping(Class clazz, XmlWriteHandler xmlWriteHandler) {
        this.classToHandlerMapping.put(clazz, xmlWriteHandler);
    }

    protected XmlWriteHandler getMapping(Class clazz) {
        XmlWriteHandler xmlWriteHandler = (XmlWriteHandler)this.classToHandlerMapping.get(clazz);
        if (xmlWriteHandler != null) {
            return xmlWriteHandler;
        }
        if (!this.getFactoryLoader().canHandle(clazz)) {
            return null;
        }
        xmlWriteHandler = new GenericWriteHandler(this, this.getFactoryLoader().getFactoryForClass(clazz));
        return xmlWriteHandler;
    }

    public void write(String string, Object object, XMLWriter xMLWriter) throws IOException {
        if (object == null) {
            return;
        }
        XmlWriteHandler xmlWriteHandler = this.getMapping(object.getClass());
        if (xmlWriteHandler != null) {
            xmlWriteHandler.write(string, object, xMLWriter);
            xMLWriter.allowLineBreak();
        } else {
            this.writeFallBackSerialization(string, object, xMLWriter);
        }
    }

    private void writeFallBackSerialization(String string, Object object, XMLWriter xMLWriter) throws IOException {
        Class<?> clazz = object.getClass();
        if (!(object instanceof Serializable)) {
            System.out.println("Warning: Unable to handle " + clazz.toString());
            return;
        }
        AttributeList attributeList = new AttributeList();
        attributeList.setAttribute(TYPE_ATTR, TYPE_ATTR_VALUE);
        attributeList.setAttribute(CLASS_ATTR, clazz.getName());
        xMLWriter.writeTag(string, attributeList, false);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        xMLWriter.writeText(new String(Base64.encode(byteArrayOutputStream.toByteArray())));
        xMLWriter.writeCloseTag(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

