/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.collections;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.IteratorUtils;

public abstract class AbstractSingletonCollection
implements Collection {
    protected Object element;

    protected AbstractSingletonCollection(Object element) {
        this.element = element;
    }

    public abstract boolean isEmpty();

    protected abstract boolean removeElement();

    public int size() {
        return this.isEmpty() ? 0 : 1;
    }

    public boolean add(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object object) {
        return (this.element == object || this.element != null && this.element.equals(object)) && this.removeElement();
    }

    public boolean contains(Object object) {
        return (this.element == object || this.element != null && this.element.equals(object)) && !this.isEmpty();
    }

    public Iterator iterator() {
        return this.isEmpty() ? IteratorUtils.EMPTY_ITERATOR : new IteratorImpl();
    }

    public boolean containsAll(Collection c) {
        if (this.isEmpty()) {
            return c.isEmpty();
        }
        if (this.element == null) {
            Iterator i = c.iterator();
            while (i.hasNext()) {
                if (i.next() == null) continue;
                return false;
            }
        } else {
            Iterator i = c.iterator();
            while (i.hasNext()) {
                if (this.element.equals(i.next())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection c) {
        return c.contains(this.element) && this.removeElement();
    }

    public boolean retainAll(Collection c) {
        return !c.contains(this.element) && this.removeElement();
    }

    public void clear() {
        this.removeElement();
    }

    public Object[] toArray() {
        Object[] objectArray;
        if (this.isEmpty()) {
            objectArray = new Object[]{};
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.element;
        }
        return objectArray;
    }

    public Object[] toArray(Object[] a) {
        int size = this.size();
        if (size > 0) {
            if (a.length == 0) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), 1);
            }
            a[0] = this.element;
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        buf.append(this.element);
        buf.append("]");
        return buf.toString();
    }

    private class IteratorImpl
    implements Iterator {
        private boolean hasNext = true;
        private boolean elementRemoved = false;

        private IteratorImpl() {
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        public Object next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            this.hasNext = false;
            return AbstractSingletonCollection.this.element;
        }

        public void remove() {
            if (this.hasNext || this.elementRemoved) {
                throw new IllegalStateException();
            }
            AbstractSingletonCollection.this.removeElement();
            this.elementRemoved = true;
        }
    }
}

