/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.collections;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.Predicate;

public final class AnyPredicate
implements Predicate,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Collection predicates;

    public AnyPredicate(Predicate[] predicates) {
        this(Arrays.asList(predicates));
    }

    public AnyPredicate(Collection predicates) {
        this.predicates = predicates;
        if (predicates == null) {
            throw new NullPointerException("Predicate Collection is null.");
        }
    }

    public boolean evaluate(Object object) {
        Iterator i = this.predicates.iterator();
        while (i.hasNext()) {
            if (!((Predicate)i.next()).evaluate(object)) continue;
            return true;
        }
        return false;
    }

    public Collection getOperands() {
        return this.predicates;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AnyPredicate)) {
            return false;
        }
        AnyPredicate pred = (AnyPredicate)object;
        if (this.predicates.size() != pred.predicates.size()) {
            return false;
        }
        Iterator i = this.predicates.iterator();
        Iterator j = pred.predicates.iterator();
        while (i.hasNext()) {
            if (i.next().equals(j.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 17;
        Iterator i = this.predicates.iterator();
        while (i.hasNext()) {
            result = 37 * result + i.next().hashCode();
        }
        return result;
    }

    public String toString() {
        return "(ANY " + this.predicates + ")";
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        if (this.predicates == null) {
            throw new InvalidObjectException("Predicate Collection is null.");
        }
    }
}

