/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.collections;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;

public class CollectionWrapper
extends AbstractCollection {
    private Collection delegate;
    private boolean isInitialized = false;

    public CollectionWrapper(Collection delegate) {
        this.initialize(delegate);
    }

    protected CollectionWrapper() {
    }

    protected final void initialize(Collection collection) {
        if (this.isInitialized) {
            throw new IllegalStateException("This instance is already initialized.");
        }
        this.delegate = collection;
        if (collection == null) {
            throw new NullPointerException();
        }
        this.isInitialized = true;
    }

    protected final Collection getDelegate() {
        return this.delegate;
    }

    private void checkInit() throws IllegalStateException {
        if (!this.isInitialized) {
            throw new IllegalStateException("This instance has not been initialized.");
        }
    }

    protected Object wrapObject(Object object) {
        return object;
    }

    protected Object unwrapObject(Object object) {
        return object;
    }

    public int size() {
        this.checkInit();
        return this.delegate.size();
    }

    public boolean isEmpty() {
        this.checkInit();
        return this.delegate.isEmpty();
    }

    public void clear() {
        this.checkInit();
        this.delegate.clear();
    }

    public boolean add(Object object) {
        this.checkInit();
        return this.delegate.add(this.unwrapObject(object));
    }

    public boolean remove(Object object) {
        this.checkInit();
        return this.delegate.remove(this.unwrapObject(object));
    }

    public boolean contains(Object object) {
        this.checkInit();
        return this.delegate.contains(this.unwrapObject(object));
    }

    public Iterator iterator() {
        this.checkInit();
        return new IteratorWrapper(this.delegate.iterator());
    }

    public boolean addAll(Collection c) {
        this.checkInit();
        return super.addAll(c);
    }

    public boolean containsAll(Collection c) {
        this.checkInit();
        return super.containsAll(c);
    }

    public boolean removeAll(Collection c) {
        this.checkInit();
        return super.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        this.checkInit();
        return super.retainAll(c);
    }

    public Object[] toArray() {
        this.checkInit();
        return super.toArray();
    }

    public Object[] toArray(Object[] a) {
        this.checkInit();
        return super.toArray(a);
    }

    public String toString() {
        this.checkInit();
        return super.toString();
    }

    private class IteratorWrapper
    implements Iterator {
        private Iterator i;

        public IteratorWrapper(Iterator i) {
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public Object next() {
            return CollectionWrapper.this.wrapObject(this.i.next());
        }

        public void remove() {
            this.i.remove();
        }
    }
}

