/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.collections;

import com.phoenixst.collections.FilteredIterator;
import com.phoenixst.collections.TruePredicate;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.Predicate;

public class FilteredCollection
extends AbstractCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Collection collection;
    protected Predicate predicate;

    public FilteredCollection(Collection collection, Predicate predicate) {
        this.collection = collection;
        Object object = this.predicate = predicate != null ? predicate : TruePredicate.INSTANCE;
        if (collection == null) {
            throw new NullPointerException("Wrapped Collection is null.");
        }
    }

    public int size() {
        int size = 0;
        Iterator i = this.collection.iterator();
        while (i.hasNext()) {
            if (!this.predicate.evaluate(i.next())) continue;
            ++size;
        }
        return size;
    }

    public boolean isEmpty() {
        Iterator i = this.collection.iterator();
        while (i.hasNext()) {
            if (!this.predicate.evaluate(i.next())) continue;
            return false;
        }
        return true;
    }

    public boolean add(Object object) {
        if (!this.predicate.evaluate(object)) {
            throw new IllegalArgumentException("Element " + object + " does not satisfy predicate " + this.predicate);
        }
        return this.collection.add(object);
    }

    public boolean remove(Object object) {
        return this.predicate.evaluate(object) && this.collection.remove(object);
    }

    public boolean contains(Object object) {
        return this.predicate.evaluate(object) && this.collection.contains(object);
    }

    public Iterator iterator() {
        return new IteratorImpl();
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        if (this.collection == null) {
            throw new InvalidObjectException("Wrapped Collection is null.");
        }
        if (this.predicate == null) {
            throw new InvalidObjectException("Predicate is null.");
        }
    }

    protected class IteratorImpl
    extends FilteredIterator {
        public IteratorImpl() {
            super(FilteredCollection.this.collection.iterator(), FilteredCollection.this.predicate);
        }

        protected void remove(Object object) {
            FilteredCollection.this.collection.remove(object);
        }
    }
}

