/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Predicate;

public class FilteredIterator
implements Iterator {
    private Iterator i;
    private Predicate predicate;
    private Object current;
    private Object next;
    private boolean isCurrentValid;
    private boolean isNextValid;

    public FilteredIterator(Iterator i, Predicate predicate) {
        this.i = i;
        this.predicate = predicate;
        this.isCurrentValid = false;
        this.isNextValid = false;
    }

    public boolean hasNext() {
        if (!this.isNextValid) {
            while (this.i.hasNext()) {
                Object object = this.i.next();
                if (!this.predicate.evaluate(object)) continue;
                this.next = object;
                this.isNextValid = true;
                break;
            }
        }
        return this.isNextValid;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.current = this.next;
        this.isCurrentValid = true;
        this.isNextValid = false;
        return this.current;
    }

    public void remove() {
        if (!this.isCurrentValid) {
            throw new IllegalStateException();
        }
        if (!this.isNextValid) {
            this.i.remove();
        } else {
            this.remove(this.current);
        }
        this.isCurrentValid = false;
    }

    protected void remove(Object object) {
        throw new IllegalStateException("The remove() method cannot be called after hasNext() without an intervening call to next().");
    }
}

