/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IteratorChain
implements Iterator {
    private Iterator[] iteratorArray;
    private int index;

    public IteratorChain(Iterator[] iterators) {
        this.iteratorArray = iterators;
        this.index = 0;
    }

    public IteratorChain(Collection iterators) {
        this.iteratorArray = new Iterator[iterators.size()];
        this.iteratorArray = iterators.toArray(this.iteratorArray);
        this.index = 0;
    }

    public IteratorChain(Iterator a, Iterator b) {
        this.iteratorArray = new Iterator[]{a, b};
        this.index = 0;
    }

    public boolean hasNext() {
        for (int i = this.index; i < this.iteratorArray.length; ++i) {
            if (!this.iteratorArray[i].hasNext()) continue;
            return true;
        }
        return false;
    }

    public Object next() {
        while (this.index < this.iteratorArray.length) {
            if (this.iteratorArray[this.index].hasNext()) {
                return this.iteratorArray[this.index].next();
            }
            ++this.index;
        }
        throw new NoSuchElementException();
    }

    public void remove() {
        if (this.index >= this.iteratorArray.length) {
            throw new IllegalStateException();
        }
        this.iteratorArray[this.index].remove();
    }
}

