/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.collections;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LoggingSupport {
    private final Logger logger;
    private final Level level;

    public LoggingSupport(Logger logger) {
        this(logger, Level.DEBUG);
    }

    public LoggingSupport(Logger logger, Level level) {
        this.logger = logger;
        this.level = level;
        if (logger == null) {
            throw new NullPointerException();
        }
        if (level == null) {
            throw new NullPointerException();
        }
    }

    protected final Logger getLogger() {
        return this.logger;
    }

    protected final Level getLevel() {
        return this.level;
    }

    protected final boolean isLoggerEnabled() {
        return this.logger.isEnabledFor((Priority)this.level);
    }

    protected final void log(String message) {
        this.logger.log((Priority)this.level, (Object)message);
    }
}

