/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.collections;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.commons.collections.Predicate;

public final class OrPredicate
implements Predicate,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Predicate left;
    private final Predicate right;

    public OrPredicate(Predicate left, Predicate right) {
        this.left = left;
        this.right = right;
        if (left == null) {
            throw new NullPointerException("Left Predicate is null.");
        }
        if (right == null) {
            throw new NullPointerException("Right Predicate is null.");
        }
    }

    public boolean evaluate(Object object) {
        return this.left.evaluate(object) || this.right.evaluate(object);
    }

    public Predicate getLeftOperand() {
        return this.left;
    }

    public Predicate getRightOperand() {
        return this.right;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof OrPredicate)) {
            return false;
        }
        OrPredicate pred = (OrPredicate)object;
        return this.left.equals(pred.left) && this.right.equals(pred.right);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.left.hashCode();
        result = 37 * result + this.right.hashCode();
        return result;
    }

    public String toString() {
        return "(" + this.left + " OR " + this.right + ")";
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        if (this.left == null) {
            throw new InvalidObjectException("Left Predicate is null.");
        }
        if (this.right == null) {
            throw new InvalidObjectException("Right Predicate is null.");
        }
    }
}

