/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.collections;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

public class SynchronizedCollection
implements Collection,
Serializable {
    private static final long serialVersionUID = 1L;
    private Collection delegate;
    private Object mutex;

    public SynchronizedCollection(Collection delegate) {
        if (delegate == null) {
            throw new NullPointerException();
        }
        this.delegate = delegate;
        this.mutex = this;
    }

    public SynchronizedCollection(Collection delegate, Object mutex) {
        if (delegate == null || mutex == null) {
            throw new NullPointerException();
        }
        this.delegate = delegate;
        this.mutex = mutex;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        if (this.delegate == null) {
            throw new InvalidObjectException("Wrapped Collection is null.");
        }
        if (this.mutex == null) {
            throw new InvalidObjectException("Mutex is null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.mutex;
        synchronized (object) {
            return this.delegate.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.mutex;
        synchronized (object) {
            return this.delegate.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mutex;
        synchronized (object) {
            this.delegate.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            return this.delegate.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            return this.delegate.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            return this.delegate.contains(object);
        }
    }

    public Iterator iterator() {
        return this.delegate.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection c) {
        Object object = this.mutex;
        synchronized (object) {
            return this.delegate.addAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection c) {
        Object object = this.mutex;
        synchronized (object) {
            return this.delegate.containsAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection c) {
        Object object = this.mutex;
        synchronized (object) {
            return this.delegate.removeAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection c) {
        Object object = this.mutex;
        synchronized (object) {
            return this.delegate.retainAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        Object object = this.mutex;
        synchronized (object) {
            return this.delegate.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] a) {
        Object object = this.mutex;
        synchronized (object) {
            return this.delegate.toArray(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.mutex;
        synchronized (object) {
            return this.delegate.toString();
        }
    }
}

