/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.plexus;

import com.phoenixst.collections.EqualPredicate;
import com.phoenixst.collections.FalsePredicate;
import com.phoenixst.collections.FilteredCollection;
import com.phoenixst.collections.TruePredicate;
import com.phoenixst.plexus.Graph;
import com.phoenixst.plexus.GraphUtils;
import com.phoenixst.plexus.Traverser;
import com.phoenixst.plexus.util.AdjacentNodeCollection;
import com.phoenixst.plexus.util.EqualsTraverserPredicate;
import com.phoenixst.plexus.util.FilteredTraverser;
import com.phoenixst.plexus.util.IncidentEdgeCollection;
import com.phoenixst.plexus.util.SingletonEdgeCollection;
import com.phoenixst.plexus.util.SingletonNodeCollection;
import com.phoenixst.plexus.util.SingletonTraverser;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.collections.Predicate;

public abstract class AbstractGraph
implements Graph {
    protected AbstractGraph() {
    }

    protected abstract Collection nodes();

    protected abstract Collection edges();

    protected abstract Traverser traverser(Object var1);

    public boolean addNode(Object node) {
        throw new UnsupportedOperationException();
    }

    public boolean removeNode(Object node) {
        if (node == null) {
            Iterator i = this.nodes(null).iterator();
            while (i.hasNext()) {
                if (i.next() != null) continue;
                i.remove();
                return true;
            }
        } else {
            Iterator i = this.nodes(null).iterator();
            while (i.hasNext()) {
                if (!node.equals(i.next())) continue;
                i.remove();
                return true;
            }
        }
        return false;
    }

    public boolean containsNode(Object node) {
        if (node == null) {
            Iterator i = this.nodes(null).iterator();
            while (i.hasNext()) {
                if (i.next() != null) continue;
                return true;
            }
        } else {
            Iterator i = this.nodes(null).iterator();
            while (i.hasNext()) {
                if (!node.equals(i.next())) continue;
                return true;
            }
        }
        return false;
    }

    public Graph.Edge addEdge(Object object, Object tail, Object head, boolean isDirected) {
        throw new UnsupportedOperationException();
    }

    public boolean removeEdge(Graph.Edge edge) {
        if (edge != null) {
            Object tail = edge.getTail();
            if (!this.containsNode(tail)) {
                return false;
            }
            Traverser t = this.traverser(tail, null);
            while (t.hasNext()) {
                t.next();
                if (!((Object)edge).equals(t.getEdge())) continue;
                t.removeEdge();
                return true;
            }
        }
        return false;
    }

    public boolean containsEdge(Graph.Edge edge) {
        if (edge != null) {
            Object tail = edge.getTail();
            if (!this.containsNode(tail)) {
                return false;
            }
            Traverser t = this.traverser(tail, null);
            while (t.hasNext()) {
                t.next();
                if (!((Object)edge).equals(t.getEdge())) continue;
                return true;
            }
        }
        return false;
    }

    public int degree(Object node) {
        int count = 0;
        Traverser t = this.traverser(node, null);
        while (t.hasNext()) {
            Object adjNode = t.next();
            if (node == null ? adjNode == null : node.equals(adjNode)) {
                ++count;
            }
            ++count;
        }
        return count;
    }

    public int degree(Object node, Predicate traverserPredicate) {
        int count = 0;
        Traverser t = this.traverser(node, traverserPredicate);
        while (t.hasNext()) {
            t.next();
            ++count;
        }
        return count;
    }

    public Collection nodes(Predicate nodePredicate) {
        if (nodePredicate == null || nodePredicate == TruePredicate.INSTANCE) {
            return this.nodes();
        }
        if (nodePredicate == FalsePredicate.INSTANCE) {
            return Collections.EMPTY_SET;
        }
        if (nodePredicate instanceof EqualPredicate) {
            Object testNode = ((EqualPredicate)nodePredicate).getTestObject();
            if (!this.containsNode(testNode)) {
                return Collections.EMPTY_SET;
            }
            return new SingletonNodeCollection(this, testNode);
        }
        return new FilteredCollection(this.nodes(), nodePredicate);
    }

    public Collection edges(Predicate edgePredicate) {
        if (edgePredicate == null || edgePredicate == TruePredicate.INSTANCE) {
            return this.edges();
        }
        if (edgePredicate == FalsePredicate.INSTANCE) {
            return Collections.EMPTY_SET;
        }
        if (edgePredicate instanceof EqualPredicate) {
            Graph.Edge testEdge = (Graph.Edge)((EqualPredicate)edgePredicate).getTestObject();
            if (!this.containsEdge(testEdge)) {
                return Collections.EMPTY_SET;
            }
            return new SingletonEdgeCollection(this, testEdge);
        }
        return new FilteredCollection(this.edges(), edgePredicate);
    }

    public Collection adjacentNodes(Object node, Predicate traverserPredicate) {
        return new AdjacentNodeCollection(this, node, traverserPredicate);
    }

    public Collection incidentEdges(Object node, Predicate traverserPredicate) {
        return new IncidentEdgeCollection(this, node, traverserPredicate);
    }

    public Object getNode(Predicate nodePredicate) {
        Iterator i = this.nodes(nodePredicate).iterator();
        return i.hasNext() ? i.next() : null;
    }

    public Graph.Edge getEdge(Predicate edgePredicate) {
        Iterator i = this.edges(edgePredicate).iterator();
        return i.hasNext() ? (Graph.Edge)i.next() : null;
    }

    public Object getAdjacentNode(Object node, Predicate traverserPredicate) {
        Graph.Edge edge = this.getIncidentEdge(node, traverserPredicate);
        return edge != null ? edge.getOtherEndpoint(node) : null;
    }

    public Graph.Edge getIncidentEdge(Object node, Predicate traverserPredicate) {
        Traverser t = this.traverser(node, traverserPredicate);
        if (!t.hasNext()) {
            return null;
        }
        t.next();
        return t.getEdge();
    }

    public Traverser traverser(Object node, Predicate traverserPredicate) {
        if (traverserPredicate == null || traverserPredicate == TruePredicate.INSTANCE) {
            return this.traverser(node);
        }
        if (traverserPredicate == FalsePredicate.INSTANCE) {
            return GraphUtils.EMPTY_TRAVERSER;
        }
        if (traverserPredicate instanceof EqualsTraverserPredicate) {
            Graph.Edge testEdge = ((EqualsTraverserPredicate)traverserPredicate).getTestEdge();
            return (GraphUtils.equals(node, testEdge.getTail()) || GraphUtils.equals(node, testEdge.getHead())) && this.containsEdge(testEdge) ? new SingletonTraverser(this, testEdge.getOtherEndpoint(node), testEdge) : GraphUtils.EMPTY_TRAVERSER;
        }
        return new FilteredTraverser(this.traverser(node), traverserPredicate);
    }
}

