/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.plexus;

import com.phoenixst.collections.EqualPredicate;
import com.phoenixst.collections.FalsePredicate;
import com.phoenixst.collections.FilteredCollection;
import com.phoenixst.collections.OrderedPair;
import com.phoenixst.collections.ReapableCollection;
import com.phoenixst.collections.TruePredicate;
import com.phoenixst.plexus.EdgePredicate;
import com.phoenixst.plexus.Graph;
import com.phoenixst.plexus.GraphListener;
import com.phoenixst.plexus.GraphUtils;
import com.phoenixst.plexus.NoSuchNodeException;
import com.phoenixst.plexus.ObservableGraph;
import com.phoenixst.plexus.Traverser;
import com.phoenixst.plexus.TraverserPredicate;
import com.phoenixst.plexus.util.DefaultObjectEdge;
import com.phoenixst.plexus.util.EqualsTraverserPredicate;
import com.phoenixst.plexus.util.ObservableGraphDelegate;
import com.phoenixst.plexus.util.SingletonEdgeCollection;
import com.phoenixst.plexus.util.SingletonNodeCollection;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Predicate;
import org.apache.log4j.Logger;

public class DefaultGraph
implements ObservableGraph,
Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger DEFAULT_LOGGER = Logger.getLogger((Class)(class$com$phoenixst$plexus$DefaultGraph == null ? (class$com$phoenixst$plexus$DefaultGraph = DefaultGraph.class$("com.phoenixst.plexus.DefaultGraph")) : class$com$phoenixst$plexus$DefaultGraph));
    private static final Logger DEFAULT_EVENT_LOGGER = Logger.getLogger((String)((class$com$phoenixst$plexus$DefaultGraph == null ? (class$com$phoenixst$plexus$DefaultGraph = DefaultGraph.class$("com.phoenixst.plexus.DefaultGraph")) : class$com$phoenixst$plexus$DefaultGraph).getName() + ".Event"));
    private static final int TYPE_ANY = 0;
    private static final int TYPE_EQUALS_PREDICATE = 1;
    private static final int TYPE_PREDICATE = 2;
    private static final int TYPE_OBJECT = 3;
    static final Cursor EMPTY_CURSOR = new Cursor(){

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new IllegalStateException();
        }

        public AdjacencyList getAdjacencyList() {
            throw new IllegalStateException();
        }

        public Graph.Edge getCurrentEdge() {
            throw new IllegalStateException();
        }

        public Object getOtherNode() {
            throw new IllegalStateException();
        }

        public void removeOtherNode() {
            throw new IllegalStateException();
        }

        public void edgeRemoved(int index) {
        }
    };
    static final CursorFilter FALSE_CURSOR_FILTER = new CursorFilter(){

        public boolean evaluate(Object baseNode, Graph.Edge edge) {
            return false;
        }
    };
    static final CursorFilter DIRECTED_CURSOR_FILTER = new CursorFilter(){

        public boolean evaluate(Object baseNode, Graph.Edge edge) {
            return edge.isDirected();
        }
    };
    static final CursorFilter UNDIRECTED_CURSOR_FILTER = new CursorFilter(){

        public boolean evaluate(Object baseNode, Graph.Edge edge) {
            return !edge.isDirected();
        }
    };
    static final CursorFilter BASE_TAIL_CURSOR_FILTER = new CursorFilter(){

        public boolean evaluate(Object baseNode, Graph.Edge edge) {
            return GraphUtils.equals(baseNode, edge.getTail());
        }
    };
    static final CursorFilter BASE_TAIL_DIRECTED_CURSOR_FILTER = new CursorFilter(){

        public boolean evaluate(Object baseNode, Graph.Edge edge) {
            return edge.isDirected() && GraphUtils.equals(baseNode, edge.getTail());
        }
    };
    static final CursorFilter BASE_HEAD_DIRECTED_CURSOR_FILTER = new CursorFilter(){

        public boolean evaluate(Object baseNode, Graph.Edge edge) {
            return edge.isDirected() && GraphUtils.equals(baseNode, edge.getHead());
        }
    };
    static final CursorFilter BASE_TAIL_UNDIRECTED_CURSOR_FILTER = new CursorFilter(){

        public boolean evaluate(Object baseNode, Graph.Edge edge) {
            return !edge.isDirected() && GraphUtils.equals(baseNode, edge.getTail());
        }
    };
    static final CursorFilter SELF_CURSOR_FILTER = new CursorFilter(){

        public boolean evaluate(Object baseNode, Graph.Edge edge) {
            return GraphUtils.equals(edge.getTail(), edge.getHead());
        }
    };
    transient Map nodeMap;
    transient int edgeSize;
    private transient Collection nodeCollection;
    private transient Collection edgeCollection;
    private transient ObservableGraphDelegate observableDelegate;
    transient Logger logger;
    private transient Logger eventLogger;
    transient String instanceString;
    transient Collection cursors;
    static /* synthetic */ Class class$com$phoenixst$plexus$DefaultGraph;

    public DefaultGraph() {
        this.init(16, DEFAULT_LOGGER, DEFAULT_EVENT_LOGGER);
    }

    public DefaultGraph(Graph g) {
        this.init(g.nodes(null).size(), DEFAULT_LOGGER, DEFAULT_EVENT_LOGGER);
        GraphUtils.add(this, g);
    }

    protected DefaultGraph(Logger logger, Logger eventLogger) {
        this.init(16, logger, eventLogger);
    }

    protected DefaultGraph(Graph g, Logger logger, Logger eventLogger) {
        this.init(g.nodes(null).size(), logger, eventLogger);
        GraphUtils.add(this, g);
    }

    private void init(int nodeSize, Logger instanceLogger, Logger instanceEventLogger) {
        this.nodeMap = new HashMap(nodeSize);
        this.logger = instanceLogger;
        this.eventLogger = instanceEventLogger;
        if (this.logger == null) {
            throw new NullPointerException("Logger cannot be null.");
        }
        if (this.eventLogger == null) {
            throw new NullPointerException("Event Logger cannot be null.");
        }
        this.instanceString = "(" + System.identityHashCode(this) + ")";
        this.edgeSize = 0;
        this.nodeCollection = new AllNodesCollection();
        this.edgeCollection = new AllEdgesCollection();
        this.cursors = new ReapableCollection();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Serializing " + this.instanceString));
        }
        out.defaultWriteObject();
        out.writeInt(this.nodeMap.size());
        Iterator<Object> i = this.nodeMap.keySet().iterator();
        while (i.hasNext()) {
            out.writeObject(i.next());
        }
        out.writeInt(this.edgeSize);
        i = this.edgeCollection.iterator();
        while (i.hasNext()) {
            out.writeObject(i.next());
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        int i;
        in.defaultReadObject();
        int nodeSize = in.readInt();
        if (nodeSize < 0) {
            throw new InvalidObjectException("Node size is less than 0: " + nodeSize);
        }
        this.init(nodeSize, DEFAULT_LOGGER, DEFAULT_EVENT_LOGGER);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Deserializing " + this.instanceString));
        }
        for (i = 0; i < nodeSize; ++i) {
            Object node = in.readObject();
            if (this.nodeMap.containsKey(node)) {
                throw new InvalidObjectException("Duplicate node: " + node);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("  " + this.instanceString + " deserialization: Adding node " + node));
            }
            this.nodeMap.put(node, new AdjacencyList(node));
        }
        this.edgeSize = in.readInt();
        if (this.edgeSize < 0) {
            throw new InvalidObjectException("Edge size is less than 0: " + this.edgeSize);
        }
        for (i = 0; i < this.edgeSize; ++i) {
            Graph.Edge edge = (Graph.Edge)in.readObject();
            AdjacencyList tailAdj = (AdjacencyList)this.nodeMap.get(edge.getTail());
            if (tailAdj == null) {
                throw new InvalidObjectException("Graph.Edge tail is not a node: " + edge.getTail());
            }
            if (tailAdj.contains(edge)) {
                throw new InvalidObjectException("Duplicate edge: " + edge);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("  " + this.instanceString + " deserialization: Adding edge " + edge));
            }
            tailAdj.edges.add(edge);
            if (GraphUtils.equals(edge.getTail(), edge.getHead())) continue;
            AdjacencyList headAdj = (AdjacencyList)this.nodeMap.get(edge.getHead());
            if (headAdj == null) {
                throw new InvalidObjectException("Graph.Edge head is not a node: " + edge.getHead());
            }
            headAdj.edges.add(edge);
        }
    }

    protected Graph.Edge createEdge(Object object, Object tail, Object head, boolean isDirected) {
        return new DefaultObjectEdge(object, tail, head, isDirected);
    }

    protected void nodeAdding(Object node) {
    }

    protected void nodeAdded(Object node) {
    }

    protected void nodeRemoving(Object node) {
    }

    protected void nodeRemoved(Object node) {
    }

    protected void edgeAdding(Graph.Edge edge) {
    }

    protected void edgeAdded(Graph.Edge edge) {
    }

    protected void edgeRemoving(Graph.Edge edge) {
    }

    protected void edgeRemoved(Graph.Edge edge) {
    }

    void alertEdgeAdded(AdjacencyList adj) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void alertEdgeRemoved(AdjacencyList adj, int index) {
        Collection collection = this.cursors;
        synchronized (collection) {
            Iterator i = this.cursors.iterator();
            while (i.hasNext()) {
                Cursor cursor = (Cursor)i.next();
                if (adj != cursor.getAdjacencyList()) continue;
                cursor.edgeRemoved(index);
            }
        }
    }

    void processNodeAdded(Object node) {
        if (this.observableDelegate != null) {
            this.observableDelegate.fireNodeAdded(node);
        }
    }

    void processNodeRemoved(Object node) {
        if (this.observableDelegate != null) {
            this.observableDelegate.fireNodeRemoved(node);
        }
    }

    void processEdgeAdded(Graph.Edge edge) {
        ++this.edgeSize;
        if (this.observableDelegate != null) {
            this.observableDelegate.fireEdgeAdded(edge);
        }
    }

    void processEdgeRemoved(Graph.Edge edge) {
        --this.edgeSize;
        if (this.observableDelegate != null) {
            this.observableDelegate.fireEdgeRemoved(edge);
        }
    }

    private String debugToString() {
        StringBuffer s = new StringBuffer();
        String className = this.getClass().getName();
        s.append(className.substring(className.lastIndexOf(46) + 1));
        s.append(this.instanceString);
        s.append(" ( ");
        s.append(this.nodeCollection.size() + " nodes, ");
        s.append(this.edgeCollection.size() + " edges");
        s.append(" ): ");
        s.append("\n[");
        Iterator i = this.nodeMap.entrySet().iterator();
        while (i.hasNext()) {
            s.append("\n  ");
            s.append(i.next());
        }
        s.append("\n]");
        return s.toString();
    }

    private AdjacencyList checkNode(Object node) {
        AdjacencyList adj = (AdjacencyList)this.nodeMap.get(node);
        if (adj == null) {
            throw new NoSuchNodeException("Node is not in this graph: " + node);
        }
        return adj;
    }

    private static int getTestType(Object object) {
        if (object == TruePredicate.INSTANCE) {
            return 0;
        }
        if (object instanceof EqualPredicate) {
            return 1;
        }
        if (object instanceof Predicate) {
            return 2;
        }
        return 3;
    }

    private static Predicate toPredicate(Object object) {
        return object instanceof Predicate ? (Predicate)object : new EqualPredicate(object);
    }

    private CursorFilter createCursorFilter(Object node, Object userObject, int directionFlags) {
        Predicate userPredicate = DefaultGraph.toPredicate(userObject);
        int nodeType = DefaultGraph.getTestType(node);
        if (nodeType == 1) {
            node = ((EqualPredicate)node).getTestObject();
        }
        if (nodeType == 0) {
            return new ToAnyCursorFilter(directionFlags, userPredicate);
        }
        if (nodeType == 2) {
            return new ToPredCursorFilter(directionFlags, (Predicate)node, userPredicate);
        }
        AdjacencyList adj = (AdjacencyList)this.nodeMap.get(node);
        if (adj == null) {
            return FALSE_CURSOR_FILTER;
        }
        return new ToEqualsCursorFilter(directionFlags, adj.node, userPredicate);
    }

    private CursorFilter createCursorFilter(Predicate traverserPredicate) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("  " + this.instanceString + ".createCursorFilter( " + traverserPredicate + " )"));
        }
        if (traverserPredicate == null || traverserPredicate == TruePredicate.INSTANCE) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("    " + this.instanceString + ".createCursorFilter() returning null (true) filter"));
            }
            return null;
        }
        if (traverserPredicate == FalsePredicate.INSTANCE) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("    " + this.instanceString + ".createCursorFilter() returning false filter"));
            }
            return FALSE_CURSOR_FILTER;
        }
        if (traverserPredicate == GraphUtils.OUT_TRAVERSER_PREDICATE) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("    " + this.instanceString + ".createCursorFilter() returning directed out filter"));
            }
            return BASE_TAIL_DIRECTED_CURSOR_FILTER;
        }
        if (traverserPredicate == GraphUtils.IN_TRAVERSER_PREDICATE) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("    " + this.instanceString + ".createCursorFilter() returning directed in filter"));
            }
            return BASE_HEAD_DIRECTED_CURSOR_FILTER;
        }
        if (traverserPredicate == GraphUtils.DIRECTED_TRAVERSER_PREDICATE) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("    " + this.instanceString + ".createCursorFilter() returning directed filter"));
            }
            return DIRECTED_CURSOR_FILTER;
        }
        if (traverserPredicate == GraphUtils.UNDIRECTED_TRAVERSER_PREDICATE) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("    " + this.instanceString + ".createCursorFilter() returning undirected filter"));
            }
            return UNDIRECTED_CURSOR_FILTER;
        }
        if (traverserPredicate == GraphUtils.SELF_TRAVERSER_PREDICATE) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("    " + this.instanceString + ".createCursorFilter() returning self filter"));
            }
            return SELF_CURSOR_FILTER;
        }
        if (traverserPredicate instanceof TraverserPredicate) {
            TraverserPredicate predicate = (TraverserPredicate)traverserPredicate;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("    " + this.instanceString + ".createCursorFilter() returning optimized filter"));
            }
            return this.createCursorFilter(predicate.getNodeSpecification(), predicate.getUserObjectSpecification(), predicate.getDirectionFlags());
        }
        if (traverserPredicate instanceof EqualsTraverserPredicate) {
            Graph.Edge edge = ((EqualsTraverserPredicate)traverserPredicate).getTestEdge();
            AdjacencyList tailAdj = (AdjacencyList)this.nodeMap.get(edge.getTail());
            AdjacencyList headAdj = (AdjacencyList)this.nodeMap.get(edge.getHead());
            if (tailAdj == null || headAdj == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("    " + this.instanceString + ".createCursorFilter() returning false filter"));
                }
                return FALSE_CURSOR_FILTER;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("    " + this.instanceString + ".createCursorFilter() returning optimized filter"));
            }
            return new EqualsCursorFilter(edge);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("    " + this.instanceString + ".createCursorFilter() returning general filter"));
        }
        return new GeneralTraverserCursorFilter(traverserPredicate);
    }

    public boolean addNode(Object node) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.instanceString + ".addNode( " + node + " )"));
        }
        if (this.nodeMap.containsKey(node)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("  " + this.instanceString + ".addNode() returning false"));
            }
            return false;
        }
        this.nodeAdding(node);
        this.nodeMap.put(node, new AdjacencyList(node));
        this.processNodeAdded(node);
        this.nodeAdded(node);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("  " + this.instanceString + ".addNode() returning true"));
        }
        return true;
    }

    public boolean removeNode(Object node) {
        AdjacencyList adj;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.instanceString + ".removeNode( " + node + " )"));
        }
        if ((adj = (AdjacencyList)this.nodeMap.get(node)) == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("  " + this.instanceString + ".removeNode() returning false"));
            }
            return false;
        }
        this.nodeRemoving(node);
        adj.clear();
        this.nodeMap.remove(node);
        this.processNodeRemoved(node);
        this.nodeRemoved(adj.node);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("  " + this.instanceString + ".removeNode() returning true"));
        }
        return true;
    }

    public boolean containsNode(Object node) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.instanceString + ".containsNode( " + node + " )"));
        }
        boolean contains = this.nodeMap.containsKey(node);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("  " + this.instanceString + ".containsNode() returning " + contains));
        }
        return contains;
    }

    public Graph.Edge addEdge(Object object, Object tail, Object head, boolean isDirected) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.instanceString + ".addEdge( " + object + ", " + tail + ", " + head + ", " + isDirected + " )"));
        }
        AdjacencyList tailAdj = this.checkNode(tail);
        AdjacencyList headAdj = this.checkNode(head);
        Graph.Edge edge = tailAdj.addTo(object, headAdj, isDirected);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("  " + this.instanceString + ".addEdge() returning " + edge));
        }
        return edge;
    }

    public boolean removeEdge(Graph.Edge edge) {
        AdjacencyList tailAdj;
        boolean modified;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.instanceString + ".removeEdge( " + edge + " )"));
        }
        boolean bl = modified = (tailAdj = (AdjacencyList)this.nodeMap.get(edge.getTail())) != null && tailAdj.remove(edge);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("  " + this.instanceString + ".removeEdge() returning " + modified));
        }
        return modified;
    }

    public boolean containsEdge(Graph.Edge edge) {
        AdjacencyList tailAdj;
        boolean contains;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.instanceString + ".containsEdge( " + edge + " )"));
        }
        boolean bl = contains = (tailAdj = (AdjacencyList)this.nodeMap.get(edge.getTail())) != null && tailAdj.contains(edge);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("  " + this.instanceString + ".containsEdge() returning " + contains));
        }
        return contains;
    }

    public int degree(Object node) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.instanceString + ".degree( " + node + " )"));
        }
        int degree = this.checkNode(node).degree();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("  " + this.instanceString + ".degree() returning " + degree));
        }
        return degree;
    }

    public int degree(Object node, Predicate traverserPredicate) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.instanceString + ".degree( " + node + ", " + traverserPredicate + " )"));
        }
        AdjacencyList adj = this.checkNode(node);
        int degree = traverserPredicate == null || traverserPredicate == TruePredicate.INSTANCE ? adj.size() : (traverserPredicate == FalsePredicate.INSTANCE ? 0 : (traverserPredicate == GraphUtils.OUT_TRAVERSER_PREDICATE ? adj.outDegree() : (traverserPredicate == GraphUtils.IN_TRAVERSER_PREDICATE ? adj.inDegree() : adj.degree(traverserPredicate))));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("  " + this.instanceString + ".degree() returning " + degree));
        }
        return degree;
    }

    public Collection nodes(Predicate nodePredicate) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.instanceString + ".nodes( " + nodePredicate + " )"));
        }
        if (nodePredicate == null || nodePredicate == TruePredicate.INSTANCE) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("  " + this.instanceString + ".nodes() returning all nodes"));
            }
            return this.nodeCollection;
        }
        if (nodePredicate == FalsePredicate.INSTANCE) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("  " + this.instanceString + ".nodes() returning empty set"));
            }
            return Collections.EMPTY_SET;
        }
        if (nodePredicate instanceof EqualPredicate) {
            Object testNode = ((EqualPredicate)nodePredicate).getTestObject();
            if (!this.containsNode(testNode)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("  " + this.instanceString + ".nodes() returning empty set"));
                }
                return Collections.EMPTY_SET;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("  " + this.instanceString + ".nodes() returning singleton"));
            }
            return new SingletonNodeCollection(this, testNode);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("  " + this.instanceString + ".nodes() returning general filtered collection"));
        }
        return new FilteredCollection(this.nodeCollection, nodePredicate);
    }

    private Collection edgesHelper(EdgePredicate edgePredicate) {
        Object nodeA = edgePredicate.getFirstNodeSpecification();
        Object nodeB = edgePredicate.getSecondNodeSpecification();
        Object userObject = edgePredicate.getUserObjectSpecification();
        int directionFlags = edgePredicate.getDirectionFlags();
        int nodeAType = DefaultGraph.getTestType(nodeA);
        if (nodeAType == 1 || nodeAType == 3) {
            CursorFilter filter;
            AdjacencyList adj;
            if (nodeAType == 1) {
                nodeA = ((EqualPredicate)nodeA).getTestObject();
            }
            if ((adj = (AdjacencyList)this.nodeMap.get(nodeA)) != null && (filter = this.createCursorFilter(nodeB, userObject, directionFlags)) != FALSE_CURSOR_FILTER) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("  " + this.instanceString + ".edges() returning some edges incident to " + adj.node));
                }
                return new IncEdgeCollection(adj, filter);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("  " + this.instanceString + ".edges() returning empty set"));
            }
            return Collections.EMPTY_SET;
        }
        int nodeBType = DefaultGraph.getTestType(nodeB);
        if (nodeBType == 1 || nodeBType == 3) {
            CursorFilter filter;
            AdjacencyList adj;
            if (nodeBType == 1) {
                nodeB = ((EqualPredicate)nodeB).getTestObject();
            }
            if ((adj = (AdjacencyList)this.nodeMap.get(nodeB)) != null && (filter = this.createCursorFilter(nodeA, userObject, GraphUtils.invertDirection(directionFlags))) != FALSE_CURSOR_FILTER) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("  " + this.instanceString + ".edges() returning some edges incident to " + adj.node));
                }
                return new IncEdgeCollection(adj, filter);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("  " + this.instanceString + ".edges() returning empty set"));
            }
            return Collections.EMPTY_SET;
        }
        Predicate userPredicate = DefaultGraph.toPredicate(userObject);
        if (nodeAType == 0 && nodeBType == 0) {
            if (userPredicate == TruePredicate.INSTANCE) {
                if ((directionFlags & 1) == 0) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("  " + this.instanceString + ".edges() returning all directed edges"));
                    }
                    return new AnyToAnyEdgeCollection(GraphUtils.DIRECTED_EDGE_PREDICATE, BASE_TAIL_DIRECTED_CURSOR_FILTER);
                }
                if ((directionFlags & 6) == 0) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("  " + this.instanceString + ".edges() returning all undirected edges"));
                    }
                    return new AnyToAnyEdgeCollection(GraphUtils.UNDIRECTED_EDGE_PREDICATE, BASE_TAIL_UNDIRECTED_CURSOR_FILTER);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("  " + this.instanceString + ".edges() returning all edges"));
                }
                return this.edgeCollection;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("  " + this.instanceString + ".edges() returning general filtered collection"));
            }
            return new AnyToAnyEdgeCollection(edgePredicate, new AnyToAnyCursorFilter(directionFlags, userPredicate));
        }
        if (nodeAType == 0) {
            nodeA = nodeB;
            nodeB = TruePredicate.INSTANCE;
            nodeBType = 0;
            directionFlags = GraphUtils.invertDirection(directionFlags);
        }
        Predicate basePredicate = (Predicate)nodeA;
        if (nodeBType == 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("  " + this.instanceString + ".edges() returning optimized filtered collection"));
            }
            return new PredToAnyEdgeCollection(edgePredicate, basePredicate, new PredToAnyCursorFilter(directionFlags, basePredicate, userPredicate));
        }
        PQToQCursorFilter qFilter = new PQToQCursorFilter(directionFlags, basePredicate, (Predicate)nodeB, userPredicate);
        ToPredCursorFilter notQFilter = new ToPredCursorFilter(directionFlags, (Predicate)nodeB, userPredicate);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("  " + this.instanceString + ".edges() returning optimized filtered collection"));
        }
        return new PToQEdgeCollection(edgePredicate, basePredicate, (Predicate)nodeB, qFilter, notQFilter);
    }

    public Collection edges(Predicate edgePredicate) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.instanceString + ".edges( " + edgePredicate + " )"));
        }
        if (edgePredicate == null || edgePredicate == TruePredicate.INSTANCE) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("  " + this.instanceString + ".edges() returning all edges"));
            }
            return this.edgeCollection;
        }
        if (edgePredicate == FalsePredicate.INSTANCE) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("  " + this.instanceString + ".edges() returning empty set"));
            }
            return Collections.EMPTY_SET;
        }
        if (edgePredicate == GraphUtils.DIRECTED_EDGE_PREDICATE) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("  " + this.instanceString + ".edges() returning all directed edges"));
            }
            return new AnyToAnyEdgeCollection(GraphUtils.DIRECTED_EDGE_PREDICATE, BASE_TAIL_DIRECTED_CURSOR_FILTER);
        }
        if (edgePredicate == GraphUtils.UNDIRECTED_EDGE_PREDICATE) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("  " + this.instanceString + ".edges() returning all undirected edges"));
            }
            return new AnyToAnyEdgeCollection(GraphUtils.UNDIRECTED_EDGE_PREDICATE, BASE_TAIL_UNDIRECTED_CURSOR_FILTER);
        }
        if (edgePredicate == GraphUtils.SELF_EDGE_PREDICATE) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("  " + this.instanceString + ".edges() returning all self edges"));
            }
            return new AnyToAnyEdgeCollection(GraphUtils.SELF_EDGE_PREDICATE, SELF_CURSOR_FILTER);
        }
        if (edgePredicate instanceof EdgePredicate) {
            return this.edgesHelper((EdgePredicate)edgePredicate);
        }
        if (edgePredicate instanceof EqualPredicate) {
            Graph.Edge testEdge = (Graph.Edge)((EqualPredicate)edgePredicate).getTestObject();
            if (!this.containsEdge(testEdge)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("  " + this.instanceString + ".edges() returning empty set"));
                }
                return Collections.EMPTY_SET;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("  " + this.instanceString + ".edges() returning singleton"));
            }
            return new SingletonEdgeCollection(this, testEdge);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("  " + this.instanceString + ".edges() returning general filtered collection"));
        }
        return new AnyToAnyEdgeCollection(edgePredicate, new BTailCursorFilter(edgePredicate));
    }

    public Collection adjacentNodes(Object node, Predicate traverserPredicate) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.instanceString + ".adjacentNodes( " + node + ", " + traverserPredicate + " )"));
        }
        AdjacencyList adj = this.checkNode(node);
        CursorFilter filter = this.createCursorFilter(traverserPredicate);
        if (filter == FALSE_CURSOR_FILTER) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("  " + this.instanceString + ".adjacentNodes() returning empty set"));
            }
            return Collections.EMPTY_SET;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("  " + this.instanceString + ".adjacentNodes() returning filtered collection"));
        }
        return new AdjNodeCollection(adj, filter);
    }

    public Collection incidentEdges(Object node, Predicate traverserPredicate) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.instanceString + ".incidentEdges( " + node + ", " + traverserPredicate + " )"));
        }
        AdjacencyList adj = this.checkNode(node);
        CursorFilter filter = this.createCursorFilter(traverserPredicate);
        if (filter == FALSE_CURSOR_FILTER) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("  " + this.instanceString + ".incidentEdges() returning empty set"));
            }
            return Collections.EMPTY_SET;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("  " + this.instanceString + ".incidentEdges() returning filtered collection"));
        }
        return new IncEdgeCollection(adj, filter);
    }

    public Object getNode(Predicate nodePredicate) {
        Object node;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.instanceString + ".getNode( " + nodePredicate + " )"));
        }
        if (nodePredicate == null || nodePredicate == TruePredicate.INSTANCE) {
            Iterator i = this.nodeMap.keySet().iterator();
            node = i.hasNext() ? (Object)i.next() : null;
        } else if (nodePredicate == FalsePredicate.INSTANCE) {
            node = null;
        } else if (nodePredicate instanceof EqualPredicate) {
            Object testNode = ((EqualPredicate)nodePredicate).getTestObject();
            AdjacencyList adj = (AdjacencyList)this.nodeMap.get(testNode);
            node = adj != null ? adj.node : null;
        } else {
            node = null;
            Iterator i = this.nodeMap.keySet().iterator();
            while (i.hasNext()) {
                Object testNode = i.next();
                if (!nodePredicate.evaluate(testNode)) continue;
                node = testNode;
                break;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("  " + this.instanceString + ".getNode() returning " + node));
        }
        return node;
    }

    public Graph.Edge getEdge(Predicate edgePredicate) {
        Graph.Edge edge;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.instanceString + ".getEdge( " + edgePredicate + " )"));
        }
        if (edgePredicate == FalsePredicate.INSTANCE) {
            edge = null;
        } else if (edgePredicate instanceof EqualPredicate) {
            Graph.Edge testEdge = (Graph.Edge)((EqualPredicate)edgePredicate).getTestObject();
            edge = this.containsEdge(testEdge) ? testEdge : null;
        } else {
            Collection edges = this.edges(edgePredicate);
            if (edges instanceof EdgeCollection) {
                edge = ((EdgeCollection)edges).get();
            } else {
                Iterator i = edges.iterator();
                Graph.Edge edge2 = edge = i.hasNext() ? (Graph.Edge)i.next() : null;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("  " + this.instanceString + ".getEdge() returning " + edge));
        }
        return edge;
    }

    public Object getAdjacentNode(Object node, Predicate traverserPredicate) {
        Graph.Edge edge;
        Object returnNode;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.instanceString + ".getAdjacentNode( " + node + ", " + traverserPredicate + " )"));
        }
        Object object = returnNode = (edge = this.getIncidentEdge(node, traverserPredicate)) != null ? edge.getOtherEndpoint(node) : null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("  " + this.instanceString + ".getAdjacentNode() returning " + returnNode));
        }
        return returnNode;
    }

    public Graph.Edge getIncidentEdge(Object node, Predicate traverserPredicate) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.instanceString + ".getIncidentEdge( " + node + ", " + traverserPredicate + " )"));
        }
        AdjacencyList adj = this.checkNode(node);
        Graph.Edge edge = adj.get(this.createCursorFilter(traverserPredicate));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("  " + this.instanceString + ".getIncidentEdge() returning " + edge));
        }
        return edge;
    }

    public Traverser traverser(Object node, Predicate traverserPredicate) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.instanceString + ".traverser( " + node + ", " + traverserPredicate + " )"));
        }
        AdjacencyList adj = this.checkNode(node);
        CursorTraverserAdapter t = new CursorTraverserAdapter(adj.cursor(this.createCursorFilter(traverserPredicate)));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("  " + this.instanceString + ".traverser() returning"));
        }
        return t;
    }

    public synchronized void addGraphListener(GraphListener listener) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.instanceString + ".addGraphListener( " + listener + " )"));
        }
        if (this.observableDelegate == null) {
            this.observableDelegate = new ObservableGraphDelegate(this, this.eventLogger);
        }
        this.observableDelegate.addGraphListener(listener);
    }

    public synchronized void removeGraphListener(GraphListener listener) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.instanceString + ".removeGraphListener( " + listener + " )"));
        }
        if (this.observableDelegate == null) {
            return;
        }
        if (this.observableDelegate.removeGraphListener(listener)) {
            this.observableDelegate = null;
        }
    }

    public boolean equals(Object object) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.instanceString + ".equals( " + object + " )"));
        }
        boolean equals = super.equals(object);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("  " + this.instanceString + ".equals() returning " + equals));
        }
        return equals;
    }

    public int hashCode() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.instanceString + ".hashCode()"));
        }
        int hashCode = super.hashCode();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("  " + this.instanceString + ".hashCode() returning " + hashCode));
        }
        return hashCode;
    }

    public String toString() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.instanceString + ".toString()"));
        }
        String string = this.debugToString();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("  " + this.instanceString + ".toString() returning"));
        }
        return string;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class AdjacencyList {
        Object node;
        ArrayList edges;
        boolean isValid;

        AdjacencyList(Object node) {
            this.node = node;
            this.edges = new ArrayList(5);
            this.isValid = true;
        }

        Graph.Edge addTo(Object object, AdjacencyList headAdj, boolean isDirected) {
            Graph.Edge edge = DefaultGraph.this.createEdge(object, this.node, headAdj.node, isDirected);
            if (this.edges.contains(edge) || this != headAdj && headAdj.edges.contains(edge)) {
                return null;
            }
            DefaultGraph.this.edgeAdding(edge);
            this.edges.add(edge);
            DefaultGraph.this.alertEdgeAdded(this);
            if (this != headAdj) {
                headAdj.edges.add(edge);
                DefaultGraph.this.alertEdgeAdded(headAdj);
            }
            DefaultGraph.this.processEdgeAdded(edge);
            DefaultGraph.this.edgeAdded(edge);
            return edge;
        }

        boolean remove(Graph.Edge edge) {
            int index = this.edges.indexOf(edge);
            if (index == -1) {
                return false;
            }
            this.remove(index, (Graph.Edge)this.edges.get(index));
            return true;
        }

        void remove(int index, Graph.Edge edge) {
            DefaultGraph.this.edgeRemoving(edge);
            this.edges.remove(index);
            DefaultGraph.this.alertEdgeRemoved(this, index);
            AdjacencyList otherAdj = (AdjacencyList)DefaultGraph.this.nodeMap.get(edge.getOtherEndpoint(this.node));
            if (this != otherAdj) {
                int otherIndex = otherAdj.edges.indexOf(edge);
                otherAdj.edges.remove(otherIndex);
                DefaultGraph.this.alertEdgeRemoved(otherAdj, otherIndex);
            }
            DefaultGraph.this.processEdgeRemoved(edge);
            DefaultGraph.this.edgeRemoved(edge);
        }

        boolean contains(Graph.Edge edge) {
            return this.edges.contains(edge);
        }

        void clear() {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".AdjacencyList.clear() for node " + this.node));
            }
            CursorImpl cursor = new CursorImpl(null);
            while (cursor.hasNext()) {
                cursor.next();
                cursor.remove();
            }
            this.isValid = false;
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".AdjacencyList.clear() returning"));
            }
        }

        Graph.Edge get(CursorFilter filter) {
            int size = this.edges.size();
            if (filter == null) {
                return size > 0 ? (Graph.Edge)this.edges.get(0) : null;
            }
            if (filter == FALSE_CURSOR_FILTER) {
                return null;
            }
            for (int i = 0; i < size; ++i) {
                Graph.Edge edge = (Graph.Edge)this.edges.get(i);
                if (!filter.evaluate(this.node, edge)) continue;
                return edge;
            }
            return null;
        }

        int size() {
            return this.edges.size();
        }

        int degree() {
            int size = this.edges.size();
            int selfCount = 0;
            for (int i = 0; i < size; ++i) {
                Graph.Edge edge = (Graph.Edge)this.edges.get(i);
                if (!GraphUtils.equals(edge.getTail(), edge.getHead())) continue;
                ++selfCount;
            }
            return size + selfCount;
        }

        int degree(Predicate traverserPredicate) {
            int size = this.edges.size();
            int count = 0;
            OrderedPair pair = new OrderedPair(this.node, null);
            for (int i = 0; i < size; ++i) {
                pair.set(1, this.edges.get(i));
                if (!traverserPredicate.evaluate((Object)pair)) continue;
                ++count;
            }
            return count;
        }

        int degree(CursorFilter filter) {
            int size = this.edges.size();
            if (filter == null) {
                return size;
            }
            if (filter == FALSE_CURSOR_FILTER) {
                return 0;
            }
            int count = 0;
            for (int i = 0; i < size; ++i) {
                Graph.Edge edge = (Graph.Edge)this.edges.get(i);
                if (!filter.evaluate(this.node, edge)) continue;
                ++count;
            }
            return count;
        }

        int outDegree() {
            int size = this.edges.size();
            int count = 0;
            for (int i = 0; i < size; ++i) {
                Graph.Edge edge = (Graph.Edge)this.edges.get(i);
                if (!edge.isDirected() || !GraphUtils.equals(this.node, edge.getTail())) continue;
                ++count;
            }
            return count;
        }

        int inDegree() {
            int size = this.edges.size();
            int count = 0;
            for (int i = 0; i < size; ++i) {
                Graph.Edge edge = (Graph.Edge)this.edges.get(i);
                if (!edge.isDirected() || !GraphUtils.equals(this.node, edge.getHead())) continue;
                ++count;
            }
            return count;
        }

        Cursor cursor(CursorFilter filter) {
            return filter == FALSE_CURSOR_FILTER ? EMPTY_CURSOR : new CursorImpl(filter);
        }

        public String toString() {
            int size = this.edges.size();
            StringBuffer s = new StringBuffer();
            s.append("Adj( ");
            s.append(this.node);
            s.append(" ): [ ");
            for (int i = 0; i < size; ++i) {
                Graph.Edge edge = (Graph.Edge)this.edges.get(i);
                s.append("(");
                s.append(edge.getUserObject());
                s.append(") ");
                if (GraphUtils.equals(this.node, edge.getTail())) {
                    s.append(edge.isDirected() ? "-> (" : "-- (");
                    s.append(edge.getHead());
                    s.append(")");
                } else {
                    s.append(edge.isDirected() ? "<- (" : "-- (");
                    s.append(edge.getTail());
                    s.append(")");
                }
                if (i >= size - 1) continue;
                s.append(", ");
            }
            s.append(" ]");
            return s.toString();
        }

        private class CursorImpl
        implements Cursor {
            private CursorFilter filter;
            private int currentIndex;
            private int nextIndex;
            private Graph.Edge currentEdge;
            private Graph.Edge nextEdge;

            private CursorImpl(CursorFilter filter) {
                this.filter = filter;
                this.currentIndex = -1;
                this.nextIndex = -1;
                this.currentEdge = null;
                this.nextEdge = null;
                ((AdjacencyList)AdjacencyList.this).DefaultGraph.this.cursors.add(this);
            }

            public final boolean hasNext() {
                if (!AdjacencyList.this.isValid) {
                    return false;
                }
                if (this.nextIndex == this.currentIndex) {
                    int size = AdjacencyList.this.edges.size();
                    for (int i = this.nextIndex + 1; i < size; ++i) {
                        Graph.Edge edge = (Graph.Edge)AdjacencyList.this.edges.get(i);
                        if (this.filter != null && !this.filter.evaluate(AdjacencyList.this.node, edge)) continue;
                        this.nextIndex = i;
                        this.nextEdge = edge;
                        return true;
                    }
                    return false;
                }
                return this.nextIndex >= 0;
            }

            public final Object next() {
                if (!AdjacencyList.this.isValid) {
                    throw new ConcurrentModificationException();
                }
                if (!this.hasNext()) {
                    this.nextIndex = -2;
                    this.currentEdge = null;
                    throw new NoSuchElementException();
                }
                this.currentIndex = this.nextIndex;
                this.currentEdge = this.nextEdge;
                return this.currentEdge;
            }

            public final void remove() {
                if (!AdjacencyList.this.isValid) {
                    throw new ConcurrentModificationException();
                }
                if (this.currentEdge == null) {
                    throw new IllegalStateException();
                }
                AdjacencyList.this.remove(this.currentIndex, this.currentEdge);
            }

            public final AdjacencyList getAdjacencyList() {
                return AdjacencyList.this;
            }

            public final Graph.Edge getCurrentEdge() {
                if (!AdjacencyList.this.isValid) {
                    throw new ConcurrentModificationException();
                }
                if (this.currentEdge == null) {
                    throw new IllegalStateException();
                }
                return this.currentEdge;
            }

            public final Object getOtherNode() {
                if (!AdjacencyList.this.isValid) {
                    throw new ConcurrentModificationException();
                }
                if (this.currentEdge == null) {
                    throw new IllegalStateException();
                }
                return this.currentEdge.getOtherEndpoint(AdjacencyList.this.node);
            }

            public final void removeOtherNode() {
                DefaultGraph.this.removeNode(this.getOtherNode());
            }

            public final void edgeRemoved(int index) {
                if (index < this.currentIndex) {
                    --this.currentIndex;
                } else if (index == this.currentIndex) {
                    --this.currentIndex;
                    this.currentEdge = null;
                }
                if (index < this.nextIndex) {
                    --this.nextIndex;
                } else if (index == this.nextIndex) {
                    int size = AdjacencyList.this.edges.size();
                    for (int i = this.nextIndex; i < size; ++i) {
                        Graph.Edge edge = (Graph.Edge)AdjacencyList.this.edges.get(i);
                        if (this.filter != null && !this.filter.evaluate(AdjacencyList.this.node, edge)) continue;
                        this.nextIndex = i;
                        this.nextEdge = edge;
                        return;
                    }
                    this.nextIndex = this.currentIndex;
                }
            }
        }
    }

    private class PToQEdgeCollection
    extends FilteredEdgeCollection {
        private Predicate basePredicate;
        private Predicate nodePredicate;
        private CursorFilter qBaseFilter;
        private CursorFilter notQBaseFilter;

        private PToQEdgeCollection(Predicate edgePredicate, Predicate basePredicate, Predicate nodePredicate, CursorFilter qBaseFilter, CursorFilter notQBaseFilter) {
            super(edgePredicate);
            this.basePredicate = basePredicate;
            this.nodePredicate = nodePredicate;
            this.qBaseFilter = qBaseFilter;
            this.notQBaseFilter = notQBaseFilter;
        }

        CursorFilter getFilter(Object baseNode) {
            return this.basePredicate.evaluate(baseNode) ? (this.nodePredicate.evaluate(baseNode) ? this.qBaseFilter : this.notQBaseFilter) : null;
        }
    }

    private class PredToAnyEdgeCollection
    extends FilteredEdgeCollection {
        private Predicate basePredicate;
        private CursorFilter filter;

        private PredToAnyEdgeCollection(Predicate edgePredicate, Predicate basePredicate, CursorFilter filter) {
            super(edgePredicate);
            this.basePredicate = basePredicate;
            this.filter = filter;
        }

        CursorFilter getFilter(Object baseNode) {
            return this.basePredicate.evaluate(baseNode) ? this.filter : null;
        }
    }

    private class AnyToAnyEdgeCollection
    extends FilteredEdgeCollection {
        private CursorFilter filter;

        private AnyToAnyEdgeCollection(Predicate edgePredicate, CursorFilter filter) {
            super(edgePredicate);
            this.filter = filter;
        }

        CursorFilter getFilter(Object baseNode) {
            return this.filter;
        }
    }

    private class AllEdgesCollection
    extends FilteredEdgeCollection {
        private AllEdgesCollection() {
            super(null);
        }

        CursorFilter getFilter(Object baseNode) {
            return BASE_TAIL_CURSOR_FILTER;
        }

        Graph.Edge get() {
            Iterator i = DefaultGraph.this.nodeMap.values().iterator();
            while (i.hasNext()) {
                Graph.Edge edge = ((AdjacencyList)i.next()).get(null);
                if (edge == null) continue;
                return edge;
            }
            return null;
        }

        public int size() {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".edges().size()"));
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".edges().size() returning " + DefaultGraph.this.edgeSize));
            }
            return DefaultGraph.this.edgeSize;
        }

        public boolean isEmpty() {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".edges().isEmpty()"));
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".edges().isEmpty() returning " + (DefaultGraph.this.edgeSize == 0)));
            }
            return DefaultGraph.this.edgeSize == 0;
        }

        public boolean remove(Object object) {
            boolean modified;
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".edges().remove( " + object + " )"));
            }
            boolean bl = modified = object instanceof Graph.Edge && DefaultGraph.this.removeEdge((Graph.Edge)object);
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".edges().remove() returning " + modified));
            }
            return modified;
        }

        public boolean contains(Object object) {
            boolean contains;
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".edges().contains( " + object + " )"));
            }
            boolean bl = contains = object instanceof Graph.Edge && DefaultGraph.this.containsEdge((Graph.Edge)object);
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".edges().contains() returning " + contains));
            }
            return contains;
        }
    }

    private abstract class FilteredEdgeCollection
    extends EdgeCollection {
        private Predicate edgePredicate;

        private FilteredEdgeCollection(Predicate edgePredicate) {
            this.edgePredicate = edgePredicate;
        }

        abstract CursorFilter getFilter(Object var1);

        Graph.Edge get() {
            Iterator i = DefaultGraph.this.nodeMap.values().iterator();
            while (i.hasNext()) {
                Graph.Edge edge;
                AdjacencyList adj = (AdjacencyList)i.next();
                CursorFilter filter = this.getFilter(adj.node);
                if (filter == null || (edge = adj.get(filter)) == null) continue;
                return edge;
            }
            return null;
        }

        public int size() {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".edges().size()"));
            }
            int size = 0;
            Iterator i = DefaultGraph.this.nodeMap.values().iterator();
            while (i.hasNext()) {
                AdjacencyList adj = (AdjacencyList)i.next();
                CursorFilter filter = this.getFilter(adj.node);
                if (filter == null) continue;
                size += adj.degree(filter);
            }
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".edges().size() returning " + size));
            }
            return size;
        }

        public boolean isEmpty() {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".edges().isEmpty()"));
            }
            Iterator i = DefaultGraph.this.nodeMap.values().iterator();
            while (i.hasNext()) {
                AdjacencyList adj = (AdjacencyList)i.next();
                CursorFilter filter = this.getFilter(adj.node);
                if (filter == null || adj.degree(filter) <= 0) continue;
                if (DefaultGraph.this.logger.isDebugEnabled()) {
                    DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".edges().isEmpty() returning false"));
                }
                return false;
            }
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".edges().isEmpty() returning true"));
            }
            return true;
        }

        public boolean remove(Object object) {
            boolean modified;
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".edges().remove( " + object + " )"));
            }
            boolean bl = modified = object instanceof Graph.Edge && this.edgePredicate.evaluate(object) && DefaultGraph.this.removeEdge((Graph.Edge)object);
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".edges().remove() returning " + modified));
            }
            return modified;
        }

        public boolean contains(Object object) {
            boolean contains;
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".edges().contains( " + object + " )"));
            }
            boolean bl = contains = object instanceof Graph.Edge && this.edgePredicate.evaluate(object) && DefaultGraph.this.containsEdge((Graph.Edge)object);
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".edges().contains() returning " + contains));
            }
            return contains;
        }

        public Iterator iterator() {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".edges().iterator()"));
            }
            EdgeIterator i = new EdgeIterator();
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".edges().iterator() returning"));
            }
            return i;
        }

        public boolean containsAll(Collection c) {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".edges().containsAll( " + c + " )"));
            }
            boolean containsAll = super.containsAll(c);
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".edges().containsAll() returning " + containsAll));
            }
            return containsAll;
        }

        public boolean removeAll(Collection c) {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".edges().removeAll( " + c + " )"));
            }
            boolean modified = super.removeAll(c);
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".edges().removeAll() returning " + modified));
            }
            return modified;
        }

        public boolean retainAll(Collection c) {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".edges().retainAll( " + c + " )"));
            }
            boolean modified = super.retainAll(c);
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".edges().retainAll() returning " + modified));
            }
            return modified;
        }

        public void clear() {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".edges().clear()"));
            }
            super.clear();
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".edges().clear() returning"));
            }
        }

        public Object[] toArray() {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".edges().toArray()"));
            }
            Object[] array = super.toArray();
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".edges().toArray() returning " + array));
            }
            return array;
        }

        public Object[] toArray(Object[] a) {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".edges().toArray( " + a + " )"));
            }
            Object[] array = super.toArray(a);
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".edges().toArray() returning " + array));
            }
            return array;
        }

        public String toString() {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".edges().toString()"));
            }
            String string = super.toString();
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".edges().toString() returning"));
            }
            return string;
        }

        private class EdgeIterator
        implements Iterator {
            private Iterator adjIter;
            private Cursor cursor;
            private Object current;
            private Object next;

            private EdgeIterator() {
                this.adjIter = ((FilteredEdgeCollection)FilteredEdgeCollection.this).DefaultGraph.this.nodeMap.values().iterator();
                this.cursor = EMPTY_CURSOR;
                this.current = null;
                this.next = null;
            }

            protected void advance() {
                while (!this.cursor.hasNext() && this.adjIter.hasNext()) {
                    AdjacencyList adj = (AdjacencyList)this.adjIter.next();
                    CursorFilter filter = FilteredEdgeCollection.this.getFilter(adj.node);
                    if (filter == null) continue;
                    this.cursor = adj.cursor(filter);
                }
            }

            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                this.advance();
                if (!this.cursor.hasNext()) {
                    return false;
                }
                this.next = this.cursor.next();
                return true;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.current = this.next;
                this.next = null;
                return this.current;
            }

            public void remove() {
                if (this.current == null) {
                    throw new IllegalStateException();
                }
                if (((FilteredEdgeCollection)FilteredEdgeCollection.this).DefaultGraph.this.logger.isDebugEnabled()) {
                    ((FilteredEdgeCollection)FilteredEdgeCollection.this).DefaultGraph.this.logger.debug((Object)(((FilteredEdgeCollection)FilteredEdgeCollection.this).DefaultGraph.this.instanceString + ".edges().iterator().remove() upon edge " + this.current));
                }
                DefaultGraph.this.removeEdge((Graph.Edge)this.current);
                this.current = null;
                if (((FilteredEdgeCollection)FilteredEdgeCollection.this).DefaultGraph.this.logger.isDebugEnabled()) {
                    ((FilteredEdgeCollection)FilteredEdgeCollection.this).DefaultGraph.this.logger.debug((Object)(((FilteredEdgeCollection)FilteredEdgeCollection.this).DefaultGraph.this.instanceString + ".edges().iterator().remove() returning"));
                }
            }
        }
    }

    private class IncEdgeCollection
    extends EdgeCollection {
        private AdjacencyList adj;
        private CursorFilter filter;

        private IncEdgeCollection(AdjacencyList adj, CursorFilter filter) {
            this.adj = adj;
            this.filter = filter;
        }

        Graph.Edge get() {
            return this.adj.get(this.filter);
        }

        public int size() {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".incidentEdges().size()"));
            }
            int size = this.adj.degree(this.filter);
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".incidentEdges().size() returning " + size));
            }
            return size;
        }

        public boolean isEmpty() {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".incidentEdges().isEmpty()"));
            }
            boolean isEmpty = super.isEmpty();
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".incidentEdges().isEmpty() returning " + isEmpty));
            }
            return isEmpty;
        }

        public boolean remove(Object object) {
            boolean modified;
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".incidentEdges().remove( " + object + " )"));
            }
            if (!(object instanceof Graph.Edge)) {
                if (DefaultGraph.this.logger.isDebugEnabled()) {
                    DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".incidentEdges().remove() returning false"));
                }
                return false;
            }
            Graph.Edge edge = (Graph.Edge)object;
            boolean bl = modified = this.filter.evaluate(this.adj.node, edge) && this.adj.remove(edge);
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".incidentEdges().remove() returning " + modified));
            }
            return modified;
        }

        public boolean contains(Object object) {
            boolean contains;
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".incidentEdges().contains( " + object + " )"));
            }
            if (!(object instanceof Graph.Edge)) {
                if (DefaultGraph.this.logger.isDebugEnabled()) {
                    DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".incidentEdges().contains() returning false"));
                }
                return false;
            }
            Graph.Edge edge = (Graph.Edge)object;
            boolean bl = contains = this.filter.evaluate(this.adj.node, edge) && this.adj.contains(edge);
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".incidentEdges().contains() returning " + contains));
            }
            return contains;
        }

        public Iterator iterator() {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".incidentEdges().iterator()"));
            }
            CursorEdgeIteratorAdapter i = new CursorEdgeIteratorAdapter(this.adj.cursor(this.filter));
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".incidentEdges().iterator() returning"));
            }
            return i;
        }

        public boolean containsAll(Collection c) {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".incidentEdges().containsAll( " + c + " )"));
            }
            boolean containsAll = super.containsAll(c);
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".incidentEdges().containsAll() returning " + containsAll));
            }
            return containsAll;
        }

        public boolean removeAll(Collection c) {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".incidentEdges().removeAll( " + c + " )"));
            }
            boolean modified = super.removeAll(c);
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".incidentEdges().removeAll() returning " + modified));
            }
            return modified;
        }

        public boolean retainAll(Collection c) {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".incidentEdges().retainAll( " + c + " )"));
            }
            boolean modified = super.retainAll(c);
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".incidentEdges().retainAll() returning " + modified));
            }
            return modified;
        }

        public void clear() {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".incidentEdges().clear()"));
            }
            Cursor i = this.adj.cursor(this.filter);
            while (i.hasNext()) {
                i.next();
                i.remove();
            }
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".incidentEdges().clear() returning"));
            }
        }

        public Object[] toArray() {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".incidentEdges().toArray()"));
            }
            Object[] array = super.toArray();
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".incidentEdges().toArray() returning " + array));
            }
            return array;
        }

        public Object[] toArray(Object[] a) {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".incidentEdges().toArray( " + a + " )"));
            }
            Object[] array = super.toArray(a);
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".incidentEdges().toArray() returning " + array));
            }
            return array;
        }

        public String toString() {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".incidentEdges().toString()"));
            }
            String string = super.toString();
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".incidentEdges().toString() returning " + string));
            }
            return string;
        }
    }

    private abstract class EdgeCollection
    extends AbstractCollection {
        private EdgeCollection() {
        }

        abstract Graph.Edge get();

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }
    }

    private class AdjNodeCollection
    extends AbstractCollection {
        private AdjacencyList adj;
        private CursorFilter filter;

        private AdjNodeCollection(AdjacencyList adj, CursorFilter filter) {
            this.adj = adj;
            this.filter = filter;
        }

        public int size() {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".adjacentNodes().size()"));
            }
            int size = this.adj.degree(this.filter);
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".adjacentNodes().size() returning " + size));
            }
            return size;
        }

        public boolean isEmpty() {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".adjacentNodes().isEmpty()"));
            }
            boolean isEmpty = super.isEmpty();
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".adjacentNodes().isEmpty() returning " + isEmpty));
            }
            return isEmpty;
        }

        public boolean remove(Object object) {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".adjacentNodes().remove( " + object + " )"));
            }
            if (DefaultGraph.this.nodeMap.get(object) == null) {
                if (DefaultGraph.this.logger.isDebugEnabled()) {
                    DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".adjacentNodes().remove() returning false"));
                }
                return false;
            }
            Cursor cursor = this.adj.cursor(this.filter);
            while (cursor.hasNext()) {
                cursor.next();
                if (!GraphUtils.equals(object, cursor.getOtherNode())) continue;
                cursor.remove();
                if (DefaultGraph.this.logger.isDebugEnabled()) {
                    DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".adjacentNodes().remove() returning true"));
                }
                return true;
            }
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".adjacentNodes().remove() returning false"));
            }
            return false;
        }

        public boolean contains(Object object) {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".adjacentNodes().contains( " + object + " )"));
            }
            if (DefaultGraph.this.nodeMap.get(object) == null) {
                if (DefaultGraph.this.logger.isDebugEnabled()) {
                    DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".adjacentNodes().contains() returning false"));
                }
                return false;
            }
            Cursor cursor = this.adj.cursor(this.filter);
            while (cursor.hasNext()) {
                cursor.next();
                if (!GraphUtils.equals(object, cursor.getOtherNode())) continue;
                if (DefaultGraph.this.logger.isDebugEnabled()) {
                    DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".adjacentNodes().contains() returning true"));
                }
                return true;
            }
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".adjacentNodes().contains() returning false"));
            }
            return false;
        }

        public Iterator iterator() {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".adjacentNodes().iterator()"));
            }
            CursorNodeIteratorAdapter i = new CursorNodeIteratorAdapter(this.adj.cursor(this.filter));
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".adjacentNodes().iterator() returning"));
            }
            return i;
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(Collection c) {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".adjacentNodes().containsAll( " + c + " )"));
            }
            boolean containsAll = super.containsAll(c);
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".adjacentNodes().containsAll() returning " + containsAll));
            }
            return containsAll;
        }

        public boolean removeAll(Collection c) {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".adjacentNodes().removeAll( " + c + " )"));
            }
            boolean modified = super.removeAll(c);
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".adjacentNodes().removeAll() returning " + modified));
            }
            return modified;
        }

        public boolean retainAll(Collection c) {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".adjacentNodes().retainAll( " + c + " )"));
            }
            boolean modified = super.retainAll(c);
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".adjacentNodes().retainAll() returning " + modified));
            }
            return modified;
        }

        public void clear() {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".adjacentNodes().clear()"));
            }
            Cursor i = this.adj.cursor(this.filter);
            while (i.hasNext()) {
                i.next();
                i.remove();
            }
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".adjacentNodes().clear() returning"));
            }
        }

        public Object[] toArray() {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".adjacentNodes().toArray()"));
            }
            Object[] array = super.toArray();
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".adjacentNodes().toArray() returning " + array));
            }
            return array;
        }

        public Object[] toArray(Object[] a) {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".adjacentNodes().toArray( " + a + " )"));
            }
            Object[] array = super.toArray(a);
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".adjacentNodes().toArray() returning " + array));
            }
            return array;
        }

        public String toString() {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".adjacentNodes().toString()"));
            }
            String string = super.toString();
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".adjacentNodes().toString() returning " + string));
            }
            return string;
        }
    }

    private class AllNodesCollection
    implements Collection {
        private AllNodesCollection() {
        }

        public int size() {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".nodes().size()"));
            }
            int size = DefaultGraph.this.nodeMap.size();
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".nodes().size() returning " + size));
            }
            return size;
        }

        public boolean isEmpty() {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".nodes().isEmpty()"));
            }
            boolean isEmpty = DefaultGraph.this.nodeMap.isEmpty();
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".nodes().isEmpty() returning " + isEmpty));
            }
            return isEmpty;
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object object) {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".nodes().remove( " + object + " )"));
            }
            boolean modified = DefaultGraph.this.removeNode(object);
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".nodes().remove() returning " + modified));
            }
            return modified;
        }

        public boolean contains(Object object) {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".nodes().contains( " + object + " )"));
            }
            boolean contains = DefaultGraph.this.containsNode(object);
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".nodes().contains() returning " + contains));
            }
            return contains;
        }

        public Iterator iterator() {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".nodes().iterator()"));
            }
            NodeIterator i = new NodeIterator();
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".nodes().iterator() returning"));
            }
            return i;
        }

        public boolean containsAll(Collection c) {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".nodes().containsAll( " + c + " )"));
            }
            boolean containsAll = DefaultGraph.this.nodeMap.keySet().containsAll(c);
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".nodes().containsAll() returning " + containsAll));
            }
            return containsAll;
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".nodes().removeAll( " + c + " )"));
            }
            boolean modified = false;
            Iterator i = c.iterator();
            while (i.hasNext()) {
                modified |= DefaultGraph.this.removeNode(i.next());
            }
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".nodes().removeAll() returning " + modified));
            }
            return modified;
        }

        public boolean retainAll(Collection c) {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".nodes().retainAll( " + c + " )"));
            }
            boolean modified = false;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                if (c.contains(i.next())) continue;
                i.remove();
                modified = true;
            }
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".nodes().retainAll() returning " + modified));
            }
            return modified;
        }

        public void clear() {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".nodes().clear()"));
            }
            Iterator i = this.iterator();
            while (i.hasNext()) {
                i.next();
                i.remove();
            }
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".nodes().clear() returning"));
            }
        }

        public Object[] toArray() {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".nodes().toArray()"));
            }
            Object[] array = DefaultGraph.this.nodeMap.keySet().toArray();
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".nodes().toArray() returning " + array));
            }
            return array;
        }

        public Object[] toArray(Object[] a) {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".nodes().toArray( " + a + " )"));
            }
            Object[] array = DefaultGraph.this.nodeMap.keySet().toArray(a);
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".nodes().toArray() returning " + array));
            }
            return array;
        }

        public String toString() {
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)(DefaultGraph.this.instanceString + ".nodes().toString()"));
            }
            String string = DefaultGraph.this.nodeMap.keySet().toString();
            if (DefaultGraph.this.logger.isDebugEnabled()) {
                DefaultGraph.this.logger.debug((Object)("  " + DefaultGraph.this.instanceString + ".nodes().toString() returning"));
            }
            return string;
        }

        private class NodeIterator
        implements Iterator {
            private Iterator adjIter;
            private AdjacencyList adj;
            private boolean isCurrentValid;

            private NodeIterator() {
                this.adjIter = ((AllNodesCollection)AllNodesCollection.this).DefaultGraph.this.nodeMap.values().iterator();
                this.isCurrentValid = false;
            }

            public boolean hasNext() {
                return this.adjIter.hasNext();
            }

            public Object next() {
                this.adj = (AdjacencyList)this.adjIter.next();
                this.isCurrentValid = true;
                return this.adj.node;
            }

            public void remove() {
                if (!this.isCurrentValid) {
                    throw new IllegalStateException();
                }
                if (((AllNodesCollection)AllNodesCollection.this).DefaultGraph.this.logger.isDebugEnabled()) {
                    ((AllNodesCollection)AllNodesCollection.this).DefaultGraph.this.logger.debug((Object)(((AllNodesCollection)AllNodesCollection.this).DefaultGraph.this.instanceString + ".nodes().iterator().remove() upon node " + this.adj.node));
                }
                DefaultGraph.this.nodeRemoving(this.adj.node);
                this.adj.clear();
                this.adjIter.remove();
                DefaultGraph.this.processNodeRemoved(this.adj.node);
                DefaultGraph.this.nodeRemoved(this.adj.node);
                this.isCurrentValid = false;
                if (((AllNodesCollection)AllNodesCollection.this).DefaultGraph.this.logger.isDebugEnabled()) {
                    ((AllNodesCollection)AllNodesCollection.this).DefaultGraph.this.logger.debug((Object)("  " + ((AllNodesCollection)AllNodesCollection.this).DefaultGraph.this.instanceString + ".nodes().iterator().remove() returning"));
                }
            }
        }
    }

    private static class CursorTraverserAdapter
    implements Traverser {
        private Cursor cursor;

        private CursorTraverserAdapter(Cursor cursor) {
            this.cursor = cursor;
        }

        public boolean hasNext() {
            return this.cursor.hasNext();
        }

        public Object next() {
            this.cursor.next();
            return this.cursor.getOtherNode();
        }

        public void remove() {
            this.cursor.removeOtherNode();
        }

        public Graph.Edge getEdge() {
            return this.cursor.getCurrentEdge();
        }

        public void removeEdge() {
            this.cursor.remove();
        }
    }

    private static class CursorEdgeIteratorAdapter
    implements Iterator {
        private Cursor cursor;

        private CursorEdgeIteratorAdapter(Cursor cursor) {
            this.cursor = cursor;
        }

        public boolean hasNext() {
            return this.cursor.hasNext();
        }

        public Object next() {
            return this.cursor.next();
        }

        public void remove() {
            this.cursor.remove();
        }
    }

    private static class CursorNodeIteratorAdapter
    implements Iterator {
        private Cursor cursor;

        private CursorNodeIteratorAdapter(Cursor cursor) {
            this.cursor = cursor;
        }

        public boolean hasNext() {
            return this.cursor.hasNext();
        }

        public Object next() {
            this.cursor.next();
            return this.cursor.getOtherNode();
        }

        public void remove() {
            this.cursor.remove();
        }
    }

    private static class PQToQCursorFilter
    extends ToAnyCursorFilter {
        private Predicate basePredicate;
        private Predicate nodePredicate;

        private PQToQCursorFilter(int directionFlags, Predicate basePredicate, Predicate nodePredicate, Predicate userPredicate) {
            super(directionFlags, userPredicate);
            this.basePredicate = basePredicate;
            this.nodePredicate = nodePredicate;
        }

        protected boolean subTest(Object baseNode, Graph.Edge edge) {
            Object tail = edge.getTail();
            return GraphUtils.equals(baseNode, tail) || !this.basePredicate.evaluate(tail);
        }

        public boolean evaluate(Object baseNode, Graph.Edge edge) {
            return super.evaluate(baseNode, edge) && this.nodePredicate.evaluate(edge.getOtherEndpoint(baseNode));
        }
    }

    private static class PredToAnyCursorFilter
    extends ToAnyCursorFilter {
        private Predicate basePredicate;

        private PredToAnyCursorFilter(int directionFlags, Predicate basePredicate, Predicate userPredicate) {
            super(directionFlags, userPredicate);
            this.basePredicate = basePredicate;
        }

        protected boolean subTest(Object baseNode, Graph.Edge edge) {
            Object tail = edge.getTail();
            return GraphUtils.equals(baseNode, tail) || !this.basePredicate.evaluate(tail);
        }
    }

    private static class AnyToAnyCursorFilter
    extends ToAnyCursorFilter {
        private AnyToAnyCursorFilter(int directionFlags, Predicate userPredicate) {
            super(directionFlags, userPredicate);
        }

        protected boolean subTest(Object baseNode, Graph.Edge edge) {
            return GraphUtils.equals(baseNode, edge.getTail());
        }
    }

    private static class ToEqualsCursorFilter
    extends ToAnyCursorFilter {
        private Object testNode;

        private ToEqualsCursorFilter(int directionFlags, Object testNode, Predicate userPredicate) {
            super(directionFlags, userPredicate);
            this.testNode = testNode;
        }

        public boolean evaluate(Object baseNode, Graph.Edge edge) {
            return super.evaluate(baseNode, edge) && GraphUtils.equals(this.testNode, edge.getOtherEndpoint(baseNode));
        }
    }

    private static class ToPredCursorFilter
    extends ToAnyCursorFilter {
        private Predicate nodePredicate;

        private ToPredCursorFilter(int directionFlags, Predicate nodePredicate, Predicate userPredicate) {
            super(directionFlags, userPredicate);
            this.nodePredicate = nodePredicate;
        }

        public boolean evaluate(Object baseNode, Graph.Edge edge) {
            return super.evaluate(baseNode, edge) && this.nodePredicate.evaluate(edge.getOtherEndpoint(baseNode));
        }
    }

    private static class ToAnyCursorFilter
    implements CursorFilter {
        private int directionFlags;
        private Predicate userPredicate;

        private ToAnyCursorFilter(int directionFlags, Predicate userPredicate) {
            this.directionFlags = directionFlags;
            this.userPredicate = userPredicate;
        }

        protected boolean subTest(Object baseNode, Graph.Edge edge) {
            return true;
        }

        public boolean evaluate(Object baseNode, Graph.Edge edge) {
            if (edge.isDirected()) {
                if ((this.directionFlags & 6) == 6) {
                    return this.subTest(baseNode, edge) && this.userPredicate.evaluate(edge.getUserObject());
                }
                return ((this.directionFlags & 2) != 0 && GraphUtils.equals(baseNode, edge.getTail()) || (this.directionFlags & 4) != 0 && GraphUtils.equals(baseNode, edge.getHead())) && this.userPredicate.evaluate(edge.getUserObject());
            }
            return (this.directionFlags & 1) != 0 && this.subTest(baseNode, edge) && this.userPredicate.evaluate(edge.getUserObject());
        }
    }

    private static class GeneralTraverserCursorFilter
    implements CursorFilter {
        private Predicate traverserPredicate;
        private OrderedPair pair;

        private GeneralTraverserCursorFilter(Predicate traverserPredicate) {
            this.traverserPredicate = traverserPredicate;
            this.pair = new OrderedPair(null, null);
        }

        public boolean evaluate(Object baseNode, Graph.Edge edge) {
            this.pair.set(0, baseNode);
            this.pair.set(1, edge);
            return this.traverserPredicate.evaluate((Object)this.pair);
        }
    }

    private static class BTailCursorFilter
    implements CursorFilter {
        private Predicate edgePredicate;

        private BTailCursorFilter(Predicate edgePredicate) {
            this.edgePredicate = edgePredicate;
        }

        public boolean evaluate(Object baseNode, Graph.Edge edge) {
            return GraphUtils.equals(baseNode, edge.getTail()) && this.edgePredicate.evaluate((Object)edge);
        }
    }

    private static class EqualsCursorFilter
    implements CursorFilter {
        private Graph.Edge testEdge;

        private EqualsCursorFilter(Graph.Edge edge) {
            this.testEdge = edge;
        }

        public boolean evaluate(Object baseNode, Graph.Edge edge) {
            return ((Object)this.testEdge).equals(edge);
        }
    }

    private static interface CursorFilter {
        public boolean evaluate(Object var1, Graph.Edge var2);
    }

    private static interface Cursor
    extends Iterator {
        public AdjacencyList getAdjacencyList();

        public Graph.Edge getCurrentEdge();

        public Object getOtherNode();

        public void removeOtherNode();

        public void edgeRemoved(int var1);
    }
}

