/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.plexus;

import com.phoenixst.plexus.DefaultOrientedForestView;
import com.phoenixst.plexus.Graph;
import com.phoenixst.plexus.GraphUtils;
import com.phoenixst.plexus.NoSuchNodeException;
import com.phoenixst.plexus.RootedTreeView;
import java.util.ArrayList;
import org.apache.commons.collections.Predicate;

public class DefaultRootedTreeView
extends DefaultOrientedForestView
implements RootedTreeView {
    private static final long serialVersionUID = 1L;
    protected Object root;

    public DefaultRootedTreeView(Graph graph, Predicate parentPredicate, Predicate childPredicate) {
        super(graph, parentPredicate, childPredicate);
        this.root = null;
    }

    public DefaultRootedTreeView(Graph graph, Object root, Predicate parentPredicate, Predicate childPredicate) {
        super(graph, parentPredicate, childPredicate);
        this.setRoot(root);
    }

    public boolean isTreeNode(Object node) {
        Graph.Edge edge = this.getParentEdge(node);
        while (edge != null) {
            node = edge.getOtherEndpoint(node);
            edge = this.getParentEdge(node);
        }
        return GraphUtils.equals(this.root, node);
    }

    public Object getRoot() {
        return this.root;
    }

    public void setRoot(Object root) {
        if (!this.graph.containsNode(root)) {
            throw new NoSuchNodeException("Node is not in the graph: " + root);
        }
        this.root = root;
    }

    public Object getRoot(Object node) {
        if (!this.isTreeNode(node)) {
            throw new NoSuchNodeException("Node is not in this tree: " + node);
        }
        return this.root;
    }

    public Object getLeastCommonAncestor(Object aNode, Object bNode) {
        ArrayList<Object> aList = new ArrayList<Object>();
        aList.add(aNode);
        Graph.Edge edge = this.getParentEdge(aNode);
        while (edge != null) {
            aNode = edge.getOtherEndpoint(aNode);
            aList.add(aNode);
            edge = this.getParentEdge(aNode);
        }
        if (!GraphUtils.equals(this.root, aNode)) {
            throw new NoSuchNodeException("Node is not in this tree: " + aNode);
        }
        aList.add(null);
        ArrayList<Object> bList = new ArrayList<Object>();
        bList.add(bNode);
        edge = this.getParentEdge(bNode);
        while (edge != null) {
            bNode = edge.getOtherEndpoint(bNode);
            bList.add(bNode);
            edge = this.getParentEdge(bNode);
        }
        if (!GraphUtils.equals(this.root, bNode)) {
            throw new NoSuchNodeException("Node is not in this tree: " + bNode);
        }
        bList.add(null);
        int aIndex = aList.size() - 1;
        int bIndex = bList.size() - 1;
        while (--aIndex >= 0 && --bIndex >= 0) {
            if (GraphUtils.equals(aList.get(aIndex), bList.get(bIndex))) continue;
            return aList.get(aIndex + 1);
        }
        return aIndex < 0 ? aList.get(0) : bList.get(0);
    }

    public int getDepth(Object node) {
        int depth = 0;
        Graph.Edge edge = this.getParentEdge(node);
        while (edge != null) {
            node = edge.getOtherEndpoint(node);
            edge = this.getParentEdge(node);
            ++depth;
        }
        if (!GraphUtils.equals(this.root, node)) {
            throw new NoSuchNodeException("Node is not in this tree: " + node);
        }
        return depth;
    }
}

