/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.plexus;

import com.phoenixst.collections.SimpleStack;
import com.phoenixst.plexus.Graph;
import com.phoenixst.plexus.NoSuchNodeException;
import com.phoenixst.plexus.OrientedForestView;
import com.phoenixst.plexus.PruningTraverser;
import com.phoenixst.plexus.Traverser;
import com.phoenixst.plexus.util.ChildTraverserFactory;
import com.phoenixst.plexus.util.DefaultTraverserFactory;
import com.phoenixst.plexus.util.SingletonTraverser;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.log4j.Logger;

public class DepthFirstTraverser
implements PruningTraverser {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$com$phoenixst$plexus$DepthFirstTraverser == null ? (class$com$phoenixst$plexus$DepthFirstTraverser = DepthFirstTraverser.class$("com.phoenixst.plexus.DepthFirstTraverser")) : class$com$phoenixst$plexus$DepthFirstTraverser));
    private Transformer traverserFactory;
    private Traverser current;
    private SimpleStack nodeStack;
    private SimpleStack traverserStack;
    private boolean isDescending;
    static /* synthetic */ Class class$com$phoenixst$plexus$DepthFirstTraverser;

    public DepthFirstTraverser(Object startNode, Graph graph, Predicate traverserPredicate) {
        this(startNode, graph, new DefaultTraverserFactory(graph, traverserPredicate));
    }

    public DepthFirstTraverser(Object startNode, OrientedForestView forestView) {
        this(startNode, forestView.getGraph(), new ChildTraverserFactory(forestView));
    }

    public DepthFirstTraverser(Object startNode, Transformer traverserFactory) {
        this(startNode, null, traverserFactory);
    }

    private DepthFirstTraverser(Object startNode, Graph graph, Transformer traverserFactory) {
        this.traverserFactory = traverserFactory;
        if (traverserFactory == null) {
            throw new NullPointerException("Traverser Factory is null.");
        }
        if (graph == null) {
            traverserFactory.transform(startNode);
        } else if (!graph.containsNode(startNode)) {
            throw new NoSuchNodeException("Graph does not contain start node: " + startNode);
        }
        this.current = null;
        this.nodeStack = new SimpleStack();
        this.traverserStack = new SimpleStack();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Constructor: Pushing trivial Traverser to " + startNode + " onto Traverser stack."));
        }
        this.traverserStack.push(new SingletonTraverser(graph, startNode, null));
        this.isDescending = true;
    }

    public boolean hasNext() {
        LOGGER.debug((Object)"hasNext(): Calling isEmpty() on node stack OR hasNext() on top Traverser.");
        return !this.nodeStack.isEmpty() || ((Traverser)this.traverserStack.peek()).hasNext();
    }

    public Object next() {
        Object node;
        LOGGER.debug((Object)"next():");
        Traverser top = (Traverser)this.traverserStack.peek();
        LOGGER.debug((Object)"  Calling hasNext() on top Traverser.");
        this.isDescending = top.hasNext();
        if (this.isDescending) {
            LOGGER.debug((Object)"  Descending, setting current Traverser to top of stack");
            this.current = top;
            node = top.next();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("  Creating new Traverser for " + node + "."));
                LOGGER.debug((Object)"  Pushing node and its Traverser, return node.");
            }
            this.nodeStack.push(node);
            this.traverserStack.push(this.traverserFactory.transform(node));
        } else {
            LOGGER.debug((Object)"  Ascending.");
            if (this.nodeStack.isEmpty()) {
                throw new NoSuchElementException();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"  Popping node and Traverser.");
                LOGGER.debug((Object)"  Setting current Traverser to top of stack.");
                LOGGER.debug((Object)"  Return node.");
            }
            this.traverserStack.pop();
            this.current = (Traverser)this.traverserStack.peek();
            node = this.nodeStack.pop();
        }
        return node;
    }

    public void remove() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        LOGGER.debug((Object)"remove(): Calling remove() on current Traverser, setting current to null.");
        this.current.remove();
        this.current = null;
        if (this.isDescending) {
            LOGGER.debug((Object)"  Popping node and Traverser.");
            this.traverserStack.pop();
            this.nodeStack.pop();
        }
    }

    public Graph.Edge getEdge() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        LOGGER.debug((Object)"getEdge(): Calling getEdge() on current Traverser.");
        return this.current.getEdge();
    }

    public void removeEdge() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        LOGGER.debug((Object)"removeEdge(): Calling removeEdge() on current Traverser, setting current to null.");
        this.current.removeEdge();
        this.current = null;
        if (this.isDescending) {
            LOGGER.debug((Object)"  Popping node and Traverser.");
            this.traverserStack.pop();
            this.nodeStack.pop();
        }
    }

    public void prune() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        LOGGER.debug((Object)"prune(): Setting current to null.");
        this.current = null;
        if (this.isDescending) {
            LOGGER.debug((Object)"  Popping node and Traverser.");
            this.traverserStack.pop();
            this.nodeStack.pop();
        }
    }

    public boolean isDescending() {
        return this.isDescending;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

