/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.plexus;

import com.phoenixst.collections.AndPredicate;
import com.phoenixst.collections.FalsePredicate;
import com.phoenixst.collections.TruePredicate;
import com.phoenixst.plexus.AbstractGraph;
import com.phoenixst.plexus.Graph;
import com.phoenixst.plexus.GraphEvent;
import com.phoenixst.plexus.GraphListener;
import com.phoenixst.plexus.NoSuchNodeException;
import com.phoenixst.plexus.ObservableGraph;
import com.phoenixst.plexus.Traverser;
import com.phoenixst.plexus.util.ObservableGraphDelegate;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.Predicate;
import org.apache.log4j.Logger;

public class FilteredGraph
extends AbstractGraph
implements ObservableGraph,
Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger LOGGER = Logger.getLogger((Class)(class$com$phoenixst$plexus$FilteredGraph == null ? (class$com$phoenixst$plexus$FilteredGraph = FilteredGraph.class$("com.phoenixst.plexus.FilteredGraph")) : class$com$phoenixst$plexus$FilteredGraph));
    private Graph graph;
    Predicate nodePredicate;
    Predicate edgePredicate;
    private transient Predicate graphTraverserPredicate;
    private transient Collection nodeCollection;
    private transient Collection edgeCollection;
    transient ObservableGraphDelegate observableDelegate;
    private transient GraphListener graphListener;
    static /* synthetic */ Class class$com$phoenixst$plexus$FilteredGraph;

    public FilteredGraph(Graph graph, Predicate nodePredicate, Predicate edgePredicate) {
        this.graph = graph;
        this.nodePredicate = nodePredicate;
        this.edgePredicate = edgePredicate;
        if (graph == null) {
            throw new NullPointerException("Graph is null.");
        }
        if (nodePredicate == null) {
            this.nodePredicate = TruePredicate.INSTANCE;
        }
        if (edgePredicate == null) {
            this.edgePredicate = TruePredicate.INSTANCE;
        }
        this.init();
    }

    private void init() {
        Predicate edgeFilter = null;
        edgeFilter = this.nodePredicate == TruePredicate.INSTANCE ? this.edgePredicate : (this.nodePredicate == FalsePredicate.INSTANCE ? FalsePredicate.INSTANCE : (this.edgePredicate == TruePredicate.INSTANCE ? new EdgeEndpointPredicate(this.nodePredicate) : (this.edgePredicate == FalsePredicate.INSTANCE ? FalsePredicate.INSTANCE : new AndPredicate(new EdgeEndpointPredicate(this.nodePredicate), this.edgePredicate))));
        this.graphTraverserPredicate = edgeFilter == TruePredicate.INSTANCE ? TruePredicate.INSTANCE : (edgeFilter == FalsePredicate.INSTANCE ? FalsePredicate.INSTANCE : new EdgeTraverserPredicateAdapter(edgeFilter));
        this.nodeCollection = this.graph.nodes(this.nodePredicate);
        this.edgeCollection = this.graph.edges(edgeFilter);
    }

    private void checkNodePresent(Object node) {
        if (!this.nodePredicate.evaluate(node)) {
            throw new NoSuchNodeException("Node is not in this graph: " + node);
        }
    }

    protected Collection nodes() {
        return this.nodeCollection;
    }

    protected Collection edges() {
        return this.edgeCollection;
    }

    protected Traverser traverser(Object node) {
        this.checkNodePresent(node);
        return this.graph.traverser(node, this.graphTraverserPredicate);
    }

    public boolean addNode(Object node) {
        if (!this.nodePredicate.evaluate(node)) {
            throw new IllegalArgumentException("Node is not allowed in this graph: " + node);
        }
        return this.graph.addNode(node);
    }

    public boolean removeNode(Object node) {
        return this.nodeCollection.remove(node);
    }

    public boolean containsNode(Object node) {
        return this.nodeCollection.contains(node);
    }

    public Graph.Edge addEdge(Object object, Object tail, Object head, boolean isDirected) {
        this.checkNodePresent(tail);
        this.checkNodePresent(head);
        Graph.Edge edge = this.graph.addEdge(object, tail, head, isDirected);
        if (edge == null) {
            return null;
        }
        if (!this.edgePredicate.evaluate((Object)edge)) {
            this.graph.removeEdge(edge);
            return null;
        }
        return edge;
    }

    public boolean removeEdge(Graph.Edge edge) {
        return this.edgeCollection.remove(edge);
    }

    public boolean containsEdge(Graph.Edge edge) {
        return this.edgeCollection.contains(edge);
    }

    public void addGraphListener(GraphListener listener) {
        if (!(this.graph instanceof ObservableGraph)) {
            throw new UnsupportedOperationException("Wrapped graph is not observable.");
        }
        if (this.observableDelegate == null) {
            this.observableDelegate = new ObservableGraphDelegate(this, LOGGER);
            this.graphListener = new GraphListenerImpl();
            ((ObservableGraph)this.graph).addGraphListener(this.graphListener);
        }
        this.observableDelegate.addGraphListener(listener);
    }

    public void removeGraphListener(GraphListener listener) {
        if (!(this.graph instanceof ObservableGraph)) {
            throw new UnsupportedOperationException("Wrapped graph is not observable.");
        }
        if (this.observableDelegate == null) {
            return;
        }
        if (this.observableDelegate.removeGraphListener(listener)) {
            ((ObservableGraph)this.graph).removeGraphListener(this.graphListener);
            this.graphListener = null;
            this.observableDelegate = null;
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        if (this.graph == null) {
            throw new InvalidObjectException("Graph is null.");
        }
        if (this.nodePredicate == null) {
            throw new InvalidObjectException("Node Predicate is null.");
        }
        if (this.edgePredicate == null) {
            throw new InvalidObjectException("Edge Predicate is null.");
        }
        this.init();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class GraphListenerImpl
    implements GraphListener {
        protected GraphListenerImpl() {
        }

        public void nodeAdded(GraphEvent event) {
            Object node = event.getObject();
            if (FilteredGraph.this.nodePredicate.evaluate(node)) {
                FilteredGraph.this.observableDelegate.fireNodeAdded(node);
            }
        }

        public void nodeRemoved(GraphEvent event) {
            Object node = event.getObject();
            if (FilteredGraph.this.nodePredicate.evaluate(node)) {
                FilteredGraph.this.observableDelegate.fireNodeRemoved(node);
            }
        }

        public void edgeAdded(GraphEvent event) {
            Graph.Edge edge = (Graph.Edge)event.getObject();
            if (FilteredGraph.this.nodePredicate.evaluate(edge.getTail()) && FilteredGraph.this.nodePredicate.evaluate(edge.getHead()) && FilteredGraph.this.edgePredicate.evaluate((Object)edge)) {
                FilteredGraph.this.observableDelegate.fireEdgeAdded(edge);
            }
        }

        public void edgeRemoved(GraphEvent event) {
            Graph.Edge edge = (Graph.Edge)event.getObject();
            if (FilteredGraph.this.nodePredicate.evaluate(edge.getTail()) && FilteredGraph.this.nodePredicate.evaluate(edge.getHead()) && FilteredGraph.this.edgePredicate.evaluate((Object)edge)) {
                FilteredGraph.this.observableDelegate.fireEdgeRemoved(edge);
            }
        }
    }

    private static class EdgeTraverserPredicateAdapter
    implements Predicate,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Predicate edgePredicate;

        private EdgeTraverserPredicateAdapter(Predicate edgePredicate) {
            this.edgePredicate = edgePredicate;
        }

        public boolean evaluate(Object object) {
            return this.edgePredicate.evaluate(((List)object).get(1));
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof EdgeTraverserPredicateAdapter)) {
                return false;
            }
            return this.edgePredicate.equals(((EdgeTraverserPredicateAdapter)object).edgePredicate);
        }

        public int hashCode() {
            return this.edgePredicate.hashCode();
        }
    }

    private static class EdgeEndpointPredicate
    implements Predicate,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Predicate nodePredicate;

        private EdgeEndpointPredicate(Predicate nodePredicate) {
            this.nodePredicate = nodePredicate;
        }

        public boolean evaluate(Object object) {
            Graph.Edge edge = (Graph.Edge)object;
            return this.nodePredicate.evaluate(edge.getTail()) && this.nodePredicate.evaluate(edge.getHead());
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof EdgeEndpointPredicate)) {
                return false;
            }
            return this.nodePredicate.equals(((EdgeEndpointPredicate)object).nodePredicate);
        }

        public int hashCode() {
            return this.nodePredicate.hashCode();
        }
    }
}

