/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.plexus;

import com.phoenixst.collections.InvertibleTransformer;
import com.phoenixst.plexus.Graph;
import com.phoenixst.plexus.GraphWrapper;

public class GraphTransformer
extends GraphWrapper {
    private static final long serialVersionUID = 1L;
    protected InvertibleTransformer nodeTransformer;
    protected InvertibleTransformer edgeTransformer;

    public GraphTransformer(Graph g) {
        this(g, null, null);
    }

    public GraphTransformer(Graph g, InvertibleTransformer nodeTransformer) {
        this(g, nodeTransformer, null);
    }

    public GraphTransformer(Graph g, InvertibleTransformer nodeTransformer, InvertibleTransformer edgeTransformer) {
        super(g);
        this.setNodeTransformer(nodeTransformer);
        this.setEdgeTransformer(edgeTransformer);
    }

    protected Object wrapNode(Object node) {
        return this.nodeTransformer != null ? this.nodeTransformer.transform(node) : node;
    }

    protected Object unwrapNode(Object node) {
        return this.nodeTransformer != null ? this.nodeTransformer.untransform(node) : node;
    }

    protected Object wrapEdgeObject(Object edgeObject) {
        return this.edgeTransformer != null ? this.edgeTransformer.transform(edgeObject) : edgeObject;
    }

    protected Object unwrapEdgeObject(Object edgeObject) {
        return this.edgeTransformer != null ? this.edgeTransformer.untransform(edgeObject) : edgeObject;
    }

    public InvertibleTransformer getNodeTransformer() {
        return this.nodeTransformer;
    }

    public void setNodeTransformer(InvertibleTransformer nodeTransformer) {
        this.nodeTransformer = nodeTransformer;
    }

    public InvertibleTransformer getEdgeTransformer() {
        return this.edgeTransformer;
    }

    public void setEdgeTransformer(InvertibleTransformer edgeTransformer) {
        this.edgeTransformer = edgeTransformer;
    }
}

