/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.plexus;

import com.phoenixst.collections.UnmodifiableIterator;
import com.phoenixst.plexus.Graph;
import com.phoenixst.plexus.ObservableGraph;
import com.phoenixst.plexus.Traverser;
import com.phoenixst.plexus.util.SingletonEdgeIterator;
import com.phoenixst.plexus.util.SingletonGraph;
import com.phoenixst.plexus.util.SingletonTraverser;
import com.phoenixst.plexus.util.SynchronizedGraphWrapper;
import com.phoenixst.plexus.util.UnmodifiableGraphWrapper;
import com.phoenixst.plexus.util.UnmodifiableTraverser;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Predicate;
import org.apache.log4j.Logger;

public class GraphUtils {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$com$phoenixst$plexus$GraphUtils == null ? (class$com$phoenixst$plexus$GraphUtils = GraphUtils.class$("com.phoenixst.plexus.GraphUtils")) : class$com$phoenixst$plexus$GraphUtils));
    public static final int UNDIRECTED_MASK = 1;
    public static final int DIRECTED_OUT_MASK = 2;
    public static final int DIRECTED_IN_MASK = 4;
    public static final int DIRECTED_MASK = 6;
    public static final int ANY_DIRECTION_MASK = 7;
    public static final Traverser EMPTY_TRAVERSER = new Traverser(){

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new IllegalStateException();
        }

        public Graph.Edge getEdge() {
            throw new IllegalStateException();
        }

        public void removeEdge() {
            throw new IllegalStateException();
        }
    };
    public static final Predicate DIRECTED_EDGE_PREDICATE = DirectedEdgePredicate.INSTANCE;
    public static final Predicate UNDIRECTED_EDGE_PREDICATE = UndirectedEdgePredicate.INSTANCE;
    public static final Predicate SELF_EDGE_PREDICATE = SelfEdgePredicate.INSTANCE;
    public static final Predicate OUT_TRAVERSER_PREDICATE = OutTraverserPredicate.INSTANCE;
    public static final Predicate IN_TRAVERSER_PREDICATE = InTraverserPredicate.INSTANCE;
    public static final Predicate DIRECTED_TRAVERSER_PREDICATE = DirectedTraverserPredicate.INSTANCE;
    public static final Predicate UNDIRECTED_TRAVERSER_PREDICATE = UndirectedTraverserPredicate.INSTANCE;
    public static final Predicate SELF_TRAVERSER_PREDICATE = SelfTraverserPredicate.INSTANCE;
    private static final int[] inverseDirs = new int[]{0, 1, 4, 5, 2, 3, 6, 7};
    static /* synthetic */ Class class$com$phoenixst$plexus$GraphUtils;

    private GraphUtils() {
    }

    public static final int invertDirection(int directionFlags) {
        return inverseDirs[directionFlags];
    }

    public static void add(Graph destination, Graph source) {
        HashSet nodes = new HashSet(source.nodes(null));
        HashSet edges = new HashSet(source.edges(null));
        HashSet badObjects = new HashSet();
        HashMap<Graph.Edge, Graph.Edge> edgeMap = new HashMap<Graph.Edge, Graph.Edge>();
        while (!nodes.isEmpty() || !edges.isEmpty()) {
            Iterator nodeIter = nodes.iterator();
            while (nodeIter.hasNext()) {
                Object node = nodeIter.next();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Processing source node: " + node));
                }
                if (badObjects.contains(node)) {
                    LOGGER.debug((Object)"  Node is bad and can't be handled");
                } else {
                    Graph.Edge edge;
                    if (node instanceof Graph.Edge && source.containsEdge(edge = (Graph.Edge)node)) {
                        node = edgeMap.get(edge);
                        if (node == null) {
                            LOGGER.debug((Object)"  Node is an Edge, deal with it later");
                            continue;
                        }
                        LOGGER.debug((Object)"  Node is an Edge, but is ready to be added");
                    }
                    LOGGER.debug((Object)"  Adding node to destination");
                    if (!destination.addNode(node)) {
                        LOGGER.debug((Object)"  Node couldn't be added, marking it as bad");
                        badObjects.add(node);
                    }
                }
                nodeIter.remove();
            }
            Iterator edgeIter = edges.iterator();
            while (edgeIter.hasNext()) {
                Graph.Edge edge = (Graph.Edge)edgeIter.next();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Processing source edge: " + edge));
                }
                Object tail = edge.getTail();
                Object head = edge.getHead();
                if (badObjects.contains(tail) || badObjects.contains(head)) {
                    LOGGER.debug((Object)"  Edge has a bad endpoint, marking it as bad");
                    badObjects.add(edge);
                    edgeIter.remove();
                    continue;
                }
                if (edgeMap.containsKey(tail)) {
                    tail = edgeMap.get(tail);
                }
                if (edgeMap.containsKey(head)) {
                    head = edgeMap.get(head);
                }
                if (destination.containsNode(tail) && destination.containsNode(head)) {
                    LOGGER.debug((Object)"  Endpoints are present in destination, adding Edge");
                    Graph.Edge newEdge = destination.addEdge(edge.getUserObject(), tail, head, edge.isDirected());
                    if (newEdge != null) {
                        edgeMap.put(edge, newEdge);
                    } else {
                        LOGGER.debug((Object)"  Edge couldn't be added, marking it as bad");
                        badObjects.add(edge);
                    }
                    edgeIter.remove();
                    continue;
                }
                LOGGER.debug((Object)"  Endpoints are not yet present in destination, deal with it later");
            }
        }
    }

    public static final boolean equals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public static Graph singletonGraph(Object node) {
        return new SingletonGraph(node);
    }

    public static Iterator singletonEdgeIterator(Graph graph, Graph.Edge edge) {
        return new SingletonEdgeIterator(graph, edge);
    }

    public static Traverser singletonTraverser(Graph graph, Object endpoint, Graph.Edge edge) {
        return new SingletonTraverser(graph, endpoint, edge);
    }

    public static Iterator unmodifiableIterator(Iterator iterator) {
        return new UnmodifiableIterator(iterator);
    }

    public static Traverser unmodifiableTraverser(Traverser traverser) {
        return new UnmodifiableTraverser(traverser);
    }

    public static ObservableGraph unmodifiableGraph(Graph g) {
        return new UnmodifiableGraphWrapper(g);
    }

    public static ObservableGraph synchronizedGraph(Graph g) {
        return new SynchronizedGraphWrapper(g);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class SelfTraverserPredicate
    implements Predicate,
    Serializable {
        private static final long serialVersionUID = 1L;
        static final SelfTraverserPredicate INSTANCE = new SelfTraverserPredicate();

        private SelfTraverserPredicate() {
        }

        public boolean evaluate(Object object) {
            List list = (List)object;
            Graph.Edge edge = (Graph.Edge)list.get(1);
            Object tail = edge.getTail();
            Object head = edge.getHead();
            return tail == null ? head == null : tail.equals(head);
        }

        public String toString() {
            return "SELF_TRAVERSER_PREDICATE";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static final class UndirectedTraverserPredicate
    implements Predicate,
    Serializable {
        private static final long serialVersionUID = 1L;
        static final UndirectedTraverserPredicate INSTANCE = new UndirectedTraverserPredicate();

        private UndirectedTraverserPredicate() {
        }

        public boolean evaluate(Object object) {
            List list = (List)object;
            Graph.Edge edge = (Graph.Edge)list.get(1);
            return !edge.isDirected();
        }

        public String toString() {
            return "UNDIRECTED_TRAVERSER_PREDICATE";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static final class DirectedTraverserPredicate
    implements Predicate,
    Serializable {
        private static final long serialVersionUID = 1L;
        static final DirectedTraverserPredicate INSTANCE = new DirectedTraverserPredicate();

        private DirectedTraverserPredicate() {
        }

        public boolean evaluate(Object object) {
            List list = (List)object;
            Graph.Edge edge = (Graph.Edge)list.get(1);
            return edge.isDirected();
        }

        public String toString() {
            return "DIRECTED_TRAVERSER_PREDICATE";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static final class InTraverserPredicate
    implements Predicate,
    Serializable {
        private static final long serialVersionUID = 1L;
        static final InTraverserPredicate INSTANCE = new InTraverserPredicate();

        private InTraverserPredicate() {
        }

        public boolean evaluate(Object object) {
            List list = (List)object;
            Object baseNode = list.get(0);
            Graph.Edge edge = (Graph.Edge)list.get(1);
            Object head = edge.getHead();
            return edge.isDirected() && (baseNode == null ? head == null : baseNode.equals(head));
        }

        public String toString() {
            return "IN_TRAVERSER_PREDICATE";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static final class OutTraverserPredicate
    implements Predicate,
    Serializable {
        private static final long serialVersionUID = 1L;
        static final OutTraverserPredicate INSTANCE = new OutTraverserPredicate();

        private OutTraverserPredicate() {
        }

        public boolean evaluate(Object object) {
            List list = (List)object;
            Object baseNode = list.get(0);
            Graph.Edge edge = (Graph.Edge)list.get(1);
            Object tail = edge.getTail();
            return edge.isDirected() && (baseNode == null ? tail == null : baseNode.equals(tail));
        }

        public String toString() {
            return "OUT_TRAVERSER_PREDICATE";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static final class SelfEdgePredicate
    implements Predicate,
    Serializable {
        private static final long serialVersionUID = 1L;
        static final SelfEdgePredicate INSTANCE = new SelfEdgePredicate();

        private SelfEdgePredicate() {
        }

        public boolean evaluate(Object object) {
            Graph.Edge edge = (Graph.Edge)object;
            Object tail = edge.getTail();
            Object head = edge.getHead();
            return tail == null ? head == null : tail.equals(head);
        }

        public String toString() {
            return "SELF_EDGE_PREDICATE";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static final class UndirectedEdgePredicate
    implements Predicate,
    Serializable {
        private static final long serialVersionUID = 1L;
        static final UndirectedEdgePredicate INSTANCE = new UndirectedEdgePredicate();

        private UndirectedEdgePredicate() {
        }

        public boolean evaluate(Object object) {
            return !((Graph.Edge)object).isDirected();
        }

        public String toString() {
            return "UNDIRECTED_EDGE_PREDICATE";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static final class DirectedEdgePredicate
    implements Predicate,
    Serializable {
        private static final long serialVersionUID = 1L;
        static final DirectedEdgePredicate INSTANCE = new DirectedEdgePredicate();

        private DirectedEdgePredicate() {
        }

        public boolean evaluate(Object object) {
            return ((Graph.Edge)object).isDirected();
        }

        public String toString() {
            return "DIRECTED_EDGE_PREDICATE";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

