/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.plexus;

import com.phoenixst.collections.CollectionWrapper;
import com.phoenixst.collections.EqualPredicate;
import com.phoenixst.collections.FalsePredicate;
import com.phoenixst.collections.OrderedPair;
import com.phoenixst.collections.TruePredicate;
import com.phoenixst.plexus.EdgePredicate;
import com.phoenixst.plexus.EdgePredicateFactory;
import com.phoenixst.plexus.Graph;
import com.phoenixst.plexus.GraphEvent;
import com.phoenixst.plexus.GraphListener;
import com.phoenixst.plexus.GraphUtils;
import com.phoenixst.plexus.ObservableGraph;
import com.phoenixst.plexus.Traverser;
import com.phoenixst.plexus.TraverserPredicate;
import com.phoenixst.plexus.TraverserPredicateFactory;
import com.phoenixst.plexus.util.EqualsTraverserPredicate;
import com.phoenixst.plexus.util.ObservableGraphDelegate;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.Predicate;
import org.apache.log4j.Logger;

public class GraphWrapper
implements ObservableGraph,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger((Class)(class$com$phoenixst$plexus$GraphWrapper == null ? (class$com$phoenixst$plexus$GraphWrapper = GraphWrapper.class$("com.phoenixst.plexus.GraphWrapper")) : class$com$phoenixst$plexus$GraphWrapper));
    protected Graph delegate;
    transient ObservableGraphDelegate observableDelegate;
    private transient GraphListener wrappedGraphListener;
    static /* synthetic */ Class class$com$phoenixst$plexus$GraphWrapper;

    public GraphWrapper(Graph delegate) {
        if (delegate == null) {
            throw new NullPointerException();
        }
        this.delegate = delegate;
    }

    protected Object wrapNode(Object node) {
        return node;
    }

    protected Object unwrapNode(Object node) {
        return node;
    }

    protected Object wrapEdgeObject(Object edgeObject) {
        return edgeObject;
    }

    protected Object unwrapEdgeObject(Object edgeObject) {
        return edgeObject;
    }

    protected EdgeWrapper createEdge(Graph.Edge edge) {
        return new EdgeWrapper(this, edge);
    }

    protected Traverser wrapTraverser(Traverser traverser) {
        return new TraverserWrapper(traverser);
    }

    protected Predicate wrapNodePredicate(Predicate nodePredicate) {
        if (nodePredicate == null || nodePredicate == FalsePredicate.INSTANCE || nodePredicate == TruePredicate.INSTANCE) {
            return nodePredicate;
        }
        if (nodePredicate instanceof EqualPredicate) {
            Object wrapperNode = ((EqualPredicate)nodePredicate).getTestObject();
            return new EqualPredicate(this.toDelegateNode(wrapperNode));
        }
        return new NodePredicateWrapper(nodePredicate);
    }

    protected Predicate wrapEdgePredicate(Predicate edgePredicate) {
        if (edgePredicate == null || edgePredicate == FalsePredicate.INSTANCE || edgePredicate == TruePredicate.INSTANCE || edgePredicate == GraphUtils.DIRECTED_EDGE_PREDICATE || edgePredicate == GraphUtils.UNDIRECTED_EDGE_PREDICATE || edgePredicate == GraphUtils.SELF_EDGE_PREDICATE) {
            return edgePredicate;
        }
        if (edgePredicate instanceof EqualPredicate) {
            Graph.Edge wrapperEdge = (Graph.Edge)((EqualPredicate)edgePredicate).getTestObject();
            return new EqualPredicate(this.toDelegateEdge(wrapperEdge));
        }
        if (edgePredicate instanceof EdgePredicate) {
            EdgePredicate predicate = (EdgePredicate)edgePredicate;
            return EdgePredicateFactory.createPredicated(this.convertEdgeObjectSpec(predicate.getUserObjectSpecification()), this.convertNodeSpec(predicate.getFirstNodeSpecification()), this.convertNodeSpec(predicate.getSecondNodeSpecification()), predicate.getDirectionFlags());
        }
        return new EdgePredicateWrapper(edgePredicate);
    }

    protected Predicate wrapTraverserPredicate(Predicate traverserPredicate) {
        if (traverserPredicate == null || traverserPredicate == FalsePredicate.INSTANCE || traverserPredicate == TruePredicate.INSTANCE || traverserPredicate == GraphUtils.OUT_TRAVERSER_PREDICATE || traverserPredicate == GraphUtils.IN_TRAVERSER_PREDICATE || traverserPredicate == GraphUtils.DIRECTED_TRAVERSER_PREDICATE || traverserPredicate == GraphUtils.UNDIRECTED_TRAVERSER_PREDICATE || traverserPredicate == GraphUtils.SELF_TRAVERSER_PREDICATE) {
            return traverserPredicate;
        }
        if (traverserPredicate instanceof EqualsTraverserPredicate) {
            Graph.Edge wrapperEdge = ((EqualsTraverserPredicate)traverserPredicate).getTestEdge();
            return new EqualsTraverserPredicate(this.toDelegateEdge(wrapperEdge));
        }
        if (traverserPredicate instanceof TraverserPredicate) {
            TraverserPredicate predicate = (TraverserPredicate)traverserPredicate;
            return TraverserPredicateFactory.createPredicated(this.convertEdgeObjectSpec(predicate.getUserObjectSpecification()), this.convertNodeSpec(predicate.getNodeSpecification()), predicate.getDirectionFlags());
        }
        return new TraverserPredicateWrapper(traverserPredicate);
    }

    Object toWrapperNode(Object node) {
        Graph.Edge edge;
        if (node instanceof Graph.Edge && this.delegate.containsEdge(edge = (Graph.Edge)node)) {
            return this.toWrapperEdge(edge);
        }
        return this.wrapNode(node);
    }

    Object toDelegateNode(Object node) {
        Graph.Edge edge;
        if (node instanceof Graph.Edge && (edge = this.toDelegateEdge((Graph.Edge)node)) != null) {
            return edge;
        }
        return this.unwrapNode(node);
    }

    EdgeWrapper toWrapperEdge(Graph.Edge edge) {
        return edge != null ? this.createEdge(edge) : null;
    }

    Graph.Edge toDelegateEdge(Graph.Edge edge) {
        if (edge instanceof EdgeWrapper) {
            EdgeWrapper edgeWrapper = (EdgeWrapper)edge;
            if (edgeWrapper.graphWrapper == this) {
                return edgeWrapper.edge;
            }
        }
        return null;
    }

    private Predicate convertNodeSpec(Object object) {
        if (object == FalsePredicate.INSTANCE || object == TruePredicate.INSTANCE) {
            return (Predicate)object;
        }
        if (object instanceof EqualPredicate) {
            Object wrapperNode = ((EqualPredicate)object).getTestObject();
            return new EqualPredicate(this.toDelegateNode(wrapperNode));
        }
        if (object instanceof Predicate) {
            return new NodePredicateWrapper((Predicate)object);
        }
        return new EqualPredicate(this.toDelegateNode(object));
    }

    private Predicate convertEdgeObjectSpec(Object object) {
        if (object == FalsePredicate.INSTANCE || object == TruePredicate.INSTANCE) {
            return (Predicate)object;
        }
        if (object instanceof EqualPredicate) {
            Object wrapperEdgeObject = ((EqualPredicate)object).getTestObject();
            return new EqualPredicate(this.unwrapEdgeObject(wrapperEdgeObject));
        }
        if (object instanceof Predicate) {
            return new EdgeObjectPredicateWrapper((Predicate)object);
        }
        return new EqualPredicate(this.unwrapEdgeObject(object));
    }

    public boolean addNode(Object node) {
        return this.delegate.addNode(this.toDelegateNode(node));
    }

    public boolean removeNode(Object node) {
        return this.delegate.removeNode(this.toDelegateNode(node));
    }

    public boolean containsNode(Object node) {
        return this.delegate.containsNode(this.toDelegateNode(node));
    }

    public Graph.Edge addEdge(Object object, Object tail, Object head, boolean isDirected) {
        return this.toWrapperEdge(this.delegate.addEdge(this.unwrapEdgeObject(object), this.toDelegateNode(tail), this.toDelegateNode(head), isDirected));
    }

    public boolean removeEdge(Graph.Edge edge) {
        return this.delegate.removeEdge(this.toDelegateEdge(edge));
    }

    public boolean containsEdge(Graph.Edge edge) {
        return this.delegate.containsEdge(this.toDelegateEdge(edge));
    }

    public int degree(Object node) {
        return this.delegate.degree(this.toDelegateNode(node));
    }

    public int degree(Object node, Predicate traverserPredicate) {
        return this.delegate.degree(this.toDelegateNode(node), this.wrapTraverserPredicate(traverserPredicate));
    }

    public Collection nodes(Predicate nodePredicate) {
        return new NodeCollection(this.delegate.nodes(this.wrapNodePredicate(nodePredicate)));
    }

    public Collection edges(Predicate edgePredicate) {
        return new EdgeCollection(this.delegate.edges(this.wrapEdgePredicate(edgePredicate)));
    }

    public Collection adjacentNodes(Object node, Predicate traverserPredicate) {
        return new NodeCollection(this.delegate.adjacentNodes(this.toDelegateNode(node), this.wrapTraverserPredicate(traverserPredicate)));
    }

    public Collection incidentEdges(Object node, Predicate traverserPredicate) {
        return new EdgeCollection(this.delegate.incidentEdges(this.toDelegateNode(node), this.wrapTraverserPredicate(traverserPredicate)));
    }

    public Object getNode(Predicate nodePredicate) {
        return this.toWrapperNode(this.delegate.getNode(this.wrapNodePredicate(nodePredicate)));
    }

    public Graph.Edge getEdge(Predicate edgePredicate) {
        return this.toWrapperEdge(this.delegate.getEdge(this.wrapEdgePredicate(edgePredicate)));
    }

    public Object getAdjacentNode(Object node, Predicate traverserPredicate) {
        Graph.Edge edge = this.getIncidentEdge(node, traverserPredicate);
        return edge != null ? edge.getOtherEndpoint(node) : null;
    }

    public Graph.Edge getIncidentEdge(Object node, Predicate traverserPredicate) {
        return this.toWrapperEdge(this.delegate.getIncidentEdge(this.toDelegateNode(node), this.wrapTraverserPredicate(traverserPredicate)));
    }

    public Traverser traverser(Object node, Predicate traverserPredicate) {
        return this.wrapTraverser(this.delegate.traverser(this.toDelegateNode(node), this.wrapTraverserPredicate(traverserPredicate)));
    }

    public void addGraphListener(GraphListener listener) {
        if (!(this.delegate instanceof ObservableGraph)) {
            throw new UnsupportedOperationException("Wrapped graph is not observable.");
        }
        if (this.observableDelegate == null) {
            this.observableDelegate = new ObservableGraphDelegate(this, LOGGER);
            this.wrappedGraphListener = new WrappedGraphListener();
            ((ObservableGraph)this.delegate).addGraphListener(this.wrappedGraphListener);
        }
        this.observableDelegate.addGraphListener(listener);
    }

    public void removeGraphListener(GraphListener listener) {
        if (!(this.delegate instanceof ObservableGraph)) {
            throw new UnsupportedOperationException("Wrapped graph is not observable.");
        }
        if (this.observableDelegate == null) {
            return;
        }
        if (this.observableDelegate.removeGraphListener(listener)) {
            ((ObservableGraph)this.delegate).removeGraphListener(this.wrappedGraphListener);
            this.wrappedGraphListener = null;
            this.observableDelegate = null;
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        if (this.delegate == null) {
            throw new InvalidObjectException("Wrapped Graph is null.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class WrappedGraphListener
    implements GraphListener {
        protected WrappedGraphListener() {
        }

        public void nodeAdded(GraphEvent event) {
            GraphWrapper.this.observableDelegate.fireNodeAdded(GraphWrapper.this.toWrapperNode(event.getObject()));
        }

        public void nodeRemoved(GraphEvent event) {
            GraphWrapper.this.observableDelegate.fireNodeRemoved(GraphWrapper.this.toWrapperNode(event.getObject()));
        }

        public void edgeAdded(GraphEvent event) {
            GraphWrapper.this.observableDelegate.fireEdgeAdded(GraphWrapper.this.toWrapperEdge((Graph.Edge)event.getObject()));
        }

        public void edgeRemoved(GraphEvent event) {
            GraphWrapper.this.observableDelegate.fireEdgeRemoved(GraphWrapper.this.toWrapperEdge((Graph.Edge)event.getObject()));
        }
    }

    protected class TraverserWrapper
    implements Traverser {
        protected Traverser i;

        public TraverserWrapper(Traverser i) {
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public Object next() {
            return GraphWrapper.this.toWrapperNode(this.i.next());
        }

        public void remove() {
            this.i.remove();
        }

        public Graph.Edge getEdge() {
            return GraphWrapper.this.toWrapperEdge(this.i.getEdge());
        }

        public void removeEdge() {
            this.i.removeEdge();
        }
    }

    protected class EdgeCollection
    extends CollectionWrapper {
        public EdgeCollection(Collection collection) {
            super(collection);
        }

        protected Object wrapObject(Object object) {
            return GraphWrapper.this.toWrapperEdge((Graph.Edge)object);
        }

        protected Object unwrapObject(Object object) {
            return GraphWrapper.this.toDelegateEdge((Graph.Edge)object);
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object object) {
            return object instanceof Graph.Edge && super.remove(object);
        }

        public boolean contains(Object object) {
            return object instanceof Graph.Edge && super.contains(object);
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }
    }

    protected class NodeCollection
    extends CollectionWrapper {
        public NodeCollection(Collection collection) {
            super(collection);
        }

        protected Object wrapObject(Object object) {
            return GraphWrapper.this.toWrapperNode(object);
        }

        protected Object unwrapObject(Object object) {
            return GraphWrapper.this.toDelegateNode(object);
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }
    }

    private class TraverserPredicateWrapper
    implements Predicate {
        private Predicate traverserPredicate;
        private OrderedPair pair;

        public TraverserPredicateWrapper(Predicate traverserPredicate) {
            this.traverserPredicate = traverserPredicate;
            this.pair = new OrderedPair(null, null);
        }

        public boolean evaluate(Object object) {
            List list = (List)object;
            this.pair.set(0, GraphWrapper.this.toWrapperNode(list.get(0)));
            this.pair.set(1, GraphWrapper.this.toWrapperEdge((Graph.Edge)list.get(1)));
            return this.traverserPredicate.evaluate((Object)this.pair);
        }
    }

    private class EdgeObjectPredicateWrapper
    implements Predicate {
        private Predicate userPredicate;

        public EdgeObjectPredicateWrapper(Predicate userPredicate) {
            this.userPredicate = userPredicate;
        }

        public boolean evaluate(Object object) {
            return this.userPredicate.evaluate(GraphWrapper.this.wrapEdgeObject(object));
        }
    }

    private class EdgePredicateWrapper
    implements Predicate {
        private Predicate edgePredicate;

        public EdgePredicateWrapper(Predicate edgePredicate) {
            this.edgePredicate = edgePredicate;
        }

        public boolean evaluate(Object object) {
            return this.edgePredicate.evaluate((Object)GraphWrapper.this.toWrapperEdge((Graph.Edge)object));
        }
    }

    private class NodePredicateWrapper
    implements Predicate {
        private Predicate nodePredicate;

        public NodePredicateWrapper(Predicate nodePredicate) {
            this.nodePredicate = nodePredicate;
        }

        public boolean evaluate(Object object) {
            return this.nodePredicate.evaluate(GraphWrapper.this.toWrapperNode(object));
        }
    }

    protected static class EdgeWrapper
    implements Graph.Edge,
    Serializable {
        private static final long serialVersionUID = 1L;
        GraphWrapper graphWrapper;
        protected Graph.Edge edge;

        protected EdgeWrapper(GraphWrapper graphWrapper, Graph.Edge edge) {
            this.graphWrapper = graphWrapper;
            this.edge = edge;
        }

        public boolean isDirected() {
            return this.edge.isDirected();
        }

        public Object getUserObject() {
            return this.graphWrapper.wrapEdgeObject(this.edge.getUserObject());
        }

        public void setUserObject(Object object) {
            this.edge.setUserObject(this.graphWrapper.unwrapEdgeObject(object));
        }

        public Object getTail() {
            return this.graphWrapper.toWrapperNode(this.edge.getTail());
        }

        public Object getHead() {
            return this.graphWrapper.toWrapperNode(this.edge.getHead());
        }

        public Object getOtherEndpoint(Object node) {
            return this.graphWrapper.toWrapperNode(this.edge.getOtherEndpoint(this.graphWrapper.toDelegateNode(node)));
        }

        private boolean testEquals(EdgeWrapper edgeWrapper) {
            return edgeWrapper.graphWrapper == this.graphWrapper && ((Object)this.edge).equals(edgeWrapper.edge);
        }

        public boolean equals(Object object) {
            return this == object || object instanceof EdgeWrapper && this.testEquals((EdgeWrapper)object);
        }

        public boolean equals(EdgeWrapper edgeWrapper) {
            return this == edgeWrapper || edgeWrapper != null && this.testEquals(edgeWrapper);
        }

        public int hashCode() {
            return ((Object)this.edge).hashCode();
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append(this.getTail());
            s.append(" -- (");
            s.append(this.getUserObject());
            s.append(this.isDirected() ? ") -> " : ") -- ");
            s.append(this.getHead());
            return s.toString();
        }

        private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
            in.defaultReadObject();
            if (this.graphWrapper == null) {
                throw new InvalidObjectException("GraphWrapper is null.");
            }
            if (this.edge == null) {
                throw new InvalidObjectException("Wrapped Graph.Edge is null.");
            }
        }
    }
}

