/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.plexus;

import com.phoenixst.plexus.Graph;
import com.phoenixst.plexus.GraphListener;
import com.phoenixst.plexus.ObservableGraph;
import com.phoenixst.plexus.Traverser;
import com.phoenixst.plexus.util.AdjacentNodeCollection;
import com.phoenixst.plexus.util.ObservableGraphDelegate;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.Predicate;
import org.apache.log4j.Logger;

public class ObservableGraphWrapper
implements ObservableGraph,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger((Class)(class$com$phoenixst$plexus$ObservableGraphWrapper == null ? (class$com$phoenixst$plexus$ObservableGraphWrapper = ObservableGraphWrapper.class$("com.phoenixst.plexus.ObservableGraphWrapper")) : class$com$phoenixst$plexus$ObservableGraphWrapper));
    protected Graph graph;
    private transient ObservableGraphDelegate observableDelegate;
    static /* synthetic */ Class class$com$phoenixst$plexus$ObservableGraphWrapper;

    public ObservableGraphWrapper(Graph graph) {
        this.graph = graph;
        if (graph == null) {
            throw new NullPointerException();
        }
    }

    protected void removeIncidentEdges(Object node) {
        Traverser t = this.graph.traverser(node, null);
        while (t.hasNext()) {
            t.next();
            Graph.Edge edge = t.getEdge();
            t.removeEdge();
            this.fireEdgeRemoved(edge);
        }
    }

    void fireNodeAdded(Object node) {
        if (this.observableDelegate != null) {
            this.observableDelegate.fireNodeAdded(node);
        }
    }

    void fireNodeRemoved(Object node) {
        if (this.observableDelegate != null) {
            this.observableDelegate.fireNodeRemoved(node);
        }
    }

    void fireEdgeAdded(Graph.Edge edge) {
        if (this.observableDelegate != null) {
            this.observableDelegate.fireEdgeAdded(edge);
        }
    }

    void fireEdgeRemoved(Graph.Edge edge) {
        if (this.observableDelegate != null) {
            this.observableDelegate.fireEdgeRemoved(edge);
        }
    }

    public boolean addNode(Object node) {
        if (!this.graph.addNode(node)) {
            return false;
        }
        this.fireNodeAdded(node);
        return true;
    }

    public boolean removeNode(Object node) {
        if (!this.graph.containsNode(node)) {
            return false;
        }
        this.removeIncidentEdges(node);
        if (this.graph.removeNode(node)) {
            this.fireNodeRemoved(node);
        }
        return true;
    }

    public boolean containsNode(Object node) {
        return this.graph.containsNode(node);
    }

    public Graph.Edge addEdge(Object object, Object tail, Object head, boolean isDirected) {
        Graph.Edge edge = this.graph.addEdge(object, tail, head, isDirected);
        if (edge != null) {
            this.fireEdgeAdded(edge);
        }
        return edge;
    }

    public boolean removeEdge(Graph.Edge edge) {
        if (!this.graph.removeEdge(edge)) {
            return false;
        }
        this.fireEdgeRemoved(edge);
        return true;
    }

    public boolean containsEdge(Graph.Edge edge) {
        return this.graph.containsEdge(edge);
    }

    public int degree(Object node) {
        return this.graph.degree(node);
    }

    public int degree(Object node, Predicate traverserPredicate) {
        return this.graph.degree(node, traverserPredicate);
    }

    public Collection nodes(Predicate nodePredicate) {
        return new ObservableNodeCollection(this.graph.nodes(nodePredicate));
    }

    public Collection edges(Predicate edgePredicate) {
        return new ObservableEdgeCollection(this.graph.edges(edgePredicate));
    }

    public Collection adjacentNodes(Object node, Predicate traverserPredicate) {
        return new AdjacentNodeCollection(this, node, traverserPredicate);
    }

    public Collection incidentEdges(Object node, Predicate traverserPredicate) {
        return new ObservableEdgeCollection(this.graph.incidentEdges(node, traverserPredicate));
    }

    public Object getNode(Predicate nodePredicate) {
        return this.graph.getNode(nodePredicate);
    }

    public Graph.Edge getEdge(Predicate edgePredicate) {
        return this.graph.getEdge(edgePredicate);
    }

    public Object getAdjacentNode(Object node, Predicate traverserPredicate) {
        return this.graph.getAdjacentNode(node, traverserPredicate);
    }

    public Graph.Edge getIncidentEdge(Object node, Predicate traverserPredicate) {
        return this.graph.getIncidentEdge(node, traverserPredicate);
    }

    public Traverser traverser(Object node, Predicate traverserPredicate) {
        return new ObservableTraverserWrapper(this.graph.traverser(node, traverserPredicate));
    }

    public void addGraphListener(GraphListener listener) {
        if (this.observableDelegate == null) {
            this.observableDelegate = new ObservableGraphDelegate(this, LOGGER);
        }
        this.observableDelegate.addGraphListener(listener);
    }

    public void removeGraphListener(GraphListener listener) {
        if (this.observableDelegate == null) {
            return;
        }
        if (this.observableDelegate.removeGraphListener(listener)) {
            this.observableDelegate = null;
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        if (this.graph == null) {
            throw new InvalidObjectException("Graph is null.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ObservableEdgeCollection
    extends AbstractCollection {
        private Collection collection;

        public ObservableEdgeCollection(Collection collection) {
            this.collection = collection;
        }

        public int size() {
            return this.collection.size();
        }

        public boolean isEmpty() {
            return this.collection.isEmpty();
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object object) {
            if (!this.collection.remove(object)) {
                return false;
            }
            ObservableGraphWrapper.this.fireEdgeRemoved((Graph.Edge)object);
            return true;
        }

        public boolean contains(Object object) {
            return this.collection.contains(object);
        }

        public Iterator iterator() {
            return new ObservableEdgeIteratorWrapper(this.collection.iterator());
        }

        public boolean containsAll(Collection c) {
            return this.collection.containsAll(c);
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }
    }

    private class ObservableNodeCollection
    extends AbstractCollection {
        private Collection collection;

        public ObservableNodeCollection(Collection collection) {
            this.collection = collection;
        }

        public int size() {
            return this.collection.size();
        }

        public boolean isEmpty() {
            return this.collection.isEmpty();
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object object) {
            if (!this.collection.contains(object)) {
                return false;
            }
            ObservableGraphWrapper.this.removeIncidentEdges(object);
            if (this.collection.remove(object)) {
                ObservableGraphWrapper.this.fireNodeRemoved(object);
            }
            return true;
        }

        public boolean contains(Object object) {
            return this.collection.contains(object);
        }

        public Iterator iterator() {
            return new ObservableNodeIteratorWrapper(this.collection.iterator());
        }

        public boolean containsAll(Collection c) {
            return this.collection.containsAll(c);
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }
    }

    private class ObservableTraverserWrapper
    extends ObservableNodeIteratorWrapper
    implements Traverser {
        private ObservableTraverserWrapper(Traverser t) {
            super(t);
        }

        public Graph.Edge getEdge() {
            return ((Traverser)this.i).getEdge();
        }

        public void removeEdge() {
            Graph.Edge edge = ((Traverser)this.i).getEdge();
            ((Traverser)this.i).removeEdge();
            ObservableGraphWrapper.this.fireEdgeRemoved(edge);
        }
    }

    private class ObservableEdgeIteratorWrapper
    implements Iterator {
        private Iterator i;
        private Graph.Edge currentEdge;

        private ObservableEdgeIteratorWrapper(Iterator i) {
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public Object next() {
            this.currentEdge = (Graph.Edge)this.i.next();
            return this.currentEdge;
        }

        public void remove() {
            this.i.remove();
            ObservableGraphWrapper.this.fireEdgeRemoved(this.currentEdge);
        }
    }

    private class ObservableNodeIteratorWrapper
    implements Iterator {
        Iterator i;
        private Object currentNode;
        private boolean isCurrentValid = false;

        private ObservableNodeIteratorWrapper(Iterator i) {
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public Object next() {
            this.currentNode = this.i.next();
            this.isCurrentValid = true;
            return this.currentNode;
        }

        public void remove() {
            if (!this.isCurrentValid) {
                throw new IllegalStateException();
            }
            ObservableGraphWrapper.this.removeIncidentEdges(this.currentNode);
            this.i.remove();
            ObservableGraphWrapper.this.fireNodeRemoved(this.currentNode);
            this.isCurrentValid = false;
        }
    }
}

