/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.plexus;

import com.phoenixst.collections.SimpleStack;
import com.phoenixst.plexus.Graph;
import com.phoenixst.plexus.NoSuchNodeException;
import com.phoenixst.plexus.OrientedForestView;
import com.phoenixst.plexus.Traverser;
import com.phoenixst.plexus.util.ChildTraverserFactory;
import com.phoenixst.plexus.util.DefaultTraverserFactory;
import com.phoenixst.plexus.util.SingletonTraverser;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.log4j.Logger;

public class PostOrderTraverser
implements Traverser {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$com$phoenixst$plexus$PostOrderTraverser == null ? (class$com$phoenixst$plexus$PostOrderTraverser = PostOrderTraverser.class$("com.phoenixst.plexus.PostOrderTraverser")) : class$com$phoenixst$plexus$PostOrderTraverser));
    private Transformer traverserFactory;
    private SimpleStack nodeStack;
    private SimpleStack traverserStack;
    static /* synthetic */ Class class$com$phoenixst$plexus$PostOrderTraverser;

    public PostOrderTraverser(Object startNode, Graph graph, Predicate traverserPredicate) {
        this(startNode, graph, new DefaultTraverserFactory(graph, traverserPredicate));
    }

    public PostOrderTraverser(Object startNode, OrientedForestView forestView) {
        this(startNode, forestView.getGraph(), new ChildTraverserFactory(forestView));
    }

    public PostOrderTraverser(Object startNode, Transformer traverserFactory) {
        this(startNode, null, traverserFactory);
    }

    private PostOrderTraverser(Object startNode, Graph graph, Transformer traverserFactory) {
        this.traverserFactory = traverserFactory;
        if (traverserFactory == null) {
            throw new NullPointerException("Traverser Factory is null.");
        }
        if (graph == null) {
            traverserFactory.transform(startNode);
        } else if (!graph.containsNode(startNode)) {
            throw new NoSuchNodeException("Graph does not contain start node: " + startNode);
        }
        this.nodeStack = new SimpleStack();
        this.traverserStack = new SimpleStack();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Constructor: Pushing trivial Traverser to " + startNode + " onto Traverser stack."));
        }
        this.traverserStack.push(new SingletonTraverser(graph, startNode, null));
    }

    public boolean hasNext() {
        LOGGER.debug((Object)"hasNext(): Calling isEmpty() on node stack OR hasNext() on top Traverser.");
        return !this.nodeStack.isEmpty() || ((Traverser)this.traverserStack.peek()).hasNext();
    }

    public Object next() {
        LOGGER.debug((Object)"next():");
        Traverser top = (Traverser)this.traverserStack.peek();
        LOGGER.debug((Object)"  Calling hasNext() on top Traverser.");
        if (!top.hasNext()) {
            LOGGER.debug((Object)"  Top Traverser has nothing left to return.");
            if (this.nodeStack.isEmpty()) {
                throw new NoSuchElementException();
            }
            LOGGER.debug((Object)"  Popping top Traverser and top node, returning the node.");
            this.traverserStack.pop();
            return this.nodeStack.pop();
        }
        while (true) {
            Object node = top.next();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("  Creating new Traverser for " + node + "."));
            }
            if (!(top = (Traverser)this.traverserFactory.transform(node)).hasNext()) {
                LOGGER.debug((Object)"  Node is a leaf, return it.");
                return node;
            }
            LOGGER.debug((Object)"  Node is not a leaf, push it and push its Traverser.");
            this.nodeStack.push(node);
            this.traverserStack.push(top);
        }
    }

    public void remove() {
        if (this.traverserStack.isEmpty()) {
            throw new IllegalStateException();
        }
        LOGGER.debug((Object)"remove(): Calling remove() on top Traverser of stack.");
        ((Traverser)this.traverserStack.peek()).remove();
    }

    public Graph.Edge getEdge() {
        if (this.traverserStack.isEmpty()) {
            throw new IllegalStateException();
        }
        LOGGER.debug((Object)"getEdge(): Calling getEdge() on top Traverser of stack.");
        return ((Traverser)this.traverserStack.peek()).getEdge();
    }

    public void removeEdge() {
        if (this.traverserStack.isEmpty()) {
            throw new IllegalStateException();
        }
        LOGGER.debug((Object)"removeEdge(): Calling removeEdge() on top Traverser of stack.");
        ((Traverser)this.traverserStack.peek()).removeEdge();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

