/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.plexus;

import com.phoenixst.collections.EqualPredicate;
import com.phoenixst.collections.TruePredicate;
import com.phoenixst.plexus.Graph;
import com.phoenixst.plexus.GraphUtils;
import com.phoenixst.plexus.TraverserPredicate;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.collections.Predicate;

public class TraverserPredicateFactory {
    private TraverserPredicateFactory() {
    }

    public static final TraverserPredicate create(Graph.Edge edge, boolean fromTail) {
        Object node;
        int directionFlags;
        if (fromTail) {
            directionFlags = edge.isDirected() ? 2 : 1;
            node = edge.getHead();
        } else {
            directionFlags = edge.isDirected() ? 4 : 1;
            node = edge.getTail();
        }
        return new EqualsUserNodePredicate(edge.getUserObject(), node, directionFlags);
    }

    public static final TraverserPredicate createEqualsNode(Object node, int directionFlags) {
        return new EqualsNodePredicate(node, directionFlags);
    }

    public static final TraverserPredicate createEqualsUser(Object userObject, int directionFlags) {
        return new EqualsUserPredicate(userObject, directionFlags);
    }

    public static final TraverserPredicate createEquals(Object userObject, Object node, int directionFlags) {
        return new EqualsUserNodePredicate(userObject, node, directionFlags);
    }

    public static final TraverserPredicate createPredicated(Predicate userObjectPredicate, Predicate nodePredicate, int directionFlags) {
        return new PredicatedUserNodePredicate(userObjectPredicate, nodePredicate, directionFlags);
    }

    static Object escapePredicate(Object object) {
        return object instanceof Predicate ? new EqualPredicate(object) : object;
    }

    private static final class PredicatedUserNodePredicate
    extends AbstractTraverserPredicate {
        private static final long serialVersionUID = 1L;
        private Predicate userObjectPredicate;
        private Predicate nodePredicate;

        PredicatedUserNodePredicate(Predicate userObjectPredicate, Predicate nodePredicate, int directionFlags) {
            super(directionFlags);
            this.userObjectPredicate = userObjectPredicate;
            this.nodePredicate = nodePredicate;
            if (userObjectPredicate == null) {
                throw new NullPointerException("User object Predicate is null.");
            }
            if (nodePredicate == null) {
                throw new NullPointerException("Node Predicate is null.");
            }
        }

        private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
            in.defaultReadObject();
            if (this.userObjectPredicate == null) {
                throw new InvalidObjectException("User object Predicate is null.");
            }
            if (this.nodePredicate == null) {
                throw new InvalidObjectException("Node Predicate is null.");
            }
        }

        public Object getUserObjectSpecification() {
            return this.userObjectPredicate;
        }

        public Object getNodeSpecification() {
            return this.nodePredicate;
        }

        boolean evaluate(Object targetUserObject, Object targetNode) {
            return this.userObjectPredicate.evaluate(targetUserObject) && this.nodePredicate.evaluate(targetNode);
        }
    }

    private static final class EqualsUserNodePredicate
    extends AbstractTraverserPredicate {
        private static final long serialVersionUID = 1L;
        private Object userObject;
        private Object node;

        EqualsUserNodePredicate(Object userObject, Object node, int directionFlags) {
            super(directionFlags);
            this.userObject = userObject;
            this.node = node;
        }

        public Object getNodeSpecification() {
            return TraverserPredicateFactory.escapePredicate(this.node);
        }

        public Object getUserObjectSpecification() {
            return TraverserPredicateFactory.escapePredicate(this.userObject);
        }

        boolean evaluate(Object targetUserObject, Object targetNode) {
            return GraphUtils.equals(this.userObject, targetUserObject) && GraphUtils.equals(this.node, targetNode);
        }
    }

    private static final class EqualsUserPredicate
    extends AbstractTraverserPredicate {
        private static final long serialVersionUID = 1L;
        private Object userObject;

        EqualsUserPredicate(Object userObject, int directionFlags) {
            super(directionFlags);
            this.userObject = userObject;
        }

        public Object getUserObjectSpecification() {
            return TraverserPredicateFactory.escapePredicate(this.userObject);
        }

        boolean evaluate(Object targetUserObject, Object targetNode) {
            return GraphUtils.equals(this.userObject, targetUserObject);
        }
    }

    private static final class EqualsNodePredicate
    extends AbstractTraverserPredicate {
        private static final long serialVersionUID = 1L;
        private Object node;

        EqualsNodePredicate(Object node, int directionFlags) {
            super(directionFlags);
            this.node = node;
        }

        public Object getNodeSpecification() {
            return TraverserPredicateFactory.escapePredicate(this.node);
        }

        boolean evaluate(Object targetUserObject, Object targetNode) {
            return GraphUtils.equals(this.node, targetNode);
        }
    }

    private static abstract class AbstractTraverserPredicate
    implements TraverserPredicate,
    Serializable {
        private static final long serialVersionUID = 1L;
        int directionFlags;

        AbstractTraverserPredicate(int directionFlags) {
            this.directionFlags = directionFlags & 7;
            if (this.directionFlags == 0) {
                throw new IllegalArgumentException("Direction flags are invalid: " + directionFlags);
            }
        }

        private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
            in.defaultReadObject();
            if ((this.directionFlags & 7) == 0) {
                throw new InvalidObjectException("No direction flags set: " + this.directionFlags);
            }
            if ((this.directionFlags & 7) != this.directionFlags) {
                throw new InvalidObjectException("Direction flags not valid: " + this.directionFlags);
            }
        }

        public Object getNodeSpecification() {
            return TruePredicate.INSTANCE;
        }

        public Object getUserObjectSpecification() {
            return TruePredicate.INSTANCE;
        }

        public int getDirectionFlags() {
            return this.directionFlags;
        }

        abstract boolean evaluate(Object var1, Object var2);

        public boolean evaluate(Object object) {
            List list = (List)object;
            Object baseNode = list.get(0);
            Graph.Edge edge = (Graph.Edge)list.get(1);
            if (edge.isDirected() ? !((this.directionFlags & 2) != 0 && GraphUtils.equals(baseNode, edge.getTail()) || (this.directionFlags & 4) != 0 && GraphUtils.equals(baseNode, edge.getHead())) : (this.directionFlags & 1) == 0) {
                return false;
            }
            return this.evaluate(edge.getUserObject(), edge.getOtherEndpoint(baseNode));
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!this.getClass().equals(object.getClass())) {
                return false;
            }
            TraverserPredicate pred = (TraverserPredicate)object;
            return this.getDirectionFlags() == pred.getDirectionFlags() && this.getUserObjectSpecification().equals(pred.getUserObjectSpecification()) && this.getNodeSpecification().equals(pred.getNodeSpecification());
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.getUserObjectSpecification().hashCode();
            result = 37 * result + this.getNodeSpecification().hashCode();
            result = 37 * result + this.getDirectionFlags();
            return result;
        }
    }
}

