/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.plexus.util;

import com.phoenixst.plexus.Graph;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SingletonEdgeIterator
implements Iterator {
    private Graph graph;
    private Graph.Edge edge;
    private boolean hasNext;

    public SingletonEdgeIterator(Graph.Edge edge) {
        this(null, edge);
    }

    public SingletonEdgeIterator(Graph graph, Graph.Edge edge) {
        this.graph = graph;
        this.edge = edge;
        this.hasNext = true;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public Object next() {
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        this.hasNext = false;
        return this.edge;
    }

    public void remove() {
        if (this.graph == null) {
            throw new UnsupportedOperationException();
        }
        if (this.hasNext || this.edge == null) {
            throw new IllegalStateException();
        }
        this.graph.removeEdge(this.edge);
        this.edge = null;
    }
}

