/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.plexus.util;

import com.phoenixst.plexus.Graph;
import com.phoenixst.plexus.Traverser;
import java.util.NoSuchElementException;

public class SingletonTraverser
implements Traverser {
    private Graph graph;
    private Object endpoint;
    private Graph.Edge edge;
    private boolean hasNext;
    private boolean hasEndpoint;

    public SingletonTraverser(Object endpoint, Graph.Edge edge) {
        this(null, endpoint, edge);
    }

    public SingletonTraverser(Graph graph, Object endpoint, Graph.Edge edge) {
        this.graph = graph;
        this.endpoint = endpoint;
        this.edge = edge;
        this.hasNext = true;
        this.hasEndpoint = true;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public Object next() {
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        this.hasNext = false;
        return this.endpoint;
    }

    public void remove() {
        if (this.graph == null) {
            throw new UnsupportedOperationException();
        }
        if (this.hasNext || !this.hasEndpoint) {
            throw new IllegalStateException();
        }
        this.graph.removeNode(this.endpoint);
        this.hasEndpoint = false;
    }

    public Graph.Edge getEdge() {
        if (this.hasNext || !this.hasEndpoint) {
            throw new IllegalStateException();
        }
        return this.edge;
    }

    public void removeEdge() {
        if (this.graph == null) {
            throw new UnsupportedOperationException();
        }
        if (this.hasNext || this.edge == null || !this.hasEndpoint) {
            throw new IllegalStateException();
        }
        this.graph.removeEdge(this.edge);
        this.edge = null;
    }
}

