/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.plexus.util;

import com.phoenixst.collections.SynchronizedCollection;
import com.phoenixst.plexus.Graph;
import com.phoenixst.plexus.GraphListener;
import com.phoenixst.plexus.GraphWrapper;
import java.util.Collection;
import org.apache.commons.collections.Predicate;

public class SynchronizedGraphWrapper
extends GraphWrapper {
    private static final long serialVersionUID = 1L;
    private Object mutex;

    public SynchronizedGraphWrapper(Graph g) {
        super(g);
        this.mutex = this;
    }

    public SynchronizedGraphWrapper(Graph g, Object mutex) {
        super(g);
        this.mutex = mutex;
    }

    protected GraphWrapper.EdgeWrapper createEdge(Graph.Edge edge) {
        return new SynchronizedEdgeWrapper(this, edge, this.mutex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addNode(Object node) {
        Object object = this.mutex;
        synchronized (object) {
            return super.addNode(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeNode(Object node) {
        Object object = this.mutex;
        synchronized (object) {
            return super.removeNode(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsNode(Object node) {
        Object object = this.mutex;
        synchronized (object) {
            return super.containsNode(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Graph.Edge addEdge(Object object, Object tail, Object head, boolean isDirected) {
        Object object2 = this.mutex;
        synchronized (object2) {
            return super.addEdge(object, tail, head, isDirected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeEdge(Graph.Edge edge) {
        Object object = this.mutex;
        synchronized (object) {
            return super.removeEdge(edge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsEdge(Graph.Edge edge) {
        Object object = this.mutex;
        synchronized (object) {
            return super.containsEdge(edge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int degree(Object node) {
        Object object = this.mutex;
        synchronized (object) {
            return super.degree(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int degree(Object node, Predicate traverserPredicate) {
        Object object = this.mutex;
        synchronized (object) {
            return super.degree(node, traverserPredicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNode(Predicate nodePredicate) {
        Object object = this.mutex;
        synchronized (object) {
            return super.getNode(nodePredicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Graph.Edge getEdge(Predicate edgePredicate) {
        Object object = this.mutex;
        synchronized (object) {
            return super.getEdge(edgePredicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAdjacentNode(Object node, Predicate traverserPredicate) {
        Object object = this.mutex;
        synchronized (object) {
            return super.getAdjacentNode(node, traverserPredicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Graph.Edge getIncidentEdge(Object node, Predicate traverserPredicate) {
        Object object = this.mutex;
        synchronized (object) {
            return super.getIncidentEdge(node, traverserPredicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection nodes(Predicate nodePredicate) {
        Object object = this.mutex;
        synchronized (object) {
            return new SynchronizedCollection(super.nodes(nodePredicate), this.mutex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection edges(Predicate edgePredicate) {
        Object object = this.mutex;
        synchronized (object) {
            return new SynchronizedCollection(super.edges(edgePredicate), this.mutex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection adjacentNodes(Object node, Predicate traverserPredicate) {
        Object object = this.mutex;
        synchronized (object) {
            return new SynchronizedCollection(super.adjacentNodes(node, traverserPredicate), this.mutex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection incidentEdges(Object node, Predicate traverserPredicate) {
        Object object = this.mutex;
        synchronized (object) {
            return new SynchronizedCollection(super.incidentEdges(node, traverserPredicate), this.mutex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGraphListener(GraphListener listener) {
        Object object = this.mutex;
        synchronized (object) {
            super.addGraphListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGraphListener(GraphListener listener) {
        Object object = this.mutex;
        synchronized (object) {
            super.removeGraphListener(listener);
        }
    }

    private static class SynchronizedEdgeWrapper
    extends GraphWrapper.EdgeWrapper {
        private static final long serialVersionUID = 1L;
        private Object mutex;

        private SynchronizedEdgeWrapper(SynchronizedGraphWrapper graphWrapper, Graph.Edge edge, Object mutex) {
            super(graphWrapper, edge);
            this.mutex = mutex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDirected() {
            Object object = this.mutex;
            synchronized (object) {
                return super.isDirected();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getUserObject() {
            Object object = this.mutex;
            synchronized (object) {
                return super.getUserObject();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setUserObject(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                super.setUserObject(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getTail() {
            Object object = this.mutex;
            synchronized (object) {
                return super.getTail();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getHead() {
            Object object = this.mutex;
            synchronized (object) {
                return super.getHead();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getOtherEndpoint(Object node) {
            Object object = this.mutex;
            synchronized (object) {
                return super.getOtherEndpoint(node);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return super.equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(GraphWrapper.EdgeWrapper edgeWrapper) {
            Object object = this.mutex;
            synchronized (object) {
                return super.equals(edgeWrapper);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return super.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return super.toString();
            }
        }
    }
}

