/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MainWindow;
import org.mars_sim.msp.ui.swing.tool.guide.GuideWindow;

public class MainWindowMenu
extends JMenuBar
implements ActionListener,
MenuListener {
    private MainWindow mainWindow;
    private JMenuItem newItem;
    private JMenuItem loadItem;
    private JMenuItem saveItem;
    private JMenuItem saveAsItem;
    private JMenuItem exitItem;
    private JCheckBoxMenuItem marsNavigatorItem;
    private JCheckBoxMenuItem searchToolItem;
    private JCheckBoxMenuItem timeToolItem;
    private JCheckBoxMenuItem monitorToolItem;
    private JCheckBoxMenuItem prefsToolItem;
    private JCheckBoxMenuItem missionToolItem;
    private JCheckBoxMenuItem settlementToolItem;
    private JCheckBoxMenuItem scienceToolItem;
    private JCheckBoxMenuItem resupplyToolItem;
    private JMenuItem aboutMspItem;
    private JMenuItem tutorialItem;
    private JMenuItem guideItem;

    public MainWindowMenu(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        JMenu fileMenu = new JMenu("File");
        this.add(fileMenu);
        ImageIcon newicon = new ImageIcon(this.getClass().getResource("/images/New.png"));
        this.newItem = new JMenuItem("New", newicon);
        this.newItem.addActionListener(this);
        this.newItem.setAccelerator(KeyStroke.getKeyStroke(78, 128, false));
        this.newItem.setToolTipText("Create new simulation");
        fileMenu.add(this.newItem);
        ImageIcon loadicon = new ImageIcon(this.getClass().getResource("/images/Open.png"));
        this.loadItem = new JMenuItem("Open...", loadicon);
        this.loadItem.addActionListener(this);
        this.loadItem.setAccelerator(KeyStroke.getKeyStroke(79, 128, false));
        this.loadItem.setToolTipText("Open a saved simulation");
        fileMenu.add(this.loadItem);
        fileMenu.add(new JSeparator());
        ImageIcon saveicon = new ImageIcon(this.getClass().getResource("/images/Save.png"));
        this.saveItem = new JMenuItem("Save", saveicon);
        this.saveItem.addActionListener(this);
        this.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 128, false));
        this.saveItem.setToolTipText("Save the current simulation");
        fileMenu.add(this.saveItem);
        ImageIcon saveasicon = new ImageIcon(this.getClass().getResource("/images/SaveAs.png"));
        this.saveAsItem = new JMenuItem("Save As...", saveasicon);
        this.saveAsItem.addActionListener(this);
        this.saveAsItem.setAccelerator(KeyStroke.getKeyStroke(83, 192, false));
        this.saveAsItem.setToolTipText("Save the current simulation under a new name");
        fileMenu.add(this.saveAsItem);
        fileMenu.add(new JSeparator());
        ImageIcon exiticon = new ImageIcon(this.getClass().getResource("/images/Exit.png"));
        this.exitItem = new JMenuItem("Exit", exiticon);
        this.exitItem.addActionListener(this);
        this.exitItem.setAccelerator(KeyStroke.getKeyStroke(88, 128, false));
        this.exitItem.setToolTipText("Leave Mars Simulation Project");
        fileMenu.add(this.exitItem);
        JMenu toolsMenu = new JMenu("Tools");
        toolsMenu.addMenuListener(this);
        this.add(toolsMenu);
        ImageIcon marsnavigatoricon = new ImageIcon(this.getClass().getResource("/images/Planet.png"));
        this.marsNavigatorItem = new JCheckBoxMenuItem("Mars Navigator", marsnavigatoricon);
        this.marsNavigatorItem.addActionListener(this);
        this.marsNavigatorItem.setAccelerator(KeyStroke.getKeyStroke(112, 0, false));
        toolsMenu.add(this.marsNavigatorItem);
        ImageIcon searchicon = new ImageIcon(this.getClass().getResource("/images/Find.png"));
        this.searchToolItem = new JCheckBoxMenuItem("Search Tool", searchicon);
        this.searchToolItem.addActionListener(this);
        this.searchToolItem.setAccelerator(KeyStroke.getKeyStroke(113, 0, false));
        toolsMenu.add(this.searchToolItem);
        ImageIcon timeicon = new ImageIcon(this.getClass().getResource("/images/Time.png"));
        this.timeToolItem = new JCheckBoxMenuItem("Time Tool", timeicon);
        this.timeToolItem.addActionListener(this);
        this.timeToolItem.setAccelerator(KeyStroke.getKeyStroke(114, 0, false));
        toolsMenu.add(this.timeToolItem);
        ImageIcon monitoricon = new ImageIcon(this.getClass().getResource("/images/Monitor.png"));
        this.monitorToolItem = new JCheckBoxMenuItem("Monitor Tool", monitoricon);
        this.monitorToolItem.addActionListener(this);
        this.monitorToolItem.setAccelerator(KeyStroke.getKeyStroke(115, 0, false));
        toolsMenu.add(this.monitorToolItem);
        ImageIcon prefsicon = new ImageIcon(this.getClass().getResource("/images/Preferences.png"));
        this.prefsToolItem = new JCheckBoxMenuItem("Preferences Tool", prefsicon);
        this.prefsToolItem.addActionListener(this);
        this.prefsToolItem.setAccelerator(KeyStroke.getKeyStroke(116, 0, false));
        toolsMenu.add(this.prefsToolItem);
        ImageIcon missionicon = new ImageIcon(this.getClass().getResource("/images/Mission.png"));
        this.missionToolItem = new JCheckBoxMenuItem("Mission Tool", missionicon);
        this.missionToolItem.addActionListener(this);
        this.missionToolItem.setAccelerator(KeyStroke.getKeyStroke(117, 0, false));
        toolsMenu.add(this.missionToolItem);
        ImageIcon settlementtoolicon = new ImageIcon(this.getClass().getResource("/images/SettlementMapTool.png"));
        this.settlementToolItem = new JCheckBoxMenuItem("Settlement Map Tool", settlementtoolicon);
        this.settlementToolItem.addActionListener(this);
        this.settlementToolItem.setAccelerator(KeyStroke.getKeyStroke(118, 0, false));
        toolsMenu.add(this.settlementToolItem);
        ImageIcon scienceicon = new ImageIcon(this.getClass().getResource("/images/Science.png"));
        this.scienceToolItem = new JCheckBoxMenuItem("Science Tool", scienceicon);
        this.scienceToolItem.addActionListener(this);
        this.scienceToolItem.setAccelerator(KeyStroke.getKeyStroke(119, 0, false));
        toolsMenu.add(this.scienceToolItem);
        ImageIcon resupplyicon = new ImageIcon(this.getClass().getResource("/images/Resupply.png"));
        this.resupplyToolItem = new JCheckBoxMenuItem("Resupply Tool", resupplyicon);
        this.resupplyToolItem.addActionListener(this);
        this.resupplyToolItem.setAccelerator(KeyStroke.getKeyStroke(120, 0, false));
        toolsMenu.add(this.resupplyToolItem);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.addMenuListener(this);
        this.add(helpMenu);
        this.aboutMspItem = new JMenuItem("About");
        this.aboutMspItem.addActionListener(this);
        this.aboutMspItem.setToolTipText("Show credits for MSP");
        helpMenu.add(this.aboutMspItem);
        helpMenu.add(new JSeparator());
        this.tutorialItem = new JMenuItem("Tutorial");
        this.tutorialItem.addActionListener(this);
        this.tutorialItem.setAccelerator(KeyStroke.getKeyStroke(84, 128, false));
        this.tutorialItem.setToolTipText("Show the tutorial for beginners");
        helpMenu.add(this.tutorialItem);
        ImageIcon guideicon = new ImageIcon(this.getClass().getResource("/images/Guide.png"));
        this.guideItem = new JMenuItem("User Guide", guideicon);
        this.guideItem.addActionListener(this);
        this.guideItem.setAccelerator(KeyStroke.getKeyStroke(71, 128, false));
        this.guideItem.setToolTipText("Show the User Guide");
        helpMenu.add(this.guideItem);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        GuideWindow ourGuide;
        JMenuItem selectedItem = (JMenuItem)event.getSource();
        if (selectedItem == this.exitItem) {
            this.mainWindow.exitSimulation();
        } else if (selectedItem == this.newItem) {
            this.mainWindow.newSimulation();
        } else if (selectedItem == this.saveItem) {
            this.mainWindow.saveSimulation(true);
        } else if (selectedItem == this.saveAsItem) {
            this.mainWindow.saveSimulation(false);
        } else if (selectedItem == this.loadItem) {
            this.mainWindow.loadSimulation();
        }
        MainDesktopPane desktop = this.mainWindow.getDesktop();
        if (selectedItem == this.marsNavigatorItem) {
            if (this.marsNavigatorItem.isSelected()) {
                desktop.openToolWindow("Mars Navigator");
            } else {
                desktop.closeToolWindow("Mars Navigator");
            }
        }
        if (selectedItem == this.searchToolItem) {
            if (this.searchToolItem.isSelected()) {
                desktop.openToolWindow("Search Tool");
            } else {
                desktop.closeToolWindow("Search Tool");
            }
        }
        if (selectedItem == this.timeToolItem) {
            if (this.timeToolItem.isSelected()) {
                desktop.openToolWindow("Time Tool");
            } else {
                desktop.closeToolWindow("Time Tool");
            }
        }
        if (selectedItem == this.monitorToolItem) {
            if (this.monitorToolItem.isSelected()) {
                desktop.openToolWindow("Monitor Tool");
            } else {
                desktop.closeToolWindow("Monitor Tool");
            }
        }
        if (selectedItem == this.prefsToolItem) {
            if (this.prefsToolItem.isSelected()) {
                desktop.openToolWindow("Preferences Tool");
            } else {
                desktop.closeToolWindow("Preferences Tool");
            }
        }
        if (selectedItem == this.missionToolItem) {
            if (this.missionToolItem.isSelected()) {
                desktop.openToolWindow("Mission Tool");
            } else {
                desktop.closeToolWindow("Mission Tool");
            }
        }
        if (selectedItem == this.settlementToolItem) {
            if (this.settlementToolItem.isSelected()) {
                desktop.openToolWindow("Settlement Map Tool");
            } else {
                desktop.closeToolWindow("Settlement Map Tool");
            }
        }
        if (selectedItem == this.scienceToolItem) {
            if (this.scienceToolItem.isSelected()) {
                desktop.openToolWindow("Science Tool");
            } else {
                desktop.closeToolWindow("Science Tool");
            }
        }
        if (selectedItem == this.resupplyToolItem) {
            if (this.resupplyToolItem.isSelected()) {
                desktop.openToolWindow("Resupply Tool");
            } else {
                desktop.closeToolWindow("Resupply Tool");
            }
        }
        if (selectedItem == this.aboutMspItem) {
            desktop.openToolWindow("Help");
            ourGuide = (GuideWindow)desktop.getToolWindow("Help");
            ourGuide.setURL("/docs/help/about.html");
        }
        if (selectedItem == this.guideItem) {
            desktop.openToolWindow("Help");
            ourGuide = (GuideWindow)desktop.getToolWindow("Help");
            ourGuide.setURL("/docs/help/userguide.html");
        }
        if (selectedItem == this.tutorialItem) {
            desktop.openToolWindow("Help");
            ourGuide = (GuideWindow)desktop.getToolWindow("Help");
            ourGuide.setURL("/docs/help/tutorial1.html");
        }
    }

    @Override
    public void menuSelected(MenuEvent event) {
        MainDesktopPane desktop = this.mainWindow.getDesktop();
        this.marsNavigatorItem.setSelected(desktop.isToolWindowOpen("Mars Navigator"));
        this.searchToolItem.setSelected(desktop.isToolWindowOpen("Search Tool"));
        this.timeToolItem.setSelected(desktop.isToolWindowOpen("Time Tool"));
        this.monitorToolItem.setSelected(desktop.isToolWindowOpen("Monitor Tool"));
        this.prefsToolItem.setSelected(desktop.isToolWindowOpen("Preferences Tool"));
        this.missionToolItem.setSelected(desktop.isToolWindowOpen("Mission Tool"));
        this.settlementToolItem.setSelected(desktop.isToolWindowOpen("Settlement Map Tool"));
        this.scienceToolItem.setSelected(desktop.isToolWindowOpen("Science Tool"));
        this.resupplyToolItem.setSelected(desktop.isToolWindowOpen("Resupply Tool"));
    }

    @Override
    public void menuCanceled(MenuEvent event) {
    }

    @Override
    public void menuDeselected(MenuEvent event) {
    }
}

