/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import javax.swing.table.DefaultTableCellRenderer;

public class NumberCellRenderer
extends DefaultTableCellRenderer {
    private DecimalFormat dec1Formatter = new DecimalFormat("0.0");
    private DecimalFormat dec2Formatter = new DecimalFormat("0.00");
    private DecimalFormat dec3Formatter = new DecimalFormat("0.000");
    private DecimalFormat formatter;

    public NumberCellRenderer() {
        this(1);
    }

    public NumberCellRenderer(int digits) {
        this.formatter = digits == 1 ? this.dec1Formatter : (digits == 2 ? this.dec2Formatter : (digits == 3 ? this.dec3Formatter : this.dec1Formatter));
        this.setHorizontalAlignment(4);
    }

    @Override
    public void setValue(Object value) {
        if (value != null) {
            if (value instanceof Double) {
                value = this.formatter.format((Double)value);
            } else if (value instanceof Float) {
                value = this.formatter.format(((Float)value).floatValue());
            } else if (value instanceof BigDecimal) {
                value = this.formatter.format(((BigDecimal)value).doubleValue());
            }
        }
        super.setValue(value);
    }
}

