/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing;

import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JInternalFrame;
import org.apache.commons.io.IOUtils;
import org.jdom.Content;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MainWindow;
import org.mars_sim.msp.ui.swing.sound.AudioPlayer;
import org.mars_sim.msp.ui.swing.tool.ToolWindow;
import org.mars_sim.msp.ui.swing.unit_window.UnitWindow;

public class UIConfig {
    private static String CLASS_NAME = "org.mars_sim.msp.ui.standard.UIConfig";
    private static Logger logger = Logger.getLogger(CLASS_NAME);
    public static final UIConfig INSTANCE = new UIConfig();
    public static final String TOOL = "tool";
    public static final String UNIT = "unit";
    private static final String DIRECTORY = System.getProperty("user.home") + File.separator + ".mars-sim" + File.separator + "saved";
    private static final String FILE_NAME = "ui_settings.xml";
    private static final String FILE_NAME_DTD = "ui_settings.dtd";
    private static final String UI = "ui";
    private static final String USE_DEFAULT = "use-default";
    private static final String SHOW_UNIT_BAR = "show-unit-bar";
    private static final String SHOW_TOOL_BAR = "show-tool-bar";
    private static final String MAIN_WINDOW = "main-window";
    private static final String LOCATION_X = "location-x";
    private static final String LOCATION_Y = "location-y";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String VOLUME = "volume";
    private static final String SOUND = "sound";
    private static final String MUTE = "mute";
    private static final String INTERNAL_WINDOWS = "internal-windows";
    private static final String WINDOW = "window";
    private static final String TYPE = "type";
    private static final String NAME = "name";
    private static final String DISPLAY = "display";
    private static final String Z_ORDER = "z-order";
    private Document configDoc;

    private UIConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseFile() {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(new File(DIRECTORY, FILE_NAME));
            InputStreamReader reader = new InputStreamReader((InputStream)stream, "UTF-8");
            SAXBuilder saxBuilder = new SAXBuilder(true);
            this.configDoc = saxBuilder.build((Reader)reader);
            IOUtils.closeQuietly((InputStream)stream);
        }
        catch (Exception e) {
            if (!(e instanceof FileNotFoundException)) {
                logger.log(Level.SEVERE, "parseFile()", e);
            }
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile(MainWindow window) {
        FileOutputStream stream = null;
        try {
            Unit[] toolBarUnits;
            JInternalFrame[] windows;
            Document outputDoc = new Document();
            DocType dtd = new DocType(UI, DIRECTORY + File.separator + FILE_NAME_DTD);
            Element uiElement = new Element(UI);
            outputDoc.setDocType(dtd);
            outputDoc.addContent((Content)uiElement);
            outputDoc.setRootElement(uiElement);
            uiElement.setAttribute(USE_DEFAULT, "false");
            uiElement.setAttribute(SHOW_TOOL_BAR, Boolean.toString(window.getToolToolBar().isVisible()));
            uiElement.setAttribute(SHOW_UNIT_BAR, Boolean.toString(window.getUnitToolBar().isVisible()));
            Element mainWindowElement = new Element(MAIN_WINDOW);
            uiElement.addContent((Content)mainWindowElement);
            mainWindowElement.setAttribute(LOCATION_X, Integer.toString(window.getFrame().getX()));
            mainWindowElement.setAttribute(LOCATION_Y, Integer.toString(window.getFrame().getY()));
            mainWindowElement.setAttribute(WIDTH, Integer.toString(window.getFrame().getWidth()));
            mainWindowElement.setAttribute(HEIGHT, Integer.toString(window.getFrame().getHeight()));
            Element volumeElement = new Element(VOLUME);
            uiElement.addContent((Content)volumeElement);
            AudioPlayer player = window.getDesktop().getSoundPlayer();
            volumeElement.setAttribute(SOUND, Float.toString(player.getVolume()));
            volumeElement.setAttribute(MUTE, Boolean.toString(player.isMute()));
            Element internalWindowsElement = new Element(INTERNAL_WINDOWS);
            uiElement.addContent((Content)internalWindowsElement);
            MainDesktopPane desktop = window.getDesktop();
            for (JInternalFrame window1 : windows = desktop.getAllFrames()) {
                Element windowElement = new Element(WINDOW);
                internalWindowsElement.addContent((Content)windowElement);
                windowElement.setAttribute(Z_ORDER, Integer.toString(desktop.getComponentZOrder(window1)));
                windowElement.setAttribute(LOCATION_X, Integer.toString(window1.getX()));
                windowElement.setAttribute(LOCATION_Y, Integer.toString(window1.getY()));
                windowElement.setAttribute(WIDTH, Integer.toString(window1.getWidth()));
                windowElement.setAttribute(HEIGHT, Integer.toString(window1.getHeight()));
                windowElement.setAttribute(DISPLAY, Boolean.toString(!window1.isClosed()));
                if (window1 instanceof ToolWindow) {
                    windowElement.setAttribute(TYPE, TOOL);
                    windowElement.setAttribute(NAME, ((ToolWindow)window1).getToolName());
                    continue;
                }
                if (window1 instanceof UnitWindow) {
                    windowElement.setAttribute(TYPE, UNIT);
                    windowElement.setAttribute(NAME, ((UnitWindow)window1).getUnit().getName());
                    continue;
                }
                windowElement.setAttribute(TYPE, "other");
                windowElement.setAttribute(NAME, "other");
            }
            for (Unit toolBarUnit : toolBarUnits = window.getUnitToolBar().getUnitsInToolBar()) {
                UnitWindow unitWindow = desktop.findUnitWindow(toolBarUnit);
                if (unitWindow != null && !unitWindow.isIcon()) continue;
                Element windowElement = new Element(WINDOW);
                internalWindowsElement.addContent((Content)windowElement);
                windowElement.setAttribute(TYPE, UNIT);
                windowElement.setAttribute(NAME, toolBarUnit.getName());
                windowElement.setAttribute(DISPLAY, "false");
            }
            File configFile = new File(DIRECTORY, FILE_NAME);
            if (!configFile.getParentFile().exists()) {
                configFile.getParentFile().mkdirs();
            }
            InputStream in = this.getClass().getResourceAsStream("/dtd/ui_settings.dtd");
            IOUtils.copy((InputStream)in, (OutputStream)new FileOutputStream(new File(DIRECTORY, FILE_NAME_DTD)));
            XMLOutputter fmt = new XMLOutputter();
            fmt.setFormat(Format.getPrettyFormat());
            stream = new FileOutputStream(configFile);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, "UTF-8");
            fmt.output(outputDoc, (Writer)writer);
            IOUtils.closeQuietly((OutputStream)stream);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage());
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
    }

    public boolean useUIDefault() {
        try {
            Element root = this.configDoc.getRootElement();
            return Boolean.parseBoolean(root.getAttributeValue(USE_DEFAULT));
        }
        catch (Exception e) {
            return true;
        }
    }

    public boolean showToolBar() {
        try {
            Element root = this.configDoc.getRootElement();
            return Boolean.parseBoolean(root.getAttributeValue(SHOW_TOOL_BAR));
        }
        catch (Exception e) {
            return true;
        }
    }

    public boolean showUnitBar() {
        try {
            Element root = this.configDoc.getRootElement();
            return Boolean.parseBoolean(root.getAttributeValue(SHOW_UNIT_BAR));
        }
        catch (Exception e) {
            return true;
        }
    }

    public Point getMainWindowLocation() {
        try {
            Element root = this.configDoc.getRootElement();
            Element mainWindow = root.getChild(MAIN_WINDOW);
            int x = Integer.parseInt(mainWindow.getAttributeValue(LOCATION_X));
            int y = Integer.parseInt(mainWindow.getAttributeValue(LOCATION_Y));
            return new Point(x, y);
        }
        catch (Exception e) {
            return new Point(0, 0);
        }
    }

    public Dimension getMainWindowDimension() {
        try {
            Element root = this.configDoc.getRootElement();
            Element mainWindow = root.getChild(MAIN_WINDOW);
            int width = Integer.parseInt(mainWindow.getAttributeValue(WIDTH));
            int height = Integer.parseInt(mainWindow.getAttributeValue(HEIGHT));
            return new Dimension(width, height);
        }
        catch (Exception e) {
            return new Dimension(300, 300);
        }
    }

    public float getVolume() {
        try {
            Element root = this.configDoc.getRootElement();
            Element volume = root.getChild(VOLUME);
            return Float.parseFloat(volume.getAttributeValue(SOUND));
        }
        catch (Exception e) {
            return 50.0f;
        }
    }

    public boolean isMute() {
        try {
            Element root = this.configDoc.getRootElement();
            Element volume = root.getChild(VOLUME);
            return Boolean.parseBoolean(volume.getAttributeValue(MUTE));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isInternalWindowDisplayed(String windowName) {
        try {
            Element root = this.configDoc.getRootElement();
            Element internalWindows = root.getChild(INTERNAL_WINDOWS);
            List internalWindowNodes = internalWindows.getChildren();
            boolean result = false;
            for (Object element : internalWindowNodes) {
                Element internalWindow;
                String name;
                if (!(element instanceof Element) || !(name = (internalWindow = (Element)element).getAttributeValue(NAME)).equals(windowName)) continue;
                result = Boolean.parseBoolean(internalWindow.getAttributeValue(DISPLAY));
                break;
            }
            return result;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Point getInternalWindowLocation(String windowName) {
        try {
            Element root = this.configDoc.getRootElement();
            Element internalWindows = root.getChild(INTERNAL_WINDOWS);
            List internalWindowNodes = internalWindows.getChildren();
            Point result = new Point(0, 0);
            for (Object element : internalWindowNodes) {
                Element internalWindow;
                String name;
                if (!(element instanceof Element) || !(name = (internalWindow = (Element)element).getAttributeValue(NAME)).equals(windowName)) continue;
                int locationX = Integer.parseInt(internalWindow.getAttributeValue(LOCATION_X));
                int locationY = Integer.parseInt(internalWindow.getAttributeValue(LOCATION_Y));
                result.setLocation(locationX, locationY);
            }
            return result;
        }
        catch (Exception e) {
            return new Point(0, 0);
        }
    }

    public int getInternalWindowZOrder(String windowName) {
        try {
            Element root = this.configDoc.getRootElement();
            Element internalWindows = root.getChild(INTERNAL_WINDOWS);
            List internalWindowNodes = internalWindows.getChildren();
            int result = -1;
            for (Object element : internalWindowNodes) {
                Element internalWindow;
                String name;
                if (!(element instanceof Element) || !(name = (internalWindow = (Element)element).getAttributeValue(NAME)).equals(windowName)) continue;
                result = Integer.parseInt(internalWindow.getAttributeValue(Z_ORDER));
            }
            return result;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public Dimension getInternalWindowDimension(String windowName) {
        try {
            Element root = this.configDoc.getRootElement();
            Element internalWindows = root.getChild(INTERNAL_WINDOWS);
            List internalWindowNodes = internalWindows.getChildren();
            Dimension result = new Dimension(0, 0);
            for (Object element : internalWindowNodes) {
                Element internalWindow;
                String name;
                if (!(element instanceof Element) || !(name = (internalWindow = (Element)element).getAttributeValue(NAME)).equals(windowName)) continue;
                int width = Integer.parseInt(internalWindow.getAttributeValue(WIDTH));
                int height = Integer.parseInt(internalWindow.getAttributeValue(HEIGHT));
                result = new Dimension(width, height);
            }
            return result;
        }
        catch (Exception e) {
            return new Dimension(0, 0);
        }
    }

    public String getInternalWindowType(String windowName) {
        try {
            Element root = this.configDoc.getRootElement();
            Element internalWindows = root.getChild(INTERNAL_WINDOWS);
            List internalWindowNodes = internalWindows.getChildren();
            String result = "";
            for (Object element : internalWindowNodes) {
                Element internalWindow;
                String name;
                if (!(element instanceof Element) || !(name = (internalWindow = (Element)element).getAttributeValue(NAME)).equals(windowName)) continue;
                result = internalWindow.getAttributeValue(TYPE);
            }
            return result;
        }
        catch (Exception e) {
            return "";
        }
    }

    public boolean isInternalWindowConfigured(String windowName) {
        try {
            Element root = this.configDoc.getRootElement();
            Element internalWindows = root.getChild(INTERNAL_WINDOWS);
            List internalWindowNodes = internalWindows.getChildren();
            boolean result = false;
            for (Object element : internalWindowNodes) {
                Element internalWindow;
                String name;
                if (!(element instanceof Element) || !(name = (internalWindow = (Element)element).getAttributeValue(NAME)).equals(windowName)) continue;
                result = true;
            }
            return result;
        }
        catch (Exception e) {
            return false;
        }
    }

    public List<String> getInternalWindowNames() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Element root = this.configDoc.getRootElement();
            Element internalWindows = root.getChild(INTERNAL_WINDOWS);
            List internalWindowNodes = internalWindows.getChildren();
            for (Object element : internalWindowNodes) {
                if (!(element instanceof Element)) continue;
                Element internalWindow = (Element)element;
                result.add(internalWindow.getAttributeValue(NAME));
            }
            return result;
        }
        catch (Exception e) {
            return result;
        }
    }
}

