/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.guide;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.mars_sim.msp.ui.swing.HTMLContentPane;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.ToolWindow;

public class GuideWindow
extends ToolWindow
implements ActionListener,
HyperlinkListener,
ComponentListener {
    public static final String NAME = "Help";
    private JViewport viewPort;
    private HTMLContentPane htmlPane;
    private URL guideURL;
    private JButton homeButton = new JButton("Home");
    private JButton backButton = new JButton("Back");
    private JButton forwardButton = new JButton("Forward");

    public GuideWindow(MainDesktopPane desktop) {
        super(NAME, desktop);
        this.guideURL = this.getClass().getResource("/docs/help/userguide.html");
        JPanel mainPane = new JPanel(new BorderLayout());
        mainPane.setBorder(new MarsPanelBorder());
        this.setContentPane(mainPane);
        this.homeButton.setActionCommand("home");
        this.homeButton.setToolTipText("Go to Home");
        this.homeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuideWindow.this.htmlPane.goToURL(GuideWindow.this.guideURL);
                GuideWindow.this.updateButtons();
            }
        });
        this.backButton.setActionCommand("back");
        this.backButton.setToolTipText("Back");
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuideWindow.this.htmlPane.back();
                GuideWindow.this.updateButtons();
            }
        });
        this.forwardButton.setActionCommand("forward");
        this.forwardButton.setToolTipText("Forward");
        this.forwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuideWindow.this.htmlPane.forward();
                GuideWindow.this.updateButtons();
            }
        });
        JPanel toolPanel = new JPanel();
        toolPanel.add(this.homeButton);
        toolPanel.add(this.backButton);
        toolPanel.add(this.forwardButton);
        this.htmlPane = new HTMLContentPane();
        this.htmlPane.addHyperlinkListener(this);
        this.htmlPane.goToURL(this.guideURL);
        this.htmlPane.setBackground(Color.lightGray);
        this.htmlPane.setBorder(new EmptyBorder(2, 2, 2, 2));
        JScrollPane scrollPane = new JScrollPane(this.htmlPane);
        scrollPane.setBorder(new MarsPanelBorder());
        this.viewPort = scrollPane.getViewport();
        this.viewPort.addComponentListener(this);
        this.viewPort.setScrollMode(2);
        mainPane.add(scrollPane);
        mainPane.add((Component)toolPanel, "North");
        this.setSize(new Dimension(575, 475));
        this.setResizable(true);
        this.setMaximizable(true);
        this.updateButtons();
        this.setVisible(true);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.htmlPane.goToURL(event.getURL());
            this.updateButtons();
        }
    }

    public void updateButtons() {
        this.homeButton.setEnabled(true);
        this.backButton.setEnabled(!this.htmlPane.isFirst());
        this.forwardButton.setEnabled(!this.htmlPane.isLast());
    }

    public void setURL(String fileloc) {
        this.htmlPane.goToURL(this.getClass().getResource(fileloc));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.dispose();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.viewPort.setViewPosition(new Point(0, 0));
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void destroy() {
    }
}

