/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.map;

import java.awt.Image;
import java.awt.MediaTracker;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.mapdata.MapData;
import org.mars_sim.msp.ui.swing.tool.map.Map;

public abstract class CannedMarsMap
implements Map {
    private static Logger logger = Logger.getLogger(CannedMarsMap.class.getName());
    private MapData mapData;
    private JComponent displayArea = null;
    private Coordinates currentCenter = null;
    private Image mapImage = null;
    private boolean mapImageDone = false;

    public CannedMarsMap(JComponent displayArea, MapData mapData) {
        this.mapData = mapData;
        this.displayArea = displayArea;
    }

    private Image createMapImage(Coordinates center) {
        return this.mapData.getMapImage(center.getPhi(), center.getTheta());
    }

    @Override
    public void drawMap(Coordinates newCenter) {
        if (newCenter != null && !newCenter.equals((Object)this.currentCenter)) {
            this.mapImage = this.createMapImage(newCenter);
            MediaTracker mt = new MediaTracker(this.displayArea);
            mt.addImage(this.mapImage, 0);
            try {
                mt.waitForID(0);
            }
            catch (InterruptedException e) {
                logger.log(Level.SEVERE, "MediaTracker interrupted " + e);
            }
            this.mapImageDone = true;
            this.currentCenter = new Coordinates(newCenter);
        }
    }

    @Override
    public boolean isImageDone() {
        return this.mapImageDone;
    }

    @Override
    public Image getMapImage() {
        return this.mapImage;
    }
}

