/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.map;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.IntPoint;
import org.mars_sim.msp.ui.swing.tool.map.MapLayer;

public class EllipseLayer
implements MapLayer {
    private Color drawColor;
    private boolean displayEllipse;
    private IntPoint foci1;
    private IntPoint foci2;
    private int range;

    public EllipseLayer(Color drawColor) {
        this.drawColor = drawColor;
    }

    public void setDisplayEllipse(boolean displayEllipse) {
        this.displayEllipse = displayEllipse;
    }

    public void setEllipseDetails(IntPoint foci1, IntPoint foci2, int range) {
        this.foci1 = foci1;
        this.foci2 = foci2;
        this.range = range;
    }

    @Override
    public void displayLayer(Coordinates mapCenter, String mapType, Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.displayEllipse) {
            g2d.setColor(this.drawColor);
            IntPoint center = this.getCenterPoint();
            int width = this.getWidth();
            int height = this.getHeight();
            int startX = center.getiX() - width / 2;
            int startY = center.getiY() - height / 2;
            AffineTransform rat = new AffineTransform();
            rat.setToRotation(this.getFociAngle(), center.getX(), center.getY());
            g2d.transform(rat);
            Ellipse2D.Double ellipse = new Ellipse2D.Double(startX, startY, width, height);
            g2d.draw(ellipse);
            rat.setToRotation(-1.0 * this.getFociAngle(), center.getX(), center.getY());
            g2d.transform(rat);
        }
    }

    private int getWidth() {
        return this.getFociDistance() + this.range;
    }

    private int getHeight() {
        double a = (double)this.getFociDistance() / 2.0;
        double h = (double)(this.getFociDistance() + this.range) / 2.0;
        return (int)Math.round(Math.sqrt(Math.abs(Math.pow(h, 2.0) - Math.pow(a, 2.0)))) * 2;
    }

    private int getFociDistance() {
        int xDiff = this.foci2.getiX() - this.foci1.getiX();
        int yDiff = this.foci2.getiY() - this.foci1.getiY();
        return (int)Math.round(Math.sqrt(Math.pow(xDiff, 2.0) + Math.pow(yDiff, 2.0)));
    }

    private IntPoint getCenterPoint() {
        int xCenter = (int)Math.round((double)(this.foci1.getiX() + this.foci2.getiX()) / 2.0);
        int yCenter = (int)Math.round((double)(this.foci1.getiY() + this.foci2.getiY()) / 2.0);
        return new IntPoint(xCenter, yCenter);
    }

    private double getFociAngle() {
        int xDiff = this.foci2.getiX() - this.foci1.getiX();
        int yDiff = this.foci2.getiY() - this.foci1.getiY();
        return Math.atan2(yDiff, xDiff);
    }
}

