/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.map;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.ui.swing.tool.map.Map;
import org.mars_sim.msp.ui.swing.tool.map.MapLayer;
import org.mars_sim.msp.ui.swing.tool.map.SurfMarsMap;
import org.mars_sim.msp.ui.swing.tool.map.TopoMarsMap;
import org.mars_sim.msp.ui.swing.tool.map.USGSMarsMap;

public class MapPanel
extends JPanel
implements Runnable {
    private static String CLASS_NAME = "org.mars_sim.msp.ui.standard.tool.map.MapPanel";
    private static Logger logger = Logger.getLogger(CLASS_NAME);
    private Map map;
    private Thread displayThread;
    private Thread createMapThread;
    private Coordinates centerCoords;
    private boolean mapError;
    private String mapErrorMessage;
    private Image mapImage;
    private boolean wait;
    private String mapType;
    private List<MapLayer> mapLayers;
    private String oldMapType;
    private SurfMarsMap surfMap;
    private TopoMarsMap topoMap;
    private USGSMarsMap usgsMap;
    private boolean update;

    public MapPanel() {
        this.oldMapType = this.mapType = "surface map";
        this.topoMap = new TopoMarsMap(this);
        this.usgsMap = new USGSMarsMap(this);
        this.surfMap = new SurfMarsMap(this);
        this.map = this.surfMap;
        this.mapError = false;
        this.wait = false;
        this.mapLayers = new ArrayList<MapLayer>();
        this.update = true;
        this.setPreferredSize(new Dimension(300, 300));
        this.setBackground(Color.BLACK);
    }

    public void addMapLayer(MapLayer newLayer) {
        if (newLayer != null) {
            if (!this.mapLayers.contains(newLayer)) {
                this.mapLayers.add(newLayer);
            }
        } else {
            throw new IllegalArgumentException("newLayer is null");
        }
    }

    public void removeMapLayer(MapLayer oldLayer) {
        if (oldLayer != null) {
            if (this.mapLayers.contains(oldLayer)) {
                this.mapLayers.remove(oldLayer);
            }
        } else {
            throw new IllegalArgumentException("oldLayer is null");
        }
    }

    public boolean hasMapLayer(MapLayer layer) {
        return this.mapLayers.contains(layer);
    }

    public String getMapType() {
        return this.mapType;
    }

    public void setMapType(String mapType) {
        this.mapType = mapType;
        if ("surface map".equals(mapType)) {
            this.map = this.surfMap;
        } else if ("topographical map".equals(mapType)) {
            this.map = this.topoMap;
        } else if ("USGS map".equals(mapType)) {
            this.map = this.usgsMap;
        }
        this.showMap(this.centerCoords);
    }

    public Coordinates getCenterLocation() {
        return this.centerCoords;
    }

    public void showMap(Coordinates newCenter) {
        boolean recreateMap = false;
        if (this.centerCoords == null) {
            if (newCenter != null) {
                recreateMap = true;
                this.centerCoords = new Coordinates(newCenter);
            }
        } else if (!this.centerCoords.equals((Object)newCenter)) {
            if (newCenter != null) {
                recreateMap = true;
                this.centerCoords.setCoords(newCenter);
            } else {
                this.centerCoords = null;
            }
        }
        if (!this.mapType.equals(this.oldMapType)) {
            recreateMap = true;
            this.oldMapType = this.mapType;
        }
        if (recreateMap) {
            this.wait = true;
            if (this.createMapThread != null && this.createMapThread.isAlive()) {
                this.createMapThread.interrupt();
            }
            this.createMapThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        MapPanel.this.mapError = false;
                        MapPanel.this.map.drawMap(MapPanel.this.centerCoords);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                        MapPanel.this.mapError = true;
                        MapPanel.this.mapErrorMessage = e.getMessage();
                    }
                    MapPanel.this.wait = false;
                    MapPanel.this.repaint();
                }
            });
            this.createMapThread.start();
        }
        this.updateDisplay();
    }

    private void updateDisplay() {
        if (this.displayThread == null || !this.displayThread.isAlive()) {
            this.displayThread = new Thread((Runnable)this, "Navpoint Map");
            this.displayThread.start();
        } else {
            this.displayThread.interrupt();
        }
    }

    @Override
    public void run() {
        while (this.update) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.wait) {
            if (this.mapImage != null) {
                g.drawImage(this.mapImage, 0, 0, this);
            }
            String message = "Generating Map";
            this.drawCenteredMessage(message, g);
        } else if (this.mapError) {
            logger.log(Level.SEVERE, "mapError: " + this.mapErrorMessage);
            if (this.mapImage != null) {
                g.drawImage(this.mapImage, 0, 0, this);
            }
            if (this.mapErrorMessage == null) {
                this.mapErrorMessage = "Null Map";
            }
            this.drawCenteredMessage(this.mapErrorMessage, g);
        } else {
            g.setColor(Color.black);
            g.fillRect(0, 0, 300, 300);
            if (this.centerCoords != null) {
                if (this.map.isImageDone()) {
                    this.mapImage = this.map.getMapImage();
                    g.drawImage(this.mapImage, 0, 0, this);
                }
                Iterator<MapLayer> i = this.mapLayers.iterator();
                while (i.hasNext()) {
                    i.next().displayLayer(this.centerCoords, this.mapType, g);
                }
            }
        }
    }

    private void drawCenteredMessage(String message, Graphics g) {
        g.setColor(Color.green);
        Font messageFont = new Font("SansSerif", 1, 25);
        g.setFont(messageFont);
        FontMetrics messageMetrics = this.getFontMetrics(messageFont);
        int msgHeight = messageMetrics.getHeight();
        int msgWidth = messageMetrics.stringWidth(message);
        int x = (300 - msgWidth) / 2;
        int y = (300 + msgHeight) / 2;
        g.drawString(message, x, y);
    }

    public void destroy() {
        this.map = null;
        this.surfMap = null;
        this.topoMap = null;
        this.usgsMap = null;
        this.update = false;
    }
}

