/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.map;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.IntPoint;
import org.mars_sim.msp.ui.swing.ImageLoader;
import org.mars_sim.msp.ui.swing.tool.map.MapLayer;

public class NavpointEditLayer
implements MapLayer {
    private static final String BLUE_ICON_NAME = "FlagBlue";
    private static final String GREEN_ICON_NAME = "FlagGreen";
    private List<IntPoint> navpointPositions;
    private int selectedNavpoint;
    private Component displayComponent;
    private Icon navpointIconColor;
    private Icon navpointIconSelected;
    private boolean drawNavNumbers;

    public NavpointEditLayer(Component displayComponent, boolean drawNavNumbers) {
        this.displayComponent = displayComponent;
        this.navpointPositions = new ArrayList<IntPoint>();
        this.navpointIconColor = ImageLoader.getIcon(BLUE_ICON_NAME);
        this.navpointIconSelected = ImageLoader.getIcon(GREEN_ICON_NAME);
        this.selectedNavpoint = -1;
        this.drawNavNumbers = drawNavNumbers;
    }

    public void addNavpointPosition(IntPoint newNavpointPosition) {
        this.navpointPositions.add(newNavpointPosition);
    }

    public void clearNavpointPositions() {
        this.navpointPositions.clear();
    }

    public IntPoint getNavpointPosition(int index) {
        if (index > -1 && index < this.navpointPositions.size()) {
            return this.navpointPositions.get(index);
        }
        return null;
    }

    public void setNavpointPosition(int index, IntPoint newNavpointPosition) {
        if (index > -1 && index < this.navpointPositions.size()) {
            this.navpointPositions.set(index, newNavpointPosition);
        }
    }

    public boolean withinDisplayEdges(IntPoint newNavpointPosition) {
        boolean withinXBounds = newNavpointPosition.getiX() > -1 && newNavpointPosition.getiX() < 300 - this.navpointIconColor.getIconWidth();
        boolean withinYBounds = newNavpointPosition.getiY() >= this.navpointIconColor.getIconHeight() && newNavpointPosition.getiY() < 300;
        return withinXBounds && withinYBounds;
    }

    public void selectNavpoint(int index) {
        this.selectedNavpoint = index;
    }

    public void clearSelectedNavpoint() {
        this.selectedNavpoint = -1;
    }

    public int overNavIcon(int x, int y) {
        int result = -1;
        for (int z = 0; z < this.navpointPositions.size(); ++z) {
            if (result >= 0) continue;
            IntPoint navpointPosition = this.navpointPositions.get(z);
            int leftBound = navpointPosition.getiX();
            int rightBound = navpointPosition.getiX() + this.navpointIconColor.getIconWidth();
            int topBound = navpointPosition.getiY() - this.navpointIconColor.getIconHeight();
            int bottomBound = navpointPosition.getiY();
            if (x < leftBound || x > rightBound || y < topBound || y > bottomBound) continue;
            result = z;
        }
        return result;
    }

    @Override
    public void displayLayer(Coordinates mapCenter, String mapType, Graphics g) {
        IntPoint currentPosition;
        int x;
        Graphics2D g2d = (Graphics2D)g;
        for (x = 0; x < this.navpointPositions.size(); ++x) {
            g2d.setColor(Color.GREEN);
            currentPosition = this.navpointPositions.get(x);
            if (x == 0 || x == this.navpointPositions.size() - 1) {
                g2d.drawLine(currentPosition.getiX(), currentPosition.getiY(), 150, 150);
            }
            if (x == 0) continue;
            IntPoint prevPosition = this.navpointPositions.get(x - 1);
            g2d.drawLine(currentPosition.getiX(), currentPosition.getiY(), prevPosition.getiX(), prevPosition.getiY());
        }
        for (x = 0; x < this.navpointPositions.size(); ++x) {
            currentPosition = this.navpointPositions.get(x);
            Icon navIcon = null;
            navIcon = this.selectedNavpoint == x ? this.navpointIconSelected : this.navpointIconColor;
            IntPoint drawLocation = new IntPoint(currentPosition.getiX(), currentPosition.getiY() - navIcon.getIconHeight());
            navIcon.paintIcon(this.displayComponent, g2d, drawLocation.getiX(), drawLocation.getiY());
            if (!this.drawNavNumbers) continue;
            g2d.setColor(Color.WHITE);
            g2d.setFont(new Font("SansSerif", 0, 9));
            g2d.drawString("" + (x + 1), currentPosition.getiX() + 5, currentPosition.getiY() + 5);
        }
    }
}

