/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.map;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.IntPoint;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.MissionManager;
import org.mars_sim.msp.core.person.ai.mission.NavPoint;
import org.mars_sim.msp.core.person.ai.mission.TravelMission;
import org.mars_sim.msp.ui.swing.ImageLoader;
import org.mars_sim.msp.ui.swing.tool.map.MapLayer;
import org.mars_sim.msp.ui.swing.tool.map.MapUtils;

public class NavpointMapLayer
implements MapLayer {
    private static final String BLUE_ICON_NAME = "FlagBlue";
    private static final String WHITE_ICON_NAME = "FlagWhite";
    private static final String GREEN_ICON_NAME = "FlagGreen";
    private Component displayComponent;
    private Icon navpointIconColor;
    private Icon navpointIconWhite;
    private Icon navpointIconSelected;
    private Mission singleMission;
    private NavPoint selectedNavpoint;

    public NavpointMapLayer(Component displayComponent) {
        this.displayComponent = displayComponent;
        this.navpointIconColor = ImageLoader.getIcon(BLUE_ICON_NAME);
        this.navpointIconWhite = ImageLoader.getIcon(WHITE_ICON_NAME);
        this.navpointIconSelected = ImageLoader.getIcon(GREEN_ICON_NAME);
    }

    public void setSingleMission(Mission singleMission) {
        this.singleMission = singleMission;
    }

    public void setSelectedNavpoint(NavPoint selectedNavpoint) {
        this.selectedNavpoint = selectedNavpoint;
    }

    @Override
    public void displayLayer(Coordinates mapCenter, String mapType, Graphics g) {
        if (this.singleMission != null) {
            if (this.singleMission instanceof TravelMission) {
                this.displayMission((TravelMission)this.singleMission, mapCenter, mapType, g);
            }
        } else {
            MissionManager manager = Simulation.instance().getMissionManager();
            for (Mission mission : manager.getMissions()) {
                if (!(mission instanceof TravelMission)) continue;
                this.displayMission((TravelMission)mission, mapCenter, mapType, g);
            }
        }
        if (this.selectedNavpoint != null) {
            this.displayNavpoint(this.selectedNavpoint, mapCenter, mapType, g);
        }
    }

    private void displayMission(TravelMission mission, Coordinates mapCenter, String mapType, Graphics g) {
        for (int x = 0; x < mission.getNumberOfNavpoints(); ++x) {
            NavPoint navpoint = mission.getNavpoint(x);
            this.displayNavpoint(navpoint, mapCenter, mapType, g);
        }
    }

    private void displayNavpoint(NavPoint navpoint, Coordinates mapCenter, String mapType, Graphics g) {
        double angle = 0.0;
        angle = "USGS map".equals(mapType) ? 0.06106 : 0.48587;
        if (mapCenter.getAngle(navpoint.getLocation()) < angle) {
            Icon navIcon = null;
            navIcon = navpoint == this.selectedNavpoint ? this.navpointIconSelected : ("topographical map".equals(mapType) ? this.navpointIconWhite : this.navpointIconColor);
            IntPoint location = MapUtils.getRectPosition(navpoint.getLocation(), mapCenter, mapType);
            IntPoint drawLocation = new IntPoint(location.getiX(), location.getiY() - navIcon.getIconHeight());
            navIcon.paintIcon(this.displayComponent, g, drawLocation.getiX(), drawLocation.getiY());
        }
    }
}

