/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.map;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Timer;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.ui.swing.tool.map.Map;

public class USGSMarsMap
implements Map,
ActionListener {
    private static String CLASS_NAME = "org.mars_sim.msp.ui.standard.tool.map.USGSMarsMap";
    private static Logger logger = Logger.getLogger(CLASS_NAME);
    public static final String TYPE = "USGS map";
    public static final double HALF_MAP_ANGLE = 0.06106;
    public static final int MAP_HEIGHT = 11458;
    public static final int MAP_WIDTH = 22916;
    public static final double PIXEL_RHO = 3647.194675893874;
    public static final double HALF_MAP_ANGLE_DEG = 2.34375;
    private static final String psdUrl = "http://www.mapaplanet.org";
    private static final String psdCgi = "/explorer-bin/explorer.cgi";
    private static final String map = "Mars";
    private static final String layers = "mars_viking_merged";
    private static final String info = "NO";
    private static final String advoption = "YES";
    private static final String lines = "2668";
    private static final String samples = "720";
    private static final String sizeSelector = "resolution";
    private static final String Resolution = "64";
    private static final String R = "1";
    private static final String G = "2";
    private static final String B = "3";
    private static final String projection = "MERC";
    private static final String grid = "none";
    private static final String stretch = "none";
    private static final String resamp_method = "nearest_neighbor";
    private static final String center = "0";
    private static final String defaultcenter = "on";
    private static final String center_lat = "0";
    private boolean imageDone = false;
    private Component component;
    private boolean goodConnection = false;
    private boolean connectionTimeout = false;
    private Image img;
    private Timer connectionTimer = null;

    public USGSMarsMap() {
    }

    public USGSMarsMap(Component comp) {
        this.component = comp;
    }

    @Override
    public void drawMap(Coordinates newCenter) {
        this.connectionTimeout = false;
        double lat = 90.0 - Math.toDegrees(newCenter.getPhi());
        double lon = 360.0 - Math.toDegrees(newCenter.getTheta());
        if (lon > 180.0) {
            lon -= 360.0;
        }
        this.startPdsImageRetrieval(lon, lat);
        this.connectionTimer = new Timer(10000, this);
        this.connectionTimer.start();
    }

    public boolean isConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public boolean isImageDone() {
        return this.imageDone;
    }

    @Override
    public Image getMapImage() {
        return this.img;
    }

    private void startPdsImageRetrieval(double lat, double lon) {
        HttpURLConnection urlCon;
        this.imageDone = false;
        this.goodConnection = false;
        URL url = null;
        url = this.getPDSURL(lat, lon);
        try {
            urlCon = (HttpURLConnection)url.openConnection();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        new PDSConnectionManager(urlCon, this);
    }

    private URL getPDSURL(double lat, double lon) {
        double southSide;
        double northSide;
        double eastSide;
        DecimalFormat formatter = new DecimalFormat("0.000");
        double westSide = lon + 2.34375;
        if (westSide > 180.0) {
            westSide = westSide - 180.0 - 180.0;
        }
        if ((eastSide = lon - 2.34375) < -180.0) {
            eastSide = eastSide + 180.0 + 180.0;
        }
        if ((northSide = lat + 2.34375) > 90.0) {
            northSide = 90.0 + (90.0 - northSide);
        }
        if ((southSide = lat - 2.34375) < -90.0) {
            southSide = -90.0 + (-90.0 - southSide);
        }
        StringBuilder urlBuff = new StringBuilder("http://www.mapaplanet.org/explorer-bin/explorer.cgi?");
        urlBuff.append("map=Mars");
        urlBuff.append("&layers=mars_viking_merged");
        urlBuff.append("&info=NO");
        urlBuff.append("&advoption=YES");
        urlBuff.append("&lines=2668");
        urlBuff.append("&samples=720");
        urlBuff.append("&sizeSelector=resolution");
        urlBuff.append("&Resolution=64");
        urlBuff.append("&R=1");
        urlBuff.append("&G=2");
        urlBuff.append("&B=3");
        urlBuff.append("&projection=MERC");
        urlBuff.append("&grid=none");
        urlBuff.append("&stretch=none");
        urlBuff.append("&resamp_method=nearest_neighbor");
        urlBuff.append("&north=").append(formatter.format(northSide));
        urlBuff.append("&west=").append(formatter.format(westSide));
        urlBuff.append("&east=").append(formatter.format(eastSide));
        urlBuff.append("&south=").append(formatter.format(southSide));
        urlBuff.append("&center=0");
        urlBuff.append("&defaultcenter=on");
        urlBuff.append("&center_lat=0");
        try {
            return new URL(urlBuff.toString());
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void connectionEstablished(URLConnection connection) throws IOException {
        this.goodConnection = true;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String imageSrc = "";
            String line = null;
            while ((line = in.readLine()) != null) {
                String line2;
                if (line.indexOf("View and Save") <= -1 || (line2 = in.readLine()) == null) continue;
                int startIndex = line2.indexOf("/explorer");
                int endIndex = line2.indexOf("jpg") + 3;
                String relativeUrl = line2.substring(startIndex, endIndex);
                imageSrc = psdUrl + relativeUrl;
            }
            URL imageUrl = new URL(imageSrc);
            this.img = Toolkit.getDefaultToolkit().getImage(imageUrl);
            this.waitForMapLoaded();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            throw new IOException("Internet connection required");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.connectionTimer.stop();
        this.connectionTimeout = !this.goodConnection;
    }

    private void waitForMapLoaded() {
        MediaTracker tracker = new MediaTracker(this.component);
        tracker.addImage(this.img, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "waitForMapLoaded()", e);
        }
        this.imageDone = true;
    }

    private class PDSConnectionManager
    implements Runnable {
        private Thread connectionThread = null;
        private URLConnection connection = null;
        private USGSMarsMap map = null;

        private PDSConnectionManager(URLConnection connection, USGSMarsMap map) {
            this.connection = connection;
            this.map = map;
            if (this.connectionThread == null || !this.connectionThread.isAlive()) {
                this.connectionThread = new Thread((Runnable)this, "HTTP connection");
                this.connectionThread.start();
            }
        }

        @Override
        public void run() {
            try {
                this.connection.connect();
                this.map.connectionEstablished(this.connection);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Unable to connect to: " + e.getMessage());
            }
        }
    }
}

