/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.map;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.IntPoint;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.ui.swing.tool.map.MapUtils;
import org.mars_sim.msp.ui.swing.tool.map.UnitMapLayer;
import org.mars_sim.msp.ui.swing.unit_display_info.UnitDisplayInfo;
import org.mars_sim.msp.ui.swing.unit_display_info.UnitDisplayInfoFactory;

public class UnitIconMapLayer
extends UnitMapLayer {
    private Component displayComponent;

    public UnitIconMapLayer(Component displayComponent) {
        this.displayComponent = displayComponent;
    }

    @Override
    protected void displayUnit(Unit unit, Coordinates mapCenter, String mapType, Graphics g) {
        IntPoint location = MapUtils.getRectPosition(unit.getCoordinates(), mapCenter, mapType);
        UnitDisplayInfo displayInfo = UnitDisplayInfoFactory.getUnitDisplayInfo(unit);
        IntPoint imageLocation = this.getUnitDrawLocation(location, displayInfo.getSurfMapIcon(unit));
        int locX = imageLocation.getiX();
        int locY = imageLocation.getiY();
        if (!displayInfo.isMapBlink(unit) || !this.getBlinkFlag()) {
            Icon displayIcon = null;
            displayIcon = "topographical map".equals(mapType) ? displayInfo.getTopoMapIcon(unit) : displayInfo.getSurfMapIcon(unit);
            displayIcon.paintIcon(this.displayComponent, g, locX, locY);
        }
    }

    private IntPoint getUnitDrawLocation(IntPoint unitPosition, Icon unitIcon) {
        int unitX = unitPosition.getiX();
        int unitY = unitPosition.getiY();
        int iconHeight = unitIcon.getIconHeight();
        int iconWidth = unitIcon.getIconWidth();
        return new IntPoint(unitX - iconWidth / 2, unitY - iconHeight / 2);
    }
}

