/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.map;

import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collection;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.ui.swing.tool.map.MapLayer;
import org.mars_sim.msp.ui.swing.unit_display_info.UnitDisplayInfo;
import org.mars_sim.msp.ui.swing.unit_display_info.UnitDisplayInfoFactory;

abstract class UnitMapLayer
implements MapLayer {
    private boolean blinkFlag = false;
    private Collection<Unit> unitsToDisplay;

    protected boolean getBlinkFlag() {
        return this.blinkFlag;
    }

    public void setUnitsToDisplay(Collection<Unit> unitsToDisplay) {
        this.unitsToDisplay = new ArrayList<Unit>(unitsToDisplay);
    }

    @Override
    public void displayLayer(Coordinates mapCenter, String mapType, Graphics g) {
        Collection units = null;
        units = this.unitsToDisplay != null ? this.unitsToDisplay : Simulation.instance().getUnitManager().getUnits();
        for (Unit unit : units) {
            UnitDisplayInfo displayInfo = UnitDisplayInfoFactory.getUnitDisplayInfo(unit);
            if (!displayInfo.isMapDisplayed(unit)) continue;
            double angle = 0.0;
            angle = "USGS map".equals(mapType) ? 0.06106 : 0.48587;
            if (!(mapCenter.getAngle(unit.getCoordinates()) < angle)) continue;
            this.displayUnit(unit, mapCenter, mapType, g);
        }
        this.blinkFlag = !this.blinkFlag;
    }

    protected abstract void displayUnit(Unit var1, Coordinates var2, String var3, Graphics var4);
}

