/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.mars_sim.msp.core.UnitEvent;
import org.mars_sim.msp.core.UnitListener;
import org.mars_sim.msp.core.person.ai.mission.CollectResourcesMission;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.MissionEvent;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.vehicle.Rover;
import org.mars_sim.msp.ui.swing.tool.mission.MissionCustomInfoPanel;

public class CollectResourcesMissionCustomInfoPanel
extends MissionCustomInfoPanel
implements UnitListener {
    private CollectResourcesMission mission;
    private AmountResource resource;
    private Rover missionRover;
    private JLabel collectionValueLabel;
    private double resourceAmountCache;

    CollectResourcesMissionCustomInfoPanel(AmountResource resource) {
        this.resource = resource;
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel(new GridLayout(1, 2));
        this.add((Component)contentPanel, "North");
        String resourceString = resource.getName().substring(0, 1).toUpperCase() + resource.getName().substring(1);
        JLabel collectionTitleLabel = new JLabel("Total " + resourceString + " Collected: ");
        contentPanel.add(collectionTitleLabel);
        this.collectionValueLabel = new JLabel("0 kg", 2);
        contentPanel.add(this.collectionValueLabel);
    }

    @Override
    public void updateMission(Mission mission) {
        if (mission instanceof CollectResourcesMission) {
            if (this.missionRover != null) {
                this.missionRover.removeUnitListener((UnitListener)this);
            }
            this.mission = (CollectResourcesMission)mission;
            if (this.mission.getRover() != null) {
                this.missionRover = this.mission.getRover();
                this.missionRover.addUnitListener((UnitListener)this);
            }
            this.resourceAmountCache = this.mission.getTotalCollectedResources();
            this.updateCollectionValueLabel();
        }
    }

    @Override
    public void updateMissionEvent(MissionEvent e) {
    }

    public void unitUpdate(UnitEvent event) {
        if ("inventory resource event".equals(event.getType()) && this.resource.equals(event.getTarget())) {
            this.updateCollectionValueLabel();
        }
    }

    private void updateCollectionValueLabel() {
        double resourceAmount = 0.0;
        if (this.missionRover != null) {
            resourceAmount = this.missionRover.getInventory().getAmountResourceStored(this.resource, true);
            if (resourceAmount > this.resourceAmountCache) {
                this.resourceAmountCache = resourceAmount;
            } else {
                resourceAmount = this.resourceAmountCache;
            }
        }
        this.collectionValueLabel.setText((int)resourceAmount + " kg");
    }
}

