/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import org.mars_sim.msp.core.person.ai.mission.Exploration;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.MissionEvent;
import org.mars_sim.msp.ui.swing.tool.mission.MissionCustomInfoPanel;

public class ExplorationCustomInfoPanel
extends MissionCustomInfoPanel {
    private Exploration mission;
    private Map<String, ExplorationSitePanel> sitePanes;
    private Box mainPane;

    ExplorationCustomInfoPanel() {
        this.setLayout(new BorderLayout());
        JScrollPane mainScrollPane = new JScrollPane();
        this.add((Component)mainScrollPane, "North");
        this.mainPane = Box.createVerticalBox();
        mainScrollPane.setViewportView(this.mainPane);
        this.sitePanes = new HashMap<String, ExplorationSitePanel>(5);
    }

    @Override
    public void updateMission(Mission mission) {
        if (mission instanceof Exploration) {
            if (!mission.equals(this.mission)) {
                this.mission = (Exploration)mission;
                this.sitePanes.clear();
                this.mainPane.removeAll();
                Map explorationSites = this.mission.getExplorationSiteCompletion();
                TreeSet treeSet = new TreeSet(explorationSites.keySet());
                for (String siteName : treeSet) {
                    double completion = (Double)explorationSites.get(siteName);
                    ExplorationSitePanel panel = new ExplorationSitePanel(siteName, completion);
                    this.sitePanes.put(siteName, panel);
                    this.mainPane.add(panel);
                }
                this.mainPane.add(Box.createVerticalGlue());
                this.repaint();
            } else {
                Map explorationSites = this.mission.getExplorationSiteCompletion();
                TreeSet treeSet = new TreeSet(explorationSites.keySet());
                for (String siteName : treeSet) {
                    double completion = (Double)explorationSites.get(siteName);
                    if (!this.sitePanes.containsKey(siteName)) continue;
                    this.sitePanes.get(siteName).updateCompletion(completion);
                }
            }
        }
    }

    @Override
    public void updateMissionEvent(MissionEvent e) {
        if ("explore site".equals(e.getType())) {
            Exploration mission = (Exploration)e.getSource();
            String siteName = (String)e.getTarget();
            double completion = (Double)mission.getExplorationSiteCompletion().get(siteName);
            if (this.sitePanes.containsKey(siteName)) {
                this.sitePanes.get(siteName).updateCompletion(completion);
            }
        }
    }

    private class ExplorationSitePanel
    extends JPanel {
        private double completion;
        private JProgressBar completionBar;

        ExplorationSitePanel(String siteName, double completion) {
            this.completion = completion;
            this.setLayout(new GridLayout(1, 2));
            JPanel namePanel = new JPanel(new FlowLayout(0, 10, 10));
            this.add(namePanel);
            JLabel nameLabel = new JLabel(siteName, 2);
            namePanel.add(nameLabel);
            JPanel barPanel = new JPanel(new FlowLayout(1, 10, 10));
            this.add(barPanel);
            this.completionBar = new JProgressBar(0, 100);
            this.completionBar.setStringPainted(true);
            this.completionBar.setValue((int)(completion * 100.0));
            barPanel.add(this.completionBar);
        }

        void updateCompletion(double completion) {
            if (this.completion != completion) {
                this.completion = completion;
                this.completionBar.setValue((int)(completion * 100.0));
            }
        }
    }
}

