/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.UnitEvent;
import org.mars_sim.msp.core.UnitListener;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.mission.AreologyStudyFieldMission;
import org.mars_sim.msp.core.person.ai.mission.BiologyStudyFieldMission;
import org.mars_sim.msp.core.person.ai.mission.BuildingConstructionMission;
import org.mars_sim.msp.core.person.ai.mission.BuildingSalvageMission;
import org.mars_sim.msp.core.person.ai.mission.CollectIce;
import org.mars_sim.msp.core.person.ai.mission.CollectRegolith;
import org.mars_sim.msp.core.person.ai.mission.EmergencySupplyMission;
import org.mars_sim.msp.core.person.ai.mission.Exploration;
import org.mars_sim.msp.core.person.ai.mission.Mining;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.MissionEvent;
import org.mars_sim.msp.core.person.ai.mission.MissionListener;
import org.mars_sim.msp.core.person.ai.mission.RescueSalvageVehicle;
import org.mars_sim.msp.core.person.ai.mission.Trade;
import org.mars_sim.msp.core.person.ai.mission.VehicleMission;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.vehicle.Vehicle;
import org.mars_sim.msp.ui.swing.ImageLoader;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.mission.AreologyStudyFieldMissionCustomInfoPanel;
import org.mars_sim.msp.ui.swing.tool.mission.BiologyStudyFieldMissionCustomInfoPanel;
import org.mars_sim.msp.ui.swing.tool.mission.CollectResourcesMissionCustomInfoPanel;
import org.mars_sim.msp.ui.swing.tool.mission.ConstructionMissionCustomInfoPanel;
import org.mars_sim.msp.ui.swing.tool.mission.EmergencySupplyMissionCustomInfoPanel;
import org.mars_sim.msp.ui.swing.tool.mission.ExplorationCustomInfoPanel;
import org.mars_sim.msp.ui.swing.tool.mission.MiningMissionCustomInfoPanel;
import org.mars_sim.msp.ui.swing.tool.mission.MissionCustomInfoPanel;
import org.mars_sim.msp.ui.swing.tool.mission.RescueMissionCustomInfoPanel;
import org.mars_sim.msp.ui.swing.tool.mission.SalvageMissionCustomInfoPanel;
import org.mars_sim.msp.ui.swing.tool.mission.TradeMissionCustomInfoPanel;

public class MainDetailPanel
extends JPanel
implements ListSelectionListener,
MissionListener,
UnitListener {
    private static final String EMPTY = "empty";
    private Mission currentMission;
    private Vehicle currentVehicle;
    private JLabel descriptionLabel;
    private JLabel typeLabel;
    private JLabel phaseLabel;
    private JLabel memberNumLabel;
    private MemberTableModel memberTableModel;
    private JTable memberTable;
    private JButton centerMapButton;
    private JButton vehicleButton;
    private JLabel vehicleStatusLabel;
    private JLabel speedLabel;
    private JLabel distanceNextNavLabel;
    private JLabel traveledLabel;
    private MainDesktopPane desktop;
    private DecimalFormat formatter = new DecimalFormat("0.0");
    private CardLayout customPanelLayout;
    private JPanel missionCustomPane;
    private Map<String, MissionCustomInfoPanel> customInfoPanels;

    MainDetailPanel(MainDesktopPane desktop) {
        this.desktop = desktop;
        this.setLayout(new BorderLayout());
        Box mainPane = Box.createVerticalBox();
        mainPane.setBorder(new MarsPanelBorder());
        this.add((Component)mainPane, "Center");
        CustomBox descriptionPane = new CustomBox();
        descriptionPane.setAlignmentX(0.0f);
        mainPane.add(descriptionPane);
        this.descriptionLabel = new JLabel("Description:", 2);
        this.descriptionLabel.setAlignmentX(0.0f);
        descriptionPane.add(this.descriptionLabel);
        this.typeLabel = new JLabel("Type:");
        this.typeLabel.setAlignmentX(0.0f);
        descriptionPane.add(this.typeLabel);
        this.phaseLabel = new JLabel("Phase:");
        this.phaseLabel.setAlignmentX(0.0f);
        descriptionPane.add(this.phaseLabel);
        CustomBox memberPane = new CustomBox();
        memberPane.setAlignmentX(0.0f);
        mainPane.add(memberPane);
        this.memberNumLabel = new JLabel("Mission Members:   (Min:  - Max: )");
        this.memberNumLabel.setAlignmentX(0.0f);
        memberPane.add(this.memberNumLabel);
        JPanel memberBottomPane = new JPanel(new BorderLayout(0, 0));
        memberBottomPane.setAlignmentX(0.0f);
        memberPane.add(memberBottomPane);
        JPanel memberListPane = new JPanel(new BorderLayout(0, 0));
        memberListPane.setPreferredSize(new Dimension(100, 100));
        memberBottomPane.add((Component)memberListPane, "Center");
        JScrollPane memberScrollPane = new JScrollPane();
        memberListPane.add((Component)memberScrollPane, "Center");
        this.memberTableModel = new MemberTableModel();
        this.memberTable = new JTable(this.memberTableModel);
        this.memberTable.getColumnModel().getColumn(0).setPreferredWidth(40);
        this.memberTable.setRowSelectionAllowed(true);
        this.memberTable.setSelectionMode(0);
        this.memberTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    int index = MainDetailPanel.this.memberTable.getSelectedRow();
                    Person selectedPerson = MainDetailPanel.this.memberTableModel.getMemberAtIndex(index);
                    if (selectedPerson != null) {
                        MainDetailPanel.this.getDesktop().openUnitWindow((Unit)selectedPerson, false);
                    }
                }
            }
        });
        memberScrollPane.setViewportView(this.memberTable);
        CustomBox travelPane = new CustomBox();
        travelPane.setAlignmentX(0.0f);
        mainPane.add(travelPane);
        JPanel vehiclePane = new JPanel(new FlowLayout(0, 0, 0));
        vehiclePane.setAlignmentX(0.0f);
        travelPane.add(vehiclePane);
        this.centerMapButton = new JButton(ImageLoader.getIcon("CenterMap"));
        this.centerMapButton.setMargin(new Insets(1, 1, 1, 1));
        this.centerMapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainDetailPanel.this.currentMission != null) {
                    MainDetailPanel.this.getDesktop().centerMapGlobe(MainDetailPanel.this.currentMission.getCurrentMissionLocation());
                }
            }
        });
        this.centerMapButton.setToolTipText("Locate in Mars navigator tool");
        this.centerMapButton.setEnabled(false);
        vehiclePane.add(this.centerMapButton);
        JLabel vehicleLabel = new JLabel(" Vehicle: ");
        vehiclePane.add(vehicleLabel);
        this.vehicleButton = new JButton("   ");
        vehiclePane.add(this.vehicleButton);
        this.vehicleButton.setVisible(false);
        this.vehicleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VehicleMission vehicleMission;
                Vehicle vehicle;
                if (MainDetailPanel.this.currentMission instanceof VehicleMission && (vehicle = (vehicleMission = (VehicleMission)MainDetailPanel.this.currentMission).getVehicle()) != null) {
                    MainDetailPanel.this.getDesktop().openUnitWindow((Unit)vehicle, false);
                }
            }
        });
        this.vehicleStatusLabel = new JLabel("Vehicle Status:");
        this.vehicleStatusLabel.setAlignmentX(0.0f);
        travelPane.add(this.vehicleStatusLabel);
        this.speedLabel = new JLabel("Vehicle Speed:");
        this.speedLabel.setAlignmentX(0.0f);
        travelPane.add(this.speedLabel);
        this.distanceNextNavLabel = new JLabel("Distance to Next Navpoint:");
        this.distanceNextNavLabel.setAlignmentX(0.0f);
        travelPane.add(this.distanceNextNavLabel);
        this.traveledLabel = new JLabel("Traveled Distance:");
        this.traveledLabel.setAlignmentX(0.0f);
        travelPane.add(this.traveledLabel);
        this.customPanelLayout = new CardLayout();
        this.missionCustomPane = new JPanel(this.customPanelLayout);
        this.missionCustomPane.setPreferredSize(new Dimension(-1, 250));
        this.missionCustomPane.setBorder(new MarsPanelBorder());
        this.missionCustomPane.setAlignmentX(0.0f);
        mainPane.add(this.missionCustomPane);
        JPanel emptyCustomPane1 = new JPanel();
        this.missionCustomPane.add((Component)emptyCustomPane1, EMPTY);
        this.customInfoPanels = new HashMap<String, MissionCustomInfoPanel>();
        TradeMissionCustomInfoPanel tradePanel = new TradeMissionCustomInfoPanel();
        String tradeMissionName = Trade.class.getName();
        this.customInfoPanels.put(tradeMissionName, tradePanel);
        this.missionCustomPane.add((Component)tradePanel, tradeMissionName);
        MiningMissionCustomInfoPanel miningPanel = new MiningMissionCustomInfoPanel(desktop);
        String miningMissionName = Mining.class.getName();
        this.customInfoPanels.put(miningMissionName, miningPanel);
        this.missionCustomPane.add((Component)miningPanel, miningMissionName);
        ConstructionMissionCustomInfoPanel constructionPanel = new ConstructionMissionCustomInfoPanel(desktop);
        String constructionMissionName = BuildingConstructionMission.class.getName();
        this.customInfoPanels.put(constructionMissionName, constructionPanel);
        this.missionCustomPane.add((Component)constructionPanel, constructionMissionName);
        SalvageMissionCustomInfoPanel salvagePanel = new SalvageMissionCustomInfoPanel(desktop);
        String salvageMissionName = BuildingSalvageMission.class.getName();
        this.customInfoPanels.put(salvageMissionName, salvagePanel);
        this.missionCustomPane.add((Component)salvagePanel, salvageMissionName);
        ExplorationCustomInfoPanel explorationPanel = new ExplorationCustomInfoPanel();
        String explorationMissionName = Exploration.class.getName();
        this.customInfoPanels.put(explorationMissionName, explorationPanel);
        this.missionCustomPane.add((Component)explorationPanel, explorationMissionName);
        BiologyStudyFieldMissionCustomInfoPanel biologyFieldPanel = new BiologyStudyFieldMissionCustomInfoPanel(desktop);
        String biologyMissionName = BiologyStudyFieldMission.class.getName();
        this.customInfoPanels.put(biologyMissionName, biologyFieldPanel);
        this.missionCustomPane.add((Component)biologyFieldPanel, biologyMissionName);
        AreologyStudyFieldMissionCustomInfoPanel areologyFieldPanel = new AreologyStudyFieldMissionCustomInfoPanel(desktop);
        String areologyMissionName = AreologyStudyFieldMission.class.getName();
        this.customInfoPanels.put(areologyMissionName, areologyFieldPanel);
        this.missionCustomPane.add((Component)areologyFieldPanel, areologyMissionName);
        CollectResourcesMissionCustomInfoPanel collectRegolithPanel = new CollectResourcesMissionCustomInfoPanel(AmountResource.findAmountResource((String)"regolith"));
        String collectRegolithMissionName = CollectRegolith.class.getName();
        this.customInfoPanels.put(collectRegolithMissionName, collectRegolithPanel);
        this.missionCustomPane.add((Component)collectRegolithPanel, collectRegolithMissionName);
        CollectResourcesMissionCustomInfoPanel collectIcePanel = new CollectResourcesMissionCustomInfoPanel(AmountResource.findAmountResource((String)"ice"));
        String collectIceMissionName = CollectIce.class.getName();
        this.customInfoPanels.put(collectIceMissionName, collectIcePanel);
        this.missionCustomPane.add((Component)collectIcePanel, collectIceMissionName);
        RescueMissionCustomInfoPanel rescuePanel = new RescueMissionCustomInfoPanel(desktop);
        String rescueMissionName = RescueSalvageVehicle.class.getName();
        this.customInfoPanels.put(rescueMissionName, rescuePanel);
        this.missionCustomPane.add((Component)rescuePanel, rescueMissionName);
        EmergencySupplyMissionCustomInfoPanel emergencySupplyPanel = new EmergencySupplyMissionCustomInfoPanel();
        String emergencySupplyMissionName = EmergencySupplyMission.class.getName();
        this.customInfoPanels.put(emergencySupplyMissionName, emergencySupplyPanel);
        this.missionCustomPane.add((Component)emergencySupplyPanel, emergencySupplyMissionName);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Mission mission;
        if (this.currentMission != null) {
            this.currentMission.removeMissionListener((MissionListener)this);
        }
        if (this.currentVehicle != null) {
            this.currentVehicle.removeUnitListener((UnitListener)this);
        }
        if ((mission = (Mission)((JList)e.getSource()).getSelectedValue()) != null) {
            VehicleMission vehicleMission;
            Vehicle vehicle;
            this.descriptionLabel.setText("Description: " + mission.getDescription());
            this.typeLabel.setText("Type: " + mission.getName());
            String phaseText = mission.getPhaseDescription();
            if (phaseText.length() > 40) {
                phaseText = phaseText.substring(0, 40) + "...";
            }
            this.phaseLabel.setText("Phase: " + phaseText);
            int memberNum = mission.getPeopleNumber();
            int minMembers = mission.getMinPeople();
            String maxMembers = "";
            maxMembers = mission instanceof VehicleMission ? "" + mission.getMissionCapacity() : "unlimited";
            this.memberNumLabel.setText("Mission Members: " + memberNum + " (Min: " + minMembers + " - Max: " + maxMembers + ")");
            this.memberTableModel.setMission(mission);
            this.centerMapButton.setEnabled(true);
            boolean isVehicle = false;
            if (mission instanceof VehicleMission && (vehicle = (vehicleMission = (VehicleMission)mission).getVehicle()) != null) {
                isVehicle = true;
                this.vehicleButton.setText(vehicle.getName());
                this.vehicleButton.setVisible(true);
                this.vehicleStatusLabel.setText("Vehicle Status: " + vehicle.getStatus());
                this.speedLabel.setText("Vehicle Speed: " + this.formatter.format(vehicle.getSpeed()) + " km/h");
                try {
                    int distanceNextNav = (int)vehicleMission.getCurrentLegRemainingDistance();
                    this.distanceNextNavLabel.setText("Distance to Next Navpoint: " + distanceNextNav + " km");
                }
                catch (Exception e2) {
                    // empty catch block
                }
                int travelledDistance = (int)vehicleMission.getTotalDistanceTravelled();
                int totalDistance = (int)vehicleMission.getTotalDistance();
                this.traveledLabel.setText("Traveled Distance: " + travelledDistance + " km of " + totalDistance + " km");
                vehicle.addUnitListener((UnitListener)this);
                this.currentVehicle = vehicle;
            }
            if (!isVehicle) {
                this.vehicleButton.setVisible(false);
                this.vehicleStatusLabel.setText("Vehicle Status:");
                this.speedLabel.setText("Vehicle Speed:");
                this.distanceNextNavLabel.setText("Distance to Next Navpoint:");
                this.traveledLabel.setText("Traveled Distance:");
                this.currentVehicle = null;
            }
            mission.addMissionListener((MissionListener)this);
            this.currentMission = mission;
        } else {
            this.descriptionLabel.setText("Description:");
            this.typeLabel.setText("Type:");
            this.phaseLabel.setText("Phase:");
            this.memberNumLabel.setText("Mission Members:   (Min:  - Max: )");
            this.memberTableModel.setMission(null);
            this.centerMapButton.setEnabled(false);
            this.vehicleButton.setVisible(false);
            this.vehicleStatusLabel.setText("Vehicle Status:");
            this.speedLabel.setText("Vehicle Speed:");
            this.distanceNextNavLabel.setText("Distance to Next Navpoint:");
            this.traveledLabel.setText("Traveled Distance:");
            this.currentMission = null;
            this.currentVehicle = null;
            this.customPanelLayout.show(this.missionCustomPane, EMPTY);
        }
        this.updateCustomPanel(mission);
    }

    private void updateCustomPanel(Mission mission) {
        String missionClassName;
        boolean hasMissionPanel = false;
        if (mission != null && this.customInfoPanels.containsKey(missionClassName = mission.getClass().getName())) {
            hasMissionPanel = true;
            MissionCustomInfoPanel panel = this.customInfoPanels.get(missionClassName);
            this.customPanelLayout.show(this.missionCustomPane, missionClassName);
            panel.updateMission(mission);
        }
        if (!hasMissionPanel) {
            this.customPanelLayout.show(this.missionCustomPane, EMPTY);
        }
    }

    public void missionUpdate(MissionEvent e) {
        SwingUtilities.invokeLater(new MissionEventUpdater(e, this));
    }

    private void updateCustomPanelMissionEvent(MissionEvent e) {
        String missionClassName;
        Mission mission = (Mission)e.getSource();
        if (mission != null && this.customInfoPanels.containsKey(missionClassName = mission.getClass().getName())) {
            this.customInfoPanels.get(missionClassName).updateMissionEvent(e);
        }
    }

    public void unitUpdate(UnitEvent event) {
        SwingUtilities.invokeLater(new VehicleInfoUpdater(event));
    }

    private MainDesktopPane getDesktop() {
        return this.desktop;
    }

    private class MemberTableModel
    extends AbstractTableModel
    implements UnitListener {
        Mission mission = null;
        Collection<Person> members = new ConcurrentLinkedQueue<Person>();

        private MemberTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.members.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Name";
            }
            if (columnIndex == 1) {
                return "Task";
            }
            return "unknown";
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row < this.members.size()) {
                Object[] array = this.members.toArray();
                Person person = (Person)array[row];
                if (column == 0) {
                    return person.getName();
                }
                return person.getMind().getTaskManager().getTaskDescription();
            }
            return "unknown";
        }

        void setMission(Mission newMission) {
            this.mission = newMission;
            this.updateMembers();
        }

        public void unitUpdate(UnitEvent event) {
            String type = event.getType();
            Person person = (Person)event.getSource();
            int index = this.getIndex(this.members, person);
            if (type.equals("name")) {
                SwingUtilities.invokeLater(new MemberTableUpdater(index, 0));
            } else if (type.equals("task name") || type.equals("task")) {
                SwingUtilities.invokeLater(new MemberTableUpdater(index, 1));
            }
        }

        private int getIndex(Collection col, Object obj) {
            int result = -1;
            Object[] array = col.toArray();
            int size = array.length;
            for (int i = 0; i < size; ++i) {
                if (!array[i].equals(obj)) continue;
                result = i;
                break;
            }
            return result;
        }

        void updateMembers() {
            if (this.mission != null) {
                this.clearMembers();
                this.members = new ConcurrentLinkedQueue<Person>(this.mission.getPeople());
                Iterator<Person> i = this.members.iterator();
                while (i.hasNext()) {
                    i.next().addUnitListener((UnitListener)this);
                }
                SwingUtilities.invokeLater(new MemberTableUpdater());
            } else if (this.members.size() > 0) {
                this.clearMembers();
                SwingUtilities.invokeLater(new MemberTableUpdater());
            }
        }

        private void clearMembers() {
            if (this.members != null) {
                Iterator<Person> i = this.members.iterator();
                while (i.hasNext()) {
                    i.next().removeUnitListener((UnitListener)this);
                }
                this.members.clear();
            }
        }

        Person getMemberAtIndex(int index) {
            if (index >= 0 && index < this.members.size()) {
                return (Person)this.members.toArray()[index];
            }
            return null;
        }

        private class MemberTableUpdater
        implements Runnable {
            private int row;
            private int column;
            private boolean entireData;

            private MemberTableUpdater(int row, int column) {
                this.row = row;
                this.column = column;
                this.entireData = false;
            }

            private MemberTableUpdater() {
                this.entireData = true;
            }

            @Override
            public void run() {
                if (this.entireData) {
                    MemberTableModel.this.fireTableDataChanged();
                } else {
                    MemberTableModel.this.fireTableCellUpdated(this.row, this.column);
                }
            }
        }
    }

    private static class CustomBox
    extends Box {
        private CustomBox() {
            super(1);
            this.setBorder(new MarsPanelBorder());
        }

        @Override
        public Dimension getMaximumSize() {
            Dimension result = this.getPreferredSize();
            result.width = Short.MAX_VALUE;
            return result;
        }
    }

    private class VehicleInfoUpdater
    implements Runnable {
        private UnitEvent event;

        private VehicleInfoUpdater(UnitEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            String type = this.event.getType();
            Vehicle vehicle = (Vehicle)this.event.getSource();
            if (type.equals("vehicle status")) {
                MainDetailPanel.this.vehicleStatusLabel.setText("Vehicle Status: " + vehicle.getStatus());
            } else if (type.equals("vehicle speed")) {
                MainDetailPanel.this.speedLabel.setText("Vehicle Speed: " + MainDetailPanel.this.formatter.format(vehicle.getSpeed()) + " km/h");
            }
        }
    }

    private class MissionEventUpdater
    implements Runnable {
        private MissionEvent event;
        private MainDetailPanel panel;

        private MissionEventUpdater(MissionEvent event, MainDetailPanel panel) {
            this.event = event;
            this.panel = panel;
        }

        @Override
        public void run() {
            Mission mission = (Mission)this.event.getSource();
            String type = this.event.getType();
            if (type.equals("name")) {
                MainDetailPanel.this.typeLabel.setText("Type: " + mission.getName());
            } else if (type.equals("description")) {
                MainDetailPanel.this.descriptionLabel.setText("Description: " + mission.getDescription());
            } else if (type.equals("phase description")) {
                String phaseText = mission.getPhaseDescription();
                if (phaseText.length() > 40) {
                    phaseText = phaseText.substring(0, 40) + "...";
                }
                MainDetailPanel.this.phaseLabel.setText("Phase: " + phaseText);
            } else if (type.equals("remove member") || type.equals("add member") || type.equals("minimum people") || type.equals("capacity")) {
                int memberNum = mission.getPeopleNumber();
                int minMembers = mission.getMinPeople();
                String maxMembers = "";
                maxMembers = mission instanceof VehicleMission ? "" + mission.getMissionCapacity() : "unlimited";
                MainDetailPanel.this.memberNumLabel.setText("Mission Members: " + memberNum + " (Min: " + minMembers + " - Max: " + maxMembers + ")");
                MainDetailPanel.this.memberTableModel.updateMembers();
            } else if (type.equals("vehicle")) {
                Vehicle vehicle = ((VehicleMission)mission).getVehicle();
                if (vehicle != null) {
                    MainDetailPanel.this.vehicleButton.setText(vehicle.getName());
                    MainDetailPanel.this.vehicleButton.setVisible(true);
                    MainDetailPanel.this.vehicleStatusLabel.setText("Vehicle Status: " + vehicle.getStatus());
                    MainDetailPanel.this.speedLabel.setText("Vehicle Speed: " + MainDetailPanel.this.formatter.format(vehicle.getSpeed()) + " km/h");
                    vehicle.addUnitListener((UnitListener)this.panel);
                    MainDetailPanel.this.currentVehicle = vehicle;
                } else {
                    MainDetailPanel.this.vehicleButton.setVisible(false);
                    MainDetailPanel.this.vehicleStatusLabel.setText("Vehicle Status:");
                    MainDetailPanel.this.speedLabel.setText("Vehicle Speed:");
                    if (MainDetailPanel.this.currentVehicle != null) {
                        MainDetailPanel.this.currentVehicle.removeUnitListener((UnitListener)this.panel);
                    }
                    MainDetailPanel.this.currentVehicle = null;
                }
            } else if (type.equals("distance")) {
                VehicleMission vehicleMission = (VehicleMission)mission;
                try {
                    int distanceNextNav = (int)vehicleMission.getCurrentLegRemainingDistance();
                    MainDetailPanel.this.distanceNextNavLabel.setText("Distance to Next Navpoint: " + distanceNextNav + " km");
                }
                catch (Exception e2) {
                    // empty catch block
                }
                int travelledDistance = (int)vehicleMission.getTotalDistanceTravelled();
                int totalDistance = (int)vehicleMission.getTotalDistance();
                MainDetailPanel.this.traveledLabel.setText("Traveled Distance: " + travelledDistance + " km of " + totalDistance + " km");
            }
            MainDetailPanel.this.updateCustomPanelMissionEvent(this.event);
        }
    }
}

