/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.RoverMission;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.vehicle.Rover;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.tool.ToolWindow;
import org.mars_sim.msp.ui.swing.tool.mission.MainDetailPanel;
import org.mars_sim.msp.ui.swing.tool.mission.MissionListModel;
import org.mars_sim.msp.ui.swing.tool.mission.NavpointPanel;
import org.mars_sim.msp.ui.swing.tool.mission.create.CreateMissionWizard;
import org.mars_sim.msp.ui.swing.tool.mission.edit.EditMissionDialog;

public class MissionWindow
extends ToolWindow {
    public static final String NAME = "Mission Tool";
    private JList missionList;
    private NavpointPanel navpointPane;

    public MissionWindow(MainDesktopPane desktop) {
        super(NAME, desktop);
        JPanel mainPane = new JPanel(new BorderLayout());
        mainPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(mainPane);
        JPanel missionListPane = new JPanel(new BorderLayout());
        missionListPane.setPreferredSize(new Dimension(200, 200));
        mainPane.add((Component)missionListPane, "West");
        this.missionList = new JList(new MissionListModel());
        this.missionList.setSelectionMode(0);
        missionListPane.add((Component)new JScrollPane(this.missionList), "Center");
        JTabbedPane infoPane = new JTabbedPane();
        mainPane.add((Component)infoPane, "East");
        MainDetailPanel mainDetailPane = new MainDetailPanel(desktop);
        this.missionList.addListSelectionListener(mainDetailPane);
        infoPane.add("Info", mainDetailPane);
        this.navpointPane = new NavpointPanel();
        this.missionList.addListSelectionListener(this.navpointPane);
        infoPane.add("Navpoints", this.navpointPane);
        JPanel buttonPane = new JPanel(new FlowLayout());
        mainPane.add((Component)buttonPane, "South");
        JButton createButton = new JButton("Create New Mission");
        createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MissionWindow.this.createNewMission();
            }
        });
        buttonPane.add(createButton);
        final JButton editButton = new JButton("Modify Mission");
        editButton.setEnabled(false);
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Mission mission = (Mission)MissionWindow.this.missionList.getSelectedValue();
                if (mission != null) {
                    MissionWindow.this.editMission(mission);
                }
            }
        });
        this.missionList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                editButton.setEnabled(MissionWindow.this.missionList.getSelectedValue() != null);
            }
        });
        buttonPane.add(editButton);
        final JButton endButton = new JButton("End Mission");
        endButton.setEnabled(false);
        endButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Mission mission = (Mission)MissionWindow.this.missionList.getSelectedValue();
                if (mission != null) {
                    MissionWindow.this.endMission(mission);
                }
            }
        });
        this.missionList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                endButton.setEnabled(MissionWindow.this.missionList.getSelectedValue() != null);
            }
        });
        buttonPane.add(endButton);
        this.pack();
    }

    public void selectMission(Mission mission) {
        MissionListModel model = (MissionListModel)this.missionList.getModel();
        if (model.containsMission(mission)) {
            this.missionList.setSelectedValue(mission, true);
        }
    }

    private void createNewMission() {
        this.desktop.getMainWindow().pauseSimulation();
        new CreateMissionWizard(this.desktop.getMainWindow().getFrame());
        this.desktop.getMainWindow().unpauseSimulation();
    }

    private void editMission(Mission mission) {
        this.desktop.getMainWindow().pauseSimulation();
        new EditMissionDialog((Frame)this.desktop.getMainWindow().getFrame(), mission);
        this.desktop.getMainWindow().unpauseSimulation();
    }

    private void endMission(Mission mission) {
        this.exitVehicleAtSettlement(mission);
        mission.endMission("User ending mission.");
    }

    private void exitVehicleAtSettlement(Mission mission) {
        Rover rover;
        Settlement settlement;
        RoverMission roverMission;
        if (mission instanceof RoverMission && (roverMission = (RoverMission)mission).hasVehicle() && (settlement = (rover = roverMission.getRover()).getSettlement()) != null) {
            for (Person crewmember : rover.getCrew()) {
                try {
                    rover.getInventory().retrieveUnit((Unit)crewmember);
                    settlement.getInventory().storeUnit((Unit)crewmember);
                    BuildingManager.addToRandomBuilding((Person)crewmember, (Settlement)settlement);
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    @Override
    public void destroy() {
        this.missionList.clearSelection();
        ((MissionListModel)this.missionList.getModel()).destroy();
        this.navpointPane.destroy();
    }
}

