/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.person.ai.mission.Exploration;
import org.mars_sim.msp.core.person.ai.mission.Mining;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.MissionEvent;
import org.mars_sim.msp.core.person.ai.mission.MissionListener;
import org.mars_sim.msp.core.person.ai.mission.NavPoint;
import org.mars_sim.msp.core.person.ai.mission.TravelMission;
import org.mars_sim.msp.core.person.ai.mission.VehicleMission;
import org.mars_sim.msp.ui.swing.ImageLoader;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.map.MapPanel;
import org.mars_sim.msp.ui.swing.tool.map.MineralMapLayer;
import org.mars_sim.msp.ui.swing.tool.map.NavpointMapLayer;
import org.mars_sim.msp.ui.swing.tool.map.UnitIconMapLayer;
import org.mars_sim.msp.ui.swing.tool.map.UnitLabelMapLayer;
import org.mars_sim.msp.ui.swing.tool.map.VehicleTrailMapLayer;

public class NavpointPanel
extends JPanel
implements ListSelectionListener,
MissionListener {
    private Mission currentMission;
    private MapPanel mapPane;
    private VehicleTrailMapLayer trailLayer;
    private NavpointMapLayer navpointLayer;
    private MineralMapLayer mineralLayer;
    private NavpointTableModel navpointTableModel;
    private JTable navpointTable;

    NavpointPanel() {
        this.setLayout(new BorderLayout());
        Box mainPane = Box.createVerticalBox();
        mainPane.setBorder(new MarsPanelBorder());
        this.add((Component)mainPane, "Center");
        JPanel mapDisplayPane = new JPanel(new BorderLayout(0, 0));
        mainPane.add(mapDisplayPane);
        this.mapPane = new MapPanel();
        this.mapPane.addMapLayer(new UnitIconMapLayer(this.mapPane));
        this.mapPane.addMapLayer(new UnitLabelMapLayer());
        this.trailLayer = new VehicleTrailMapLayer();
        this.mapPane.addMapLayer(this.trailLayer);
        this.navpointLayer = new NavpointMapLayer(this);
        this.mapPane.addMapLayer(this.navpointLayer);
        this.mineralLayer = new MineralMapLayer(this);
        this.mapPane.setSize(new Dimension(300, 300));
        this.mapPane.setPreferredSize(new Dimension(300, 300));
        mapDisplayPane.add((Component)this.mapPane, "Center");
        JButton northButton = new JButton(ImageLoader.getIcon("NavpointNorth"));
        northButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Coordinates centerCoords = NavpointPanel.this.mapPane.getCenterLocation();
                if (centerCoords != null) {
                    double phi = centerCoords.getPhi();
                    if ((phi -= 0.48587) < 0.0) {
                        phi = 0.0;
                    }
                    NavpointPanel.this.mapPane.showMap(new Coordinates(phi, centerCoords.getTheta()));
                }
            }
        });
        mapDisplayPane.add((Component)northButton, "North");
        JButton westButton = new JButton(ImageLoader.getIcon("NavpointWest"));
        westButton.setMargin(new Insets(1, 1, 1, 1));
        westButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Coordinates centerCoords = NavpointPanel.this.mapPane.getCenterLocation();
                if (centerCoords != null) {
                    double theta = centerCoords.getTheta();
                    if ((theta -= 0.48587) < 0.0) {
                        theta += Math.PI * 2;
                    }
                    NavpointPanel.this.mapPane.showMap(new Coordinates(centerCoords.getPhi(), theta));
                }
            }
        });
        mapDisplayPane.add((Component)westButton, "West");
        JButton eastButton = new JButton(ImageLoader.getIcon("NavpointEast"));
        eastButton.setMargin(new Insets(1, 1, 1, 1));
        eastButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Coordinates centerCoords = NavpointPanel.this.mapPane.getCenterLocation();
                if (centerCoords != null) {
                    double theta = centerCoords.getTheta();
                    if ((theta += 0.48587) < Math.PI * 2) {
                        theta -= Math.PI * 2;
                    }
                    NavpointPanel.this.mapPane.showMap(new Coordinates(centerCoords.getPhi(), theta));
                }
            }
        });
        mapDisplayPane.add((Component)eastButton, "East");
        JButton southButton = new JButton(ImageLoader.getIcon("NavpointSouth"));
        southButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Coordinates centerCoords = NavpointPanel.this.mapPane.getCenterLocation();
                if (centerCoords != null) {
                    double phi = centerCoords.getPhi();
                    if ((phi += 0.48587) > Math.PI) {
                        phi = Math.PI;
                    }
                    NavpointPanel.this.mapPane.showMap(new Coordinates(phi, centerCoords.getTheta()));
                }
            }
        });
        mapDisplayPane.add((Component)southButton, "South");
        JPanel navpointTablePane = new JPanel(new BorderLayout(0, 0));
        navpointTablePane.setBorder(new MarsPanelBorder());
        navpointTablePane.setPreferredSize(new Dimension(-1, 180));
        mainPane.add(navpointTablePane);
        JScrollPane navpointScrollPane = new JScrollPane();
        navpointTablePane.add((Component)navpointScrollPane, "Center");
        this.navpointTableModel = new NavpointTableModel();
        this.navpointTable = new JTable(this.navpointTableModel);
        this.navpointTable.setRowSelectionAllowed(true);
        this.navpointTable.setSelectionMode(0);
        this.navpointTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting() && NavpointPanel.this.currentMission != null && NavpointPanel.this.currentMission instanceof TravelMission) {
                    TravelMission travelMission = (TravelMission)NavpointPanel.this.currentMission;
                    int index = NavpointPanel.this.navpointTable.getSelectedRow();
                    if (index > -1) {
                        NavPoint navpoint = travelMission.getNavpoint(index);
                        NavpointPanel.this.navpointLayer.setSelectedNavpoint(navpoint);
                        NavpointPanel.this.mapPane.showMap(navpoint.getLocation());
                    } else {
                        NavpointPanel.this.navpointLayer.setSelectedNavpoint(null);
                    }
                }
            }
        });
        navpointScrollPane.setViewportView(this.navpointTable);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Mission mission = (Mission)((JList)e.getSource()).getSelectedValue();
        if (this.currentMission != null && this.currentMission != mission) {
            this.currentMission.removeMissionListener((MissionListener)this);
        }
        if (mission != null) {
            if (mission != this.currentMission) {
                mission.addMissionListener((MissionListener)this);
                this.currentMission = mission;
                if (mission.getPeopleNumber() > 0) {
                    if (mission instanceof VehicleMission) {
                        this.trailLayer.setSingleVehicle(((VehicleMission)mission).getVehicle());
                    }
                    if (mission instanceof TravelMission) {
                        this.navpointLayer.setSingleMission(mission);
                        this.navpointLayer.setSelectedNavpoint(null);
                        this.navpointTableModel.updateNavpoints();
                    }
                    if (mission instanceof Exploration || mission instanceof Mining) {
                        if (!this.mapPane.hasMapLayer(this.mineralLayer)) {
                            this.mapPane.addMapLayer(this.mineralLayer);
                        }
                    } else if (this.mapPane.hasMapLayer(this.mineralLayer)) {
                        this.mapPane.removeMapLayer(this.mineralLayer);
                    }
                    this.mapPane.showMap(((Unit)this.currentMission.getPeople().toArray()[0]).getCoordinates());
                }
            }
        } else {
            this.currentMission = null;
            this.trailLayer.setSingleVehicle(null);
            this.navpointLayer.setSingleMission(null);
            this.navpointLayer.setSelectedNavpoint(null);
            this.navpointTableModel.updateNavpoints();
            if (this.mapPane.hasMapLayer(this.mineralLayer)) {
                this.mapPane.removeMapLayer(this.mineralLayer);
            }
            this.mapPane.showMap(null);
        }
    }

    public void missionUpdate(MissionEvent event) {
        String type = event.getType();
        if ("navpoints".equals(type)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NavpointPanel.this.navpointTableModel.updateNavpoints();
                }
            });
        }
    }

    public void destroy() {
        this.mapPane.destroy();
    }

    private class NavpointTableModel
    extends AbstractTableModel {
        private List<NavPoint> navpoints = new ArrayList<NavPoint>();

        private NavpointTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.navpoints.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Name";
            }
            if (columnIndex == 1) {
                return "Location";
            }
            if (columnIndex == 2) {
                return "Description";
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row < this.navpoints.size()) {
                NavPoint navpoint = this.navpoints.get(row);
                if (column == 0) {
                    return "Navpoint " + (row + 1);
                }
                if (column == 1) {
                    return navpoint.getLocation().getFormattedString();
                }
                if (column == 2) {
                    return navpoint.getDescription();
                }
                return "unknown";
            }
            return "unknown";
        }

        public void updateNavpoints() {
            if (NavpointPanel.this.currentMission != null && NavpointPanel.this.currentMission instanceof TravelMission) {
                this.navpoints.clear();
                TravelMission travelMission = (TravelMission)NavpointPanel.this.currentMission;
                for (int x = 0; x < travelMission.getNumberOfNavpoints(); ++x) {
                    this.navpoints.add(travelMission.getNavpoint(x));
                }
                this.fireTableDataChanged();
            } else if (this.navpoints.size() > 0) {
                this.navpoints.clear();
                this.fireTableDataChanged();
            }
        }
    }
}

