/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission.create;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.ItemResource;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.construction.ConstructionManager;
import org.mars_sim.msp.core.structure.construction.ConstructionSite;
import org.mars_sim.msp.core.structure.construction.ConstructionStage;
import org.mars_sim.msp.core.structure.construction.ConstructionStageInfo;
import org.mars_sim.msp.core.structure.construction.ConstructionUtil;
import org.mars_sim.msp.core.structure.construction.ConstructionVehicleType;
import org.mars_sim.msp.core.vehicle.LightUtilityVehicle;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.mission.create.CreateMissionWizard;
import org.mars_sim.msp.ui.swing.tool.mission.create.WizardPanel;

class ConstructionProjectPanel
extends WizardPanel {
    private static final String NAME = "Construction Project";
    private JLabel errorMessageLabel;
    private DefaultListModel siteListModel;
    private JList siteList;
    private DefaultListModel projectListModel;
    private JList projectList;
    private MaterialsTableModel materialsTableModel;
    private JTable materialsTable;

    ConstructionProjectPanel(CreateMissionWizard wizard) {
        super(wizard);
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(new MarsPanelBorder());
        JLabel titleLabel = new JLabel("Select a construction project", 0);
        this.add((Component)titleLabel, "North");
        JPanel centerPane = new JPanel(new BorderLayout(0, 0));
        this.add((Component)centerPane, "Center");
        JPanel mainSelectionPane = new JPanel(new GridLayout(1, 2));
        mainSelectionPane.setPreferredSize(new Dimension(-1, 200));
        centerPane.add((Component)mainSelectionPane, "North");
        JPanel constructionSiteSelectionPane = new JPanel(new BorderLayout(0, 0));
        constructionSiteSelectionPane.setBorder(new MarsPanelBorder());
        mainSelectionPane.add(constructionSiteSelectionPane);
        JLabel constructionSiteSelectionLabel = new JLabel("Select Construction Site", 0);
        constructionSiteSelectionPane.add((Component)constructionSiteSelectionLabel, "North");
        JScrollPane siteListScrollPane = new JScrollPane();
        siteListScrollPane.setHorizontalScrollBarPolicy(31);
        constructionSiteSelectionPane.add((Component)siteListScrollPane, "Center");
        this.siteListModel = new DefaultListModel();
        this.populateSiteListModel();
        this.siteList = new JList(this.siteListModel);
        this.siteList.setSelectionMode(0);
        this.siteList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                ConstructionProjectPanel.this.getWizard().setButtons(false);
                ConstructionProjectPanel.this.errorMessageLabel.setText(" ");
                ConstructionProjectPanel.this.populateProjectListModel();
            }
        });
        siteListScrollPane.setViewportView(this.siteList);
        JPanel constructionProjectSelectionPane = new JPanel(new BorderLayout(0, 0));
        constructionProjectSelectionPane.setBorder(new MarsPanelBorder());
        mainSelectionPane.add(constructionProjectSelectionPane);
        JLabel constructionProjectSelectionLabel = new JLabel("Select Construction Project", 0);
        constructionProjectSelectionPane.add((Component)constructionProjectSelectionLabel, "North");
        JScrollPane projectListScrollPane = new JScrollPane();
        projectListScrollPane.setHorizontalScrollBarPolicy(31);
        constructionProjectSelectionPane.add((Component)projectListScrollPane, "Center");
        this.projectListModel = new DefaultListModel();
        this.populateProjectListModel();
        this.projectList = new JList(this.projectListModel);
        this.projectList.setSelectionMode(0);
        this.projectList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                block7: {
                    ConstructionProjectPanel.this.materialsTableModel.update();
                    String selectedSite = (String)ConstructionProjectPanel.this.siteList.getSelectedValue();
                    ConstructionStageInfo stageInfo = (ConstructionStageInfo)ConstructionProjectPanel.this.projectList.getSelectedValue();
                    ConstructionProjectPanel.this.projectList.setToolTipText(ConstructionProjectPanel.this.getToolTipText(stageInfo));
                    if (stageInfo != null) {
                        if (selectedSite.indexOf(" unfinished") >= 0) {
                            ConstructionProjectPanel.this.getWizard().setButtons(true);
                            ConstructionProjectPanel.this.errorMessageLabel.setText(" ");
                        } else {
                            try {
                                if (ConstructionProjectPanel.this.hasEnoughConstructionMaterials(stageInfo)) {
                                    ConstructionProjectPanel.this.getWizard().setButtons(true);
                                    ConstructionProjectPanel.this.errorMessageLabel.setText(" ");
                                    break block7;
                                }
                                ConstructionProjectPanel.this.getWizard().setButtons(false);
                                ConstructionProjectPanel.this.errorMessageLabel.setText("Not enough materials at settlement for construction project.");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    } else {
                        ConstructionProjectPanel.this.errorMessageLabel.setText(" ");
                    }
                }
            }
        });
        projectListScrollPane.setViewportView(this.projectList);
        JPanel constructionMaterialsPane = new JPanel(new BorderLayout(0, 0));
        constructionMaterialsPane.setBorder(new MarsPanelBorder());
        centerPane.add((Component)constructionMaterialsPane, "Center");
        JLabel constructionMaterialsLabel = new JLabel("Construction Materials Required", 0);
        constructionMaterialsPane.add((Component)constructionMaterialsLabel, "North");
        JScrollPane materialsTableScrollPane = new JScrollPane();
        materialsTableScrollPane.setHorizontalScrollBarPolicy(31);
        constructionMaterialsPane.add((Component)materialsTableScrollPane, "Center");
        this.materialsTableModel = new MaterialsTableModel();
        this.materialsTable = new JTable(this.materialsTableModel);
        this.materialsTable.setRowSelectionAllowed(false);
        this.materialsTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component result = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                MaterialsTableModel tableModel = (MaterialsTableModel)table.getModel();
                if (tableModel.isFailureCell(row, column)) {
                    this.setBackground(Color.RED);
                } else if (!isSelected) {
                    this.setBackground(Color.WHITE);
                }
                return result;
            }
        });
        materialsTableScrollPane.setViewportView(this.materialsTable);
        this.errorMessageLabel = new JLabel(" ", 0);
        this.errorMessageLabel.setForeground(Color.RED);
        this.errorMessageLabel.setFont(this.errorMessageLabel.getFont().deriveFont(1));
        this.errorMessageLabel.setAlignmentX(0.5f);
        this.add((Component)this.errorMessageLabel, "South");
    }

    @Override
    void clearInfo() {
        this.siteListModel.clear();
        this.projectListModel.clear();
        this.materialsTableModel.update();
        this.getWizard().setButtons(false);
        this.errorMessageLabel.setText(" ");
    }

    @Override
    boolean commitChanges() {
        Settlement settlement = this.getConstructionSettlement();
        ConstructionManager manager = settlement.getConstructionManager();
        ConstructionSite selectedSite = null;
        int selectedSiteIndex = this.siteList.getSelectedIndex();
        if (selectedSiteIndex > 0) {
            int existingSiteIndex = selectedSiteIndex - 1;
            selectedSite = (ConstructionSite)manager.getConstructionSites().get(existingSiteIndex);
        }
        this.getWizard().getMissionData().setConstructionSite(selectedSite);
        ConstructionStageInfo selectedInfo = (ConstructionStageInfo)this.projectList.getSelectedValue();
        this.getWizard().getMissionData().setConstructionStageInfo(selectedInfo);
        return true;
    }

    @Override
    String getPanelName() {
        return NAME;
    }

    @Override
    void updatePanel() {
        this.populateSiteListModel();
        this.getWizard().setButtons(false);
    }

    private String getToolTipText(ConstructionStageInfo stageInfo) {
        String result = null;
        if (stageInfo != null && !stageInfo.getType().equals("building")) {
            try {
                StringBuilder nextStages = new StringBuilder("<html>Next possible stages:");
                Iterator i = ConstructionUtil.getNextPossibleStages((ConstructionStageInfo)stageInfo).iterator();
                while (i.hasNext()) {
                    nextStages.append("<br>&nbsp;&nbsp;&nbsp;").append(((ConstructionStageInfo)i.next()).getName());
                }
                nextStages.append("</html>");
                result = nextStages.toString();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    private void populateSiteListModel() {
        this.siteListModel.clear();
        this.siteListModel.addElement("New Site");
        Settlement settlement = this.getConstructionSettlement();
        if (settlement != null) {
            ConstructionManager manager = settlement.getConstructionManager();
            for (ConstructionSite site : manager.getConstructionSites()) {
                ConstructionStage stage = site.getCurrentConstructionStage();
                if (site.isUndergoingConstruction()) {
                    this.siteListModel.addElement("Site: " + stage + " - under construction");
                    continue;
                }
                if (site.isUndergoingSalvage()) {
                    this.siteListModel.addElement("Site: " + stage + " - under salvage");
                    continue;
                }
                if (site.hasUnfinishedStage()) {
                    if (stage.isSalvaging()) {
                        this.siteListModel.addElement("Site: " + stage + " salvage unfinished");
                        continue;
                    }
                    this.siteListModel.addElement("Site: " + stage + " construction unfinished");
                    continue;
                }
                this.siteListModel.addElement("Site: " + stage);
            }
        }
    }

    private void populateProjectListModel() {
        this.projectListModel.clear();
        int selectedSiteIndex = this.siteList.getSelectedIndex();
        String selectedSite = (String)this.siteList.getSelectedValue();
        if (selectedSite != null) {
            if (selectedSite.equals("New Site")) {
                try {
                    for (ConstructionStageInfo info : ConstructionUtil.getFoundationConstructionStageInfoList()) {
                        if (!info.isConstructable()) continue;
                        this.projectListModel.addElement(info);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            } else if (selectedSite.indexOf(" - under construction") >= 0) {
                this.errorMessageLabel.setText("Cannot start mission on site already undergoing construction.");
            } else if (selectedSite.indexOf(" - under salvage") >= 0) {
                this.errorMessageLabel.setText("Cannot start mission on site already undergoing salvage.");
            } else {
                Settlement settlement = this.getConstructionSettlement();
                if (settlement != null) {
                    ConstructionManager manager = settlement.getConstructionManager();
                    int siteNum = selectedSiteIndex - 1;
                    ConstructionSite site = (ConstructionSite)manager.getConstructionSites().get(siteNum);
                    if (site != null) {
                        if (selectedSite.indexOf(" unfinished") >= 0) {
                            this.projectListModel.addElement(site.getCurrentConstructionStage().getInfo());
                        } else {
                            try {
                                ConstructionStageInfo info = site.getCurrentConstructionStage().getInfo();
                                for (ConstructionStageInfo stageInfo : ConstructionUtil.getNextPossibleStages((ConstructionStageInfo)info)) {
                                    if (!stageInfo.isConstructable()) continue;
                                    this.projectListModel.addElement(stageInfo);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace(System.err);
                            }
                        }
                    }
                }
            }
        }
    }

    private Settlement getConstructionSettlement() {
        return this.getWizard().getMissionData().getConstructionSettlement();
    }

    private boolean hasEnoughConstructionMaterials(ConstructionStageInfo stageInfo) {
        boolean result = true;
        Settlement settlement = this.getWizard().getMissionData().getConstructionSettlement();
        Inventory inv = settlement.getInventory();
        for (AmountResource resource : stageInfo.getResources().keySet()) {
            double amount = (Double)stageInfo.getResources().get(resource);
            if (!(inv.getAmountResourceStored(resource, false) < amount)) continue;
            result = false;
        }
        for (Part part : stageInfo.getParts().keySet()) {
            int number = (Integer)stageInfo.getParts().get(part);
            if (inv.getItemResourceNum((ItemResource)part) >= number) continue;
            result = false;
        }
        int luvsNeeded = stageInfo.getVehicles().size();
        int luvsAvailable = inv.findNumUnitsOfClass(LightUtilityVehicle.class);
        if (luvsAvailable < luvsNeeded) {
            result = false;
        }
        HashMap<Part, Integer> attachmentParts = new HashMap<Part, Integer>();
        for (ConstructionVehicleType vehicleType : stageInfo.getVehicles()) {
            for (Part part : vehicleType.getAttachmentParts()) {
                int partNum = 1;
                if (attachmentParts.containsKey(part)) {
                    partNum += ((Integer)attachmentParts.get(part)).intValue();
                }
                attachmentParts.put(part, partNum);
            }
        }
        for (Part part : attachmentParts.keySet()) {
            int number = (Integer)attachmentParts.get(part);
            if (inv.getItemResourceNum((ItemResource)part) >= number) continue;
            result = false;
        }
        return result;
    }

    private class MaterialsTableModel
    extends AbstractTableModel {
        private ConstructionStageInfo info = null;
        private List<ConstructionMaterial> materialsList = new ArrayList<ConstructionMaterial>();

        private MaterialsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int columnIndex) {
            String result = "";
            if (columnIndex == 0) {
                result = "Construction Material";
            } else if (columnIndex == 1) {
                result = "Required by Project";
            } else if (columnIndex == 2) {
                result = "Available at Settlement";
            }
            return result;
        }

        @Override
        public int getRowCount() {
            return this.materialsList.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row < this.materialsList.size() && col < 3) {
                if (col == 0) {
                    return this.materialsList.get(row).toString();
                }
                if (col == 1) {
                    return this.materialsList.get(row).numRequired;
                }
                if (col == 2) {
                    return this.materialsList.get(row).numAvailable;
                }
                return null;
            }
            return null;
        }

        private void update() {
            this.info = (ConstructionStageInfo)ConstructionProjectPanel.this.projectList.getSelectedValue();
            this.materialsList.clear();
            this.populateMaterialsList();
            this.fireTableStructureChanged();
        }

        private void populateMaterialsList() {
            Inventory inv = ConstructionProjectPanel.this.getConstructionSettlement().getInventory();
            String selectedSite = (String)ConstructionProjectPanel.this.siteList.getSelectedValue();
            if (this.info != null && selectedSite.indexOf(" unfinished") == -1) {
                try {
                    for (AmountResource resource : this.info.getResources().keySet()) {
                        double amountRequired = (Double)this.info.getResources().get(resource);
                        double amountAvailable = inv.getAmountResourceStored(resource, false);
                        this.materialsList.add(new ConstructionMaterial(resource.getName(), (int)amountRequired, (int)amountAvailable));
                    }
                    for (Part part : this.info.getParts().keySet()) {
                        int numRequired = (Integer)this.info.getParts().get(part);
                        int numAvailable = inv.getItemResourceNum((ItemResource)part);
                        this.materialsList.add(new ConstructionMaterial(part.getName(), numRequired, numAvailable));
                    }
                    HashMap<Part, Integer> attachmentParts = new HashMap<Part, Integer>();
                    for (ConstructionVehicleType vehicleType : this.info.getVehicles()) {
                        for (Part part : vehicleType.getAttachmentParts()) {
                            int partNum = 1;
                            if (attachmentParts.containsKey(part)) {
                                partNum += ((Integer)attachmentParts.get(part)).intValue();
                            }
                            attachmentParts.put(part, partNum);
                        }
                    }
                    for (Part part : attachmentParts.keySet()) {
                        int numRequired = (Integer)attachmentParts.get(part);
                        int numAvailable = inv.getItemResourceNum((ItemResource)part);
                        this.materialsList.add(new ConstructionMaterial(part.getName(), numRequired, numAvailable));
                    }
                    int numVehiclesRequired = this.info.getVehicles().size();
                    int numVehiclesAvailable = inv.findNumUnitsOfClass(LightUtilityVehicle.class);
                    this.materialsList.add(new ConstructionMaterial("light utility vehicle", numVehiclesRequired, numVehiclesAvailable));
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }

        private boolean isFailureCell(int row, int col) {
            ConstructionMaterial material;
            boolean result = false;
            if (col == 2 && row < this.materialsList.size() && (material = this.materialsList.get(row)).numRequired > material.numAvailable) {
                result = true;
            }
            return result;
        }

        private class ConstructionMaterial {
            private String name;
            private int numRequired;
            private int numAvailable;

            private ConstructionMaterial(String name, int numRequired, int numAvailable) {
                this.name = name;
                this.numRequired = numRequired;
                this.numAvailable = numAvailable;
            }

            public String toString() {
                return this.name;
            }
        }
    }
}

