/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission.create;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.mission.create.CreateMissionWizard;
import org.mars_sim.msp.ui.swing.tool.mission.create.UnitTableCellRenderer;
import org.mars_sim.msp.ui.swing.tool.mission.create.UnitTableModel;
import org.mars_sim.msp.ui.swing.tool.mission.create.WizardPanel;

class DestinationSettlementPanel
extends WizardPanel {
    private static final String NAME = "Destination Settlement";
    private SettlementTableModel settlementTableModel;
    private JTable settlementTable;
    private JLabel errorMessageLabel;

    DestinationSettlementPanel(CreateMissionWizard wizard) {
        super(wizard);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new MarsPanelBorder());
        JLabel selectSettlementLabel = new JLabel("Select a destination settlement.", 0);
        selectSettlementLabel.setFont(selectSettlementLabel.getFont().deriveFont(1));
        selectSettlementLabel.setAlignmentX(0.5f);
        this.add(selectSettlementLabel);
        JPanel settlementPane = new JPanel(new BorderLayout(0, 0));
        settlementPane.setMaximumSize(new Dimension(Short.MAX_VALUE, 100));
        settlementPane.setAlignmentX(0.5f);
        this.add(settlementPane);
        JScrollPane settlementScrollPane = new JScrollPane();
        settlementPane.add((Component)settlementScrollPane, "Center");
        this.settlementTableModel = new SettlementTableModel();
        this.settlementTable = new JTable(this.settlementTableModel);
        this.settlementTable.setDefaultRenderer(Object.class, new UnitTableCellRenderer(this.settlementTableModel));
        this.settlementTable.setRowSelectionAllowed(true);
        this.settlementTable.setSelectionMode(0);
        this.settlementTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index;
                if (e.getValueIsAdjusting() && (index = DestinationSettlementPanel.this.settlementTable.getSelectedRow()) > -1) {
                    if (DestinationSettlementPanel.this.settlementTableModel.isFailureRow(index)) {
                        DestinationSettlementPanel.this.errorMessageLabel.setText("Selected destination settlement is not within rover range.");
                        DestinationSettlementPanel.this.getWizard().setButtons(false);
                    } else {
                        DestinationSettlementPanel.this.errorMessageLabel.setText(" ");
                        DestinationSettlementPanel.this.getWizard().setButtons(true);
                    }
                }
            }
        });
        this.settlementTable.setPreferredScrollableViewportSize(this.settlementTable.getPreferredSize());
        settlementScrollPane.setViewportView(this.settlementTable);
        this.errorMessageLabel = new JLabel(" ", 0);
        this.errorMessageLabel.setFont(this.errorMessageLabel.getFont().deriveFont(1));
        this.errorMessageLabel.setForeground(Color.RED);
        this.errorMessageLabel.setAlignmentX(0.5f);
        this.add(this.errorMessageLabel);
        this.add(Box.createVerticalGlue());
    }

    @Override
    String getPanelName() {
        return NAME;
    }

    @Override
    boolean commitChanges() {
        int selectedIndex = this.settlementTable.getSelectedRow();
        Settlement selectedSettlement = (Settlement)this.settlementTableModel.getUnit(selectedIndex);
        this.getWizard().getMissionData().setDestinationSettlement(selectedSettlement);
        return true;
    }

    @Override
    void clearInfo() {
        this.settlementTable.clearSelection();
        this.errorMessageLabel.setText(" ");
    }

    @Override
    void updatePanel() {
        this.settlementTableModel.updateTable();
        this.settlementTable.setPreferredScrollableViewportSize(this.settlementTable.getPreferredSize());
    }

    private class SettlementTableModel
    extends UnitTableModel {
        private SettlementTableModel() {
            this.columns.add("Name");
            this.columns.add("Distance");
            this.columns.add("Inhabitants");
            this.columns.add("Pop. Capacity");
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object result = "unknown";
            if (row < this.units.size()) {
                Settlement settlement = (Settlement)this.getUnit(row);
                if (column == 0) {
                    result = settlement.getName();
                } else {
                    if (column == 1) {
                        Settlement startingSettlement = DestinationSettlementPanel.this.getWizard().getMissionData().getStartingSettlement();
                        double distance = startingSettlement.getCoordinates().getDistance(settlement.getCoordinates());
                        return (int)distance;
                    }
                    if (column == 2) {
                        result = settlement.getCurrentPopulationNum();
                    } else if (column == 3) {
                        result = settlement.getPopulationCapacity();
                    }
                }
            }
            return result;
        }

        @Override
        void updateTable() {
            this.units.clear();
            Settlement startingSettlement = DestinationSettlementPanel.this.getWizard().getMissionData().getStartingSettlement();
            Collection settlements = Simulation.instance().getUnitManager().getSettlements();
            settlements.remove(startingSettlement);
            while (settlements.size() > 0) {
                double smallestDistance = Double.MAX_VALUE;
                Settlement smallestDistanceSettlement = null;
                for (Settlement settlement : settlements) {
                    double distance = startingSettlement.getCoordinates().getDistance(settlement.getCoordinates());
                    if (!(distance < smallestDistance)) continue;
                    smallestDistance = distance;
                    smallestDistanceSettlement = settlement;
                }
                settlements.remove(smallestDistanceSettlement);
                this.units.add(smallestDistanceSettlement);
            }
            this.fireTableDataChanged();
        }

        @Override
        boolean isFailureCell(int row, int column) {
            boolean result = false;
            Settlement settlement = (Settlement)this.getUnit(row);
            if (column == 1) {
                try {
                    Settlement startingSettlement = DestinationSettlementPanel.this.getWizard().getMissionData().getStartingSettlement();
                    double distance = startingSettlement.getCoordinates().getDistance(settlement.getCoordinates());
                    double roverRange = DestinationSettlementPanel.this.getWizard().getMissionData().getRover().getRange();
                    if (roverRange < distance) {
                        result = true;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return result;
        }
    }
}

