/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission.create;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Direction;
import org.mars_sim.msp.core.IntPoint;
import org.mars_sim.msp.core.person.ai.mission.CollectResourcesMission;
import org.mars_sim.msp.core.vehicle.Rover;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.map.EllipseLayer;
import org.mars_sim.msp.ui.swing.tool.map.MapPanel;
import org.mars_sim.msp.ui.swing.tool.map.MapUtils;
import org.mars_sim.msp.ui.swing.tool.map.MineralMapLayer;
import org.mars_sim.msp.ui.swing.tool.map.NavpointEditLayer;
import org.mars_sim.msp.ui.swing.tool.map.UnitIconMapLayer;
import org.mars_sim.msp.ui.swing.tool.map.UnitLabelMapLayer;
import org.mars_sim.msp.ui.swing.tool.mission.create.CreateMissionWizard;
import org.mars_sim.msp.ui.swing.tool.mission.create.WizardPanel;

class ExplorationSitesPanel
extends WizardPanel {
    private static final String NAME = "Exploration Sites";
    private static final double RANGE_MODIFIER = 0.95;
    private MapPanel mapPane;
    private EllipseLayer ellipseLayer;
    private NavpointEditLayer navLayer;
    private MineralMapLayer mineralLayer;
    private int navSelected;
    private IntPoint navOffset;
    private JPanel siteListPane;
    private JButton addButton;
    private double range;
    private double missionTimeLimit;
    private double timePerSite;

    ExplorationSitesPanel(CreateMissionWizard wizard) {
        super(wizard);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new MarsPanelBorder());
        JLabel titleLabel = new JLabel("Choose the exploration sites.");
        titleLabel.setFont(titleLabel.getFont().deriveFont(1));
        titleLabel.setAlignmentX(0.5f);
        this.add(titleLabel);
        this.add(Box.createVerticalStrut(10));
        JPanel centerPane = new JPanel(new BorderLayout(0, 0));
        centerPane.setAlignmentX(0.5f);
        centerPane.setMaximumSize(new Dimension(Short.MAX_VALUE, 350));
        this.add(centerPane);
        JPanel mapMainPane = new JPanel(new BorderLayout(0, 0));
        centerPane.add((Component)mapMainPane, "West");
        this.mapPane = new MapPanel();
        this.mineralLayer = new MineralMapLayer(this.mapPane);
        this.mapPane.addMapLayer(this.mineralLayer);
        this.mapPane.addMapLayer(new UnitIconMapLayer(this.mapPane));
        this.mapPane.addMapLayer(new UnitLabelMapLayer());
        this.ellipseLayer = new EllipseLayer(Color.GREEN);
        this.mapPane.addMapLayer(this.ellipseLayer);
        this.navLayer = new NavpointEditLayer(this.mapPane, true);
        this.mapPane.addMapLayer(this.navLayer);
        this.mapPane.setBorder(new MarsPanelBorder());
        this.mapPane.addMouseListener(new NavpointMouseListener());
        this.mapPane.addMouseMotionListener(new NavpointMouseMotionListener());
        mapMainPane.add((Component)this.mapPane, "North");
        JPanel instructionLabelPane = new JPanel(new GridLayout(2, 1, 0, 0));
        mapMainPane.add((Component)instructionLabelPane, "South");
        JLabel instructionLabel1 = new JLabel("Drag navpoint flags to the desired exploration", 2);
        instructionLabel1.setFont(instructionLabel1.getFont().deriveFont(1));
        instructionLabelPane.add(instructionLabel1);
        JLabel instructionLabel2 = new JLabel("sites.", 2);
        instructionLabel2.setFont(instructionLabel2.getFont().deriveFont(1));
        instructionLabelPane.add(instructionLabel2);
        JPanel sitePane = new JPanel(new BorderLayout(0, 0));
        sitePane.setAlignmentX(0.5f);
        sitePane.setMaximumSize(new Dimension(Short.MAX_VALUE, 300));
        centerPane.add((Component)sitePane, "Center");
        JScrollPane siteScrollPane = new JScrollPane();
        sitePane.add((Component)siteScrollPane, "Center");
        JPanel siteListMainPane = new JPanel(new BorderLayout(0, 0));
        siteScrollPane.setViewportView(siteListMainPane);
        this.siteListPane = new JPanel();
        this.siteListPane.setLayout(new BoxLayout(this.siteListPane, 1));
        siteListMainPane.add((Component)this.siteListPane, "North");
        JPanel addButtonPane = new JPanel(new FlowLayout());
        sitePane.add((Component)addButtonPane, "South");
        this.addButton = new JButton("Add Site");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SitePanel sitePane = new SitePanel(ExplorationSitesPanel.this.siteListPane.getComponentCount(), ExplorationSitesPanel.this.getNewSiteLocation());
                ExplorationSitesPanel.this.siteListPane.add(sitePane);
                ExplorationSitesPanel.this.navLayer.addNavpointPosition(MapUtils.getRectPosition(sitePane.getSite(), ExplorationSitesPanel.this.getCenterCoords(), "surface map"));
                ExplorationSitesPanel.this.mapPane.repaint();
                ExplorationSitesPanel.this.addButton.setEnabled(ExplorationSitesPanel.this.canAddMoreSites());
                ExplorationSitesPanel.this.validate();
            }
        });
        addButtonPane.add(this.addButton);
        JPanel bottomPane = new JPanel(new FlowLayout(0, 0, 0));
        bottomPane.setAlignmentX(0.5f);
        this.add(bottomPane);
        JPanel mineralLegendPane = new JPanel(new BorderLayout(0, 0));
        bottomPane.add(mineralLegendPane);
        JLabel mineralLegendLabel = new JLabel("Mineral Legend", 0);
        mineralLegendLabel.setFont(mineralLegendLabel.getFont().deriveFont(1));
        mineralLegendPane.add((Component)mineralLegendLabel, "North");
        JScrollPane mineralLegendScrollPane = new JScrollPane();
        mineralLegendPane.add((Component)mineralLegendScrollPane, "Center");
        MineralTableModel mineralTableModel = new MineralTableModel();
        JTable mineralLegendTable = new JTable(mineralTableModel);
        mineralLegendTable.setPreferredScrollableViewportSize(new Dimension(300, 50));
        mineralLegendTable.setCellSelectionEnabled(false);
        mineralLegendTable.setDefaultRenderer(Color.class, new ColorTableCellRenderer());
        mineralLegendScrollPane.setViewportView(mineralLegendTable);
        this.add(Box.createVerticalGlue());
    }

    @Override
    String getPanelName() {
        return NAME;
    }

    @Override
    boolean commitChanges() {
        this.getWizard().getMissionData().setExplorationSites(this.getSites());
        return true;
    }

    @Override
    void clearInfo() {
        this.siteListPane.removeAll();
        this.navLayer.clearNavpointPositions();
        this.getWizard().setButtons(false);
    }

    @Override
    void updatePanel() {
        this.range = this.getRange();
        this.missionTimeLimit = this.getMissionTimeLimit();
        this.timePerSite = this.getTimePerSite();
        Coordinates startingSite = this.getCenterCoords().getNewLocation(new Direction(0.0), this.range / 4.0);
        SitePanel startingSitePane = new SitePanel(0, startingSite);
        this.siteListPane.add(startingSitePane);
        this.navLayer.addNavpointPosition(MapUtils.getRectPosition(startingSitePane.getSite(), this.getCenterCoords(), "surface map"));
        this.mapPane.showMap(this.getCenterCoords());
        this.addButton.setEnabled(this.canAddMoreSites());
        this.getWizard().setButtons(true);
    }

    private boolean canAddMoreSites() {
        return this.missionTimeLimit > this.getTotalMissionTime() + this.getTimePerSite();
    }

    private Coordinates getNewSiteLocation() {
        Coordinates result = null;
        Coordinates[] sites = this.getSites();
        Coordinates lastSite = sites[sites.length - 1];
        result = this.determineNewSiteLocation(lastSite, this.getCenterCoords(), this.getRemainingRange(true));
        return result;
    }

    private double getRemainingRange(boolean newSite) {
        double travelTime = this.missionTimeLimit - this.getTotalSiteTime();
        if (newSite) {
            travelTime -= this.timePerSite;
        }
        Rover rover = this.getWizard().getMissionData().getRover();
        double timeRange = travelTime / 1000.0 * rover.getEstimatedTravelDistancePerSol();
        double realRange = this.range;
        if (timeRange < this.range) {
            realRange = timeRange;
        }
        return realRange - this.getDistance();
    }

    private double getRange() {
        try {
            return this.getWizard().getMissionData().getRover().getRange() * 0.95;
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    private double getMissionTimeLimit() {
        Rover rover = this.getWizard().getMissionData().getRover();
        int memberNum = this.getWizard().getMissionData().getMembers().size();
        try {
            return CollectResourcesMission.getTotalTripTimeLimit((Rover)rover, (int)memberNum, (boolean)true);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    private double getTimePerSite() {
        return 1000.0;
    }

    private double getTotalSiteTime() {
        return this.timePerSite * (double)this.siteListPane.getComponentCount();
    }

    private double getTravelTime() {
        Rover rover = this.getWizard().getMissionData().getRover();
        return this.getDistance() / (rover.getEstimatedTravelDistancePerSol() / 1000.0);
    }

    private double getTotalMissionTime() {
        return this.getTravelTime() + this.getTotalSiteTime();
    }

    private double getDistance() {
        double result = 0.0;
        Coordinates[] sites = this.getSites();
        result += this.getCenterCoords().getDistance(sites[0]);
        for (int x = 1; x < sites.length; ++x) {
            result += sites[x - 1].getDistance(sites[x]);
        }
        return result += sites[sites.length - 1].getDistance(this.getCenterCoords());
    }

    private Coordinates[] getSites() {
        Coordinates[] result = new Coordinates[this.siteListPane.getComponentCount()];
        for (int x = 0; x < this.siteListPane.getComponentCount(); ++x) {
            result[x] = ((SitePanel)this.siteListPane.getComponent(x)).getSite();
        }
        return result;
    }

    private void updateSiteNumbers() {
        this.navLayer.clearNavpointPositions();
        for (int x = 0; x < this.siteListPane.getComponentCount(); ++x) {
            SitePanel sitePane = (SitePanel)this.siteListPane.getComponent(x);
            sitePane.setSiteNum(x);
            this.navLayer.addNavpointPosition(MapUtils.getRectPosition(sitePane.getSite(), this.getCenterCoords(), "surface map"));
        }
        this.mapPane.repaint();
    }

    private Coordinates getCenterCoords() {
        return this.getWizard().getMissionData().getStartingSettlement().getCoordinates();
    }

    private Coordinates determineNewSiteLocation(Coordinates prevNav, Coordinates nextNav, double range) {
        double fociDistance = prevNav.getDistance(nextNav);
        double distanceFromCenterOfAxis = Math.sqrt(Math.pow((range + fociDistance) / 2.0, 2.0) - Math.pow(fociDistance / 2.0, 2.0));
        double initialDistanceFromAxis = distanceFromCenterOfAxis / 2.0;
        double initialDistanceFromFoci = Math.sqrt(Math.pow(fociDistance / 2.0, 2.0) + Math.pow(initialDistanceFromAxis, 2.0));
        Direction initialDirectionFromFoci = new Direction(Math.asin(initialDistanceFromAxis / initialDistanceFromFoci));
        Direction fociDirection = prevNav.getDirectionToPoint(nextNav);
        Direction directionToNewSite = new Direction(fociDirection.getDirection() - initialDirectionFromFoci.getDirection());
        return prevNav.getNewLocation(directionToNewSite, initialDistanceFromFoci);
    }

    private Coordinates getPreviousNavpoint() {
        Coordinates prevNavpoint = null;
        prevNavpoint = this.navSelected > 0 ? ((SitePanel)this.siteListPane.getComponent(this.navSelected - 1)).getSite() : this.getCenterCoords();
        return prevNavpoint;
    }

    private Coordinates getNextNavpoint() {
        Coordinates nextNavpoint = null;
        nextNavpoint = this.navSelected < this.siteListPane.getComponentCount() - 1 ? ((SitePanel)this.siteListPane.getComponent(this.navSelected + 1)).getSite() : this.getCenterCoords();
        return nextNavpoint;
    }

    private Coordinates getCurrentNavpoint() {
        return ((SitePanel)this.siteListPane.getComponent(this.navSelected)).getSite();
    }

    private static class ColorTableCellRenderer
    implements TableCellRenderer {
        private ColorTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null && value instanceof Color) {
                Color color = (Color)value;
                JPanel colorPanel = new JPanel();
                colorPanel.setOpaque(true);
                colorPanel.setBackground(color);
                return colorPanel;
            }
            return null;
        }
    }

    private class MineralTableModel
    extends AbstractTableModel {
        private Map<String, Color> mineralColors = null;
        private List<String> mineralNames = null;

        private MineralTableModel() {
            this.mineralColors = ExplorationSitesPanel.this.mineralLayer.getMineralColors();
            this.mineralNames = new ArrayList<String>(this.mineralColors.keySet());
        }

        @Override
        public int getRowCount() {
            return this.mineralNames.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Class<Object> dataType = super.getColumnClass(columnIndex);
            if (columnIndex == 0) {
                dataType = String.class;
            }
            if (columnIndex == 1) {
                dataType = Color.class;
            }
            return dataType;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Mineral";
            }
            if (columnIndex == 1) {
                return "Color";
            }
            return "unknown";
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row < this.getRowCount()) {
                String mineralName = this.mineralNames.get(row);
                if (column == 0) {
                    return mineralName;
                }
                if (column == 1) {
                    return this.mineralColors.get(mineralName);
                }
                return "unknown";
            }
            return "unknown";
        }
    }

    private class NavpointMouseMotionListener
    extends MouseMotionAdapter {
        private NavpointMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            Coordinates center;
            Coordinates navpoint;
            int displayY;
            int displayX;
            IntPoint displayPos;
            if (ExplorationSitesPanel.this.navSelected > -1 && this.withinBounds(displayPos = new IntPoint(displayX = event.getPoint().x + ExplorationSitesPanel.this.navOffset.getiX(), displayY = event.getPoint().y + ExplorationSitesPanel.this.navOffset.getiY()), navpoint = (center = ExplorationSitesPanel.this.getWizard().getMissionData().getStartingSettlement().getCoordinates()).convertRectToSpherical((double)(displayPos.getiX() - 150), (double)(displayPos.getiY() - 150), 458.3662361046586))) {
                ExplorationSitesPanel.this.navLayer.setNavpointPosition(ExplorationSitesPanel.this.navSelected, new IntPoint(displayX, displayY));
                SitePanel selectedSitePane = (SitePanel)ExplorationSitesPanel.this.siteListPane.getComponent(ExplorationSitesPanel.this.navSelected);
                selectedSitePane.setLocation(navpoint);
                ExplorationSitesPanel.this.addButton.setEnabled(ExplorationSitesPanel.this.canAddMoreSites());
                ExplorationSitesPanel.this.mapPane.repaint();
            }
        }

        private boolean withinBounds(IntPoint position, Coordinates location) {
            boolean result = true;
            if (!ExplorationSitesPanel.this.navLayer.withinDisplayEdges(position)) {
                result = false;
            }
            if (ExplorationSitesPanel.this.getRemainingRange(false) < this.getDistanceDiff(location)) {
                result = false;
            }
            return result;
        }

        private double getDistanceDiff(Coordinates newSite) {
            Coordinates prevNavpoint = ExplorationSitesPanel.this.getPreviousNavpoint();
            Coordinates nextNavpoint = ExplorationSitesPanel.this.getNextNavpoint();
            Coordinates currentSite = ExplorationSitesPanel.this.getCurrentNavpoint();
            double currentSiteDistance = prevNavpoint.getDistance(currentSite) + currentSite.getDistance(nextNavpoint);
            double newSiteDistance = prevNavpoint.getDistance(newSite) + newSite.getDistance(nextNavpoint);
            return newSiteDistance - currentSiteDistance;
        }
    }

    private class NavpointMouseListener
    extends MouseAdapter {
        private NavpointMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            ExplorationSitesPanel.this.navSelected = ExplorationSitesPanel.this.navLayer.overNavIcon(event.getX(), event.getY());
            if (ExplorationSitesPanel.this.navSelected > -1) {
                ExplorationSitesPanel.this.navLayer.selectNavpoint(ExplorationSitesPanel.this.navSelected);
                ExplorationSitesPanel.this.navOffset = this.determineOffset(event.getX(), event.getY());
                IntPoint prevNavpoint = MapUtils.getRectPosition(ExplorationSitesPanel.this.getPreviousNavpoint(), ExplorationSitesPanel.this.getCenterCoords(), "surface map");
                IntPoint nextNavpoint = MapUtils.getRectPosition(ExplorationSitesPanel.this.getNextNavpoint(), ExplorationSitesPanel.this.getCenterCoords(), "surface map");
                int radiusPixels = this.convertDistanceToMapPixels(this.getRadius());
                ExplorationSitesPanel.this.ellipseLayer.setEllipseDetails(prevNavpoint, nextNavpoint, radiusPixels);
                ExplorationSitesPanel.this.ellipseLayer.setDisplayEllipse(true);
                ExplorationSitesPanel.this.mapPane.repaint();
            }
        }

        private IntPoint determineOffset(int x, int y) {
            int xOffset = ExplorationSitesPanel.this.navLayer.getNavpointPosition(ExplorationSitesPanel.this.navSelected).getiX() - x;
            int yOffset = ExplorationSitesPanel.this.navLayer.getNavpointPosition(ExplorationSitesPanel.this.navSelected).getiY() - y;
            return new IntPoint(xOffset, yOffset);
        }

        private double getRadius() {
            Coordinates currentNavpoint = ExplorationSitesPanel.this.getCurrentNavpoint();
            Coordinates prevNavpoint = ExplorationSitesPanel.this.getPreviousNavpoint();
            Coordinates nextNavpoint = ExplorationSitesPanel.this.getNextNavpoint();
            double currentDistance = prevNavpoint.getDistance(currentNavpoint) + currentNavpoint.getDistance(nextNavpoint);
            double straightDistance = prevNavpoint.getDistance(nextNavpoint);
            return currentDistance - straightDistance + ExplorationSitesPanel.this.getRemainingRange(false);
        }

        private int convertDistanceToMapPixels(double distance) {
            return MapUtils.getPixelDistance(distance, "surface map");
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            ExplorationSitesPanel.this.navSelected = -1;
            ExplorationSitesPanel.this.navLayer.clearSelectedNavpoint();
            ExplorationSitesPanel.this.ellipseLayer.setDisplayEllipse(false);
            ExplorationSitesPanel.this.mapPane.repaint();
        }
    }

    private class SitePanel
    extends JPanel {
        private Coordinates site;
        private int siteNum;
        private JLabel siteNumLabel;
        private JLabel siteLocationLabel;

        SitePanel(int siteNum, Coordinates site) {
            this.siteNum = siteNum;
            this.site = site;
            this.setLayout(new GridLayout(1, 3));
            this.setBorder(new MarsPanelBorder());
            this.siteNumLabel = new JLabel(" Site " + (siteNum + 1));
            this.add(this.siteNumLabel);
            this.siteLocationLabel = new JLabel(site.getFormattedString());
            this.add(this.siteLocationLabel);
            if (siteNum > 0) {
                JButton removeButton = new JButton("Remove");
                removeButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SitePanel.this.setVisible(false);
                        ExplorationSitesPanel.this.siteListPane.remove(SitePanel.this.getSiteNum());
                        ExplorationSitesPanel.this.updateSiteNumbers();
                        ExplorationSitesPanel.this.siteListPane.validate();
                    }
                });
                this.add(removeButton);
            } else {
                this.add(new JPanel());
            }
        }

        void setSiteNum(int siteNum) {
            this.siteNum = siteNum;
            this.siteNumLabel.setText(" Site " + (siteNum + 1));
        }

        int getSiteNum() {
            return this.siteNum;
        }

        void setLocation(Coordinates site) {
            this.site = site;
            this.siteLocationLabel.setText(site.getFormattedString());
        }

        Coordinates getSite() {
            return this.site;
        }
    }
}

