/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission.create;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.mars_sim.msp.core.CollectionUtils;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.science.Science;
import org.mars_sim.msp.core.science.ScientificStudy;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.mission.create.CreateMissionWizard;
import org.mars_sim.msp.ui.swing.tool.mission.create.UnitTableCellRenderer;
import org.mars_sim.msp.ui.swing.tool.mission.create.UnitTableModel;
import org.mars_sim.msp.ui.swing.tool.mission.create.WizardPanel;

public class LeadResearcherPanel
extends WizardPanel {
    private static final String NAME = "Lead Researcher";
    private ResearcherTableModel researcherTableModel;
    private JTable researcherTable;
    private JLabel errorMessageLabel;

    LeadResearcherPanel(CreateMissionWizard wizard) {
        super(wizard);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new MarsPanelBorder());
        JLabel selectResearcherLabel = new JLabel("Select a lead researcher.", 0);
        selectResearcherLabel.setFont(selectResearcherLabel.getFont().deriveFont(1));
        selectResearcherLabel.setAlignmentX(0.5f);
        this.add(selectResearcherLabel);
        JPanel researcherPane = new JPanel(new BorderLayout(0, 0));
        researcherPane.setMaximumSize(new Dimension(Short.MAX_VALUE, 100));
        researcherPane.setAlignmentX(0.5f);
        this.add(researcherPane);
        JScrollPane researcherScrollPane = new JScrollPane();
        researcherPane.add((Component)researcherScrollPane, "Center");
        this.researcherTableModel = new ResearcherTableModel();
        this.researcherTable = new JTable(this.researcherTableModel);
        this.researcherTable.setDefaultRenderer(Object.class, new UnitTableCellRenderer(this.researcherTableModel));
        this.researcherTable.setRowSelectionAllowed(true);
        this.researcherTable.setSelectionMode(0);
        this.researcherTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index;
                if (e.getValueIsAdjusting() && (index = LeadResearcherPanel.this.researcherTable.getSelectedRow()) > -1) {
                    if (LeadResearcherPanel.this.researcherTableModel.isFailureRow(index)) {
                        LeadResearcherPanel.this.errorMessageLabel.setText("researcher cannot lead the mission (see red cells).");
                        LeadResearcherPanel.this.getWizard().setButtons(false);
                    } else {
                        LeadResearcherPanel.this.errorMessageLabel.setText(" ");
                        LeadResearcherPanel.this.getWizard().setButtons(true);
                    }
                }
            }
        });
        this.researcherTable.setPreferredScrollableViewportSize(this.researcherTable.getPreferredSize());
        researcherScrollPane.setViewportView(this.researcherTable);
        this.errorMessageLabel = new JLabel(" ", 0);
        this.errorMessageLabel.setForeground(Color.RED);
        this.errorMessageLabel.setFont(this.errorMessageLabel.getFont().deriveFont(1));
        this.errorMessageLabel.setAlignmentX(0.5f);
        this.add(this.errorMessageLabel);
        this.add(Box.createVerticalGlue());
    }

    @Override
    void clearInfo() {
        this.researcherTable.clearSelection();
        this.errorMessageLabel.setText(" ");
    }

    @Override
    boolean commitChanges() {
        int selectedIndex = this.researcherTable.getSelectedRow();
        Person selectedResearcher = (Person)this.researcherTableModel.getUnit(selectedIndex);
        this.getWizard().getMissionData().setLeadResearcher(selectedResearcher);
        this.getWizard().getMissionData().setStartingSettlement(selectedResearcher.getAssociatedSettlement());
        return true;
    }

    @Override
    String getPanelName() {
        return NAME;
    }

    @Override
    void updatePanel() {
        this.researcherTableModel.updateTable();
        this.researcherTable.setPreferredScrollableViewportSize(this.researcherTable.getPreferredSize());
    }

    private class ResearcherTableModel
    extends UnitTableModel {
        private ResearcherTableModel() {
            this.columns.add("Name");
            this.columns.add("Study Research Field");
            this.columns.add("Current Mission");
            this.columns.add("Performance");
            this.columns.add("Health");
        }

        @Override
        public Object getValueAt(int row, int column) {
            String result = "unknown";
            if (row >= 0 && row < this.units.size()) {
                Person person = (Person)this.getUnit(row);
                try {
                    if (column == 0) {
                        result = person.getName();
                    } else if (column == 1) {
                        result = this.getResearchScience(person).getName();
                    } else if (column == 2) {
                        Mission mission = person.getMind().getMission();
                        result = mission != null ? mission.getName() : "none";
                    } else if (column == 3) {
                        result = (int)(person.getPerformanceRating() * 100.0) + "%";
                    } else if (column == 4) {
                        result = person.getPhysicalCondition().getHealthSituation();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return result;
        }

        private Science getResearchScience(Person person) {
            Science result = null;
            ScientificStudy study = LeadResearcherPanel.this.getWizard().getMissionData().getStudy();
            if (study.getPrimaryResearcher().equals(person)) {
                result = study.getScience();
            } else if (study.getCollaborativeResearchers().keySet().contains(person)) {
                result = (Science)study.getCollaborativeResearchers().get(person);
            }
            return result;
        }

        @Override
        void updateTable() {
            this.units.clear();
            ScientificStudy study = LeadResearcherPanel.this.getWizard().getMissionData().getStudy();
            this.units.add(study.getPrimaryResearcher());
            Iterator i = study.getCollaborativeResearchers().keySet().iterator();
            while (i.hasNext()) {
                this.units.add(i.next());
            }
            this.fireTableDataChanged();
        }

        @Override
        boolean isFailureCell(int row, int column) {
            boolean result = false;
            if (row < this.units.size()) {
                Person person = (Person)this.getUnit(row);
                if (column == 1) {
                    Science researchScience = this.getResearchScience(person);
                    Science studyScience = LeadResearcherPanel.this.getWizard().getMissionData().getStudy().getScience();
                    if (!studyScience.equals((Object)researchScience)) {
                        result = true;
                    }
                }
                if (column == 2 && person.getMind().getMission() != null) {
                    result = true;
                }
            }
            return result;
        }

        void addResearchers(Collection<Person> researchers) {
            for (Person researcher : researchers) {
                if (this.units.contains(researcher)) continue;
                this.units.add(researcher);
            }
            this.units = CollectionUtils.sortByName((Collection)this.units);
            this.fireTableDataChanged();
        }

        void removeResearchers(Collection<Person> researchers) {
            for (Person researcher : researchers) {
                if (!this.units.contains(researcher)) continue;
                this.units.remove(researcher);
            }
            this.fireTableDataChanged();
        }
    }
}

