/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission.create;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.mars_sim.msp.core.CollectionUtils;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.vehicle.LightUtilityVehicle;
import org.mars_sim.msp.core.vehicle.Vehicle;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.mission.create.CreateMissionWizard;
import org.mars_sim.msp.ui.swing.tool.mission.create.UnitTableCellRenderer;
import org.mars_sim.msp.ui.swing.tool.mission.create.UnitTableModel;
import org.mars_sim.msp.ui.swing.tool.mission.create.WizardPanel;

class LightUtilityVehiclePanel
extends WizardPanel {
    private static final String NAME = "Light Utility Vehicle";
    private VehicleTableModel vehicleTableModel;
    private JTable vehicleTable;
    private JLabel errorMessageLabel;

    LightUtilityVehiclePanel(CreateMissionWizard wizard) {
        super(wizard);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new MarsPanelBorder());
        JLabel selectVehicleLabel = new JLabel("Select a light utility vehicle for the mission.", 0);
        selectVehicleLabel.setFont(selectVehicleLabel.getFont().deriveFont(1));
        selectVehicleLabel.setAlignmentX(0.5f);
        this.add(selectVehicleLabel);
        JPanel vehiclePane = new JPanel(new BorderLayout(0, 0));
        vehiclePane.setMaximumSize(new Dimension(Short.MAX_VALUE, 100));
        vehiclePane.setAlignmentX(0.5f);
        this.add(vehiclePane);
        JScrollPane vehicleScrollPane = new JScrollPane();
        vehiclePane.add((Component)vehicleScrollPane, "Center");
        this.vehicleTableModel = new VehicleTableModel();
        this.vehicleTable = new JTable(this.vehicleTableModel);
        this.vehicleTable.setDefaultRenderer(Object.class, new UnitTableCellRenderer(this.vehicleTableModel));
        this.vehicleTable.setRowSelectionAllowed(true);
        this.vehicleTable.setSelectionMode(0);
        this.vehicleTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index;
                if (e.getValueIsAdjusting() && (index = LightUtilityVehiclePanel.this.vehicleTable.getSelectedRow()) > -1) {
                    if (LightUtilityVehiclePanel.this.vehicleTableModel.isFailureRow(index)) {
                        LightUtilityVehiclePanel.this.errorMessageLabel.setText("Light utility vehicle cannot be used on the mission (see red cells).");
                        LightUtilityVehiclePanel.this.getWizard().setButtons(false);
                    } else {
                        LightUtilityVehiclePanel.this.errorMessageLabel.setText(" ");
                        LightUtilityVehiclePanel.this.getWizard().setButtons(true);
                    }
                }
            }
        });
        this.vehicleTable.setPreferredScrollableViewportSize(this.vehicleTable.getPreferredSize());
        vehicleScrollPane.setViewportView(this.vehicleTable);
        this.errorMessageLabel = new JLabel(" ", 0);
        this.errorMessageLabel.setFont(this.errorMessageLabel.getFont().deriveFont(1));
        this.errorMessageLabel.setForeground(Color.RED);
        this.errorMessageLabel.setAlignmentX(0.5f);
        this.add(this.errorMessageLabel);
        this.add(Box.createVerticalGlue());
    }

    @Override
    String getPanelName() {
        return NAME;
    }

    @Override
    boolean commitChanges() {
        int selectedIndex = this.vehicleTable.getSelectedRow();
        LightUtilityVehicle selectedVehicle = (LightUtilityVehicle)this.vehicleTableModel.getUnit(selectedIndex);
        this.getWizard().getMissionData().setLUV(selectedVehicle);
        return true;
    }

    @Override
    void clearInfo() {
        this.vehicleTable.clearSelection();
        this.errorMessageLabel.setText(" ");
    }

    @Override
    void updatePanel() {
        this.vehicleTableModel.updateTable();
        this.vehicleTable.setPreferredScrollableViewportSize(this.vehicleTable.getPreferredSize());
    }

    private class VehicleTableModel
    extends UnitTableModel {
        private VehicleTableModel() {
            this.columns.add("Name");
            this.columns.add("Status");
            this.columns.add("Mission");
        }

        @Override
        public Object getValueAt(int row, int column) {
            String result = "unknown";
            if (row < this.units.size()) {
                LightUtilityVehicle vehicle = (LightUtilityVehicle)this.getUnit(row);
                try {
                    if (column == 0) {
                        result = vehicle.getName();
                    } else if (column == 1) {
                        result = vehicle.getStatus();
                    } else if (column == 2) {
                        Mission mission = Simulation.instance().getMissionManager().getMissionForVehicle((Vehicle)vehicle);
                        result = mission != null ? mission.getDescription() : "None";
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return result;
        }

        @Override
        void updateTable() {
            this.units.clear();
            Settlement startingSettlement = LightUtilityVehiclePanel.this.getWizard().getMissionData().getStartingSettlement();
            Collection vehicles = CollectionUtils.sortByName((Collection)startingSettlement.getParkedVehicles());
            for (Vehicle vehicle : vehicles) {
                if (!(vehicle instanceof LightUtilityVehicle)) continue;
                this.units.add(vehicle);
            }
            this.fireTableDataChanged();
        }

        @Override
        boolean isFailureCell(int row, int column) {
            Mission mission;
            boolean result = false;
            LightUtilityVehicle vehicle = (LightUtilityVehicle)this.getUnit(row);
            if (column == 1) {
                if (!vehicle.getStatus().equals("Parked")) {
                    result = true;
                }
            } else if (column == 2 && (mission = Simulation.instance().getMissionManager().getMissionForVehicle((Vehicle)vehicle)) != null) {
                result = true;
            }
            return result;
        }
    }
}

