/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission.create;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.mars_sim.msp.core.CollectionUtils;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.mission.create.CreateMissionWizard;
import org.mars_sim.msp.ui.swing.tool.mission.create.MissionDataBean;
import org.mars_sim.msp.ui.swing.tool.mission.create.UnitTableCellRenderer;
import org.mars_sim.msp.ui.swing.tool.mission.create.UnitTableModel;
import org.mars_sim.msp.ui.swing.tool.mission.create.WizardPanel;

class MembersPanel
extends WizardPanel {
    private static final String NAME = "Members";
    private PeopleTableModel peopleTableModel;
    private JTable peopleTable;
    private MembersTableModel membersTableModel;
    private JTable membersTable;
    private JLabel errorMessageLabel;
    private JButton addButton;
    private JButton removeButton;
    private JLabel roverCapacityLabel;

    MembersPanel(CreateMissionWizard wizard) {
        super(wizard);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new MarsPanelBorder());
        JLabel selectMembersLabel = new JLabel("Select members for the mission.", 0);
        selectMembersLabel.setFont(selectMembersLabel.getFont().deriveFont(1));
        selectMembersLabel.setAlignmentX(0.5f);
        this.add(selectMembersLabel);
        JLabel availablePeopleLabel = new JLabel("Available People", 0);
        availablePeopleLabel.setAlignmentX(0.5f);
        this.add(availablePeopleLabel);
        JPanel peoplePane = new JPanel(new BorderLayout(0, 0));
        peoplePane.setPreferredSize(new Dimension(300, 150));
        peoplePane.setAlignmentX(0.5f);
        this.add(peoplePane);
        JScrollPane peopleScrollPane = new JScrollPane();
        peoplePane.add((Component)peopleScrollPane, "Center");
        this.peopleTableModel = new PeopleTableModel();
        this.peopleTable = new JTable(this.peopleTableModel);
        this.peopleTable.setDefaultRenderer(Object.class, new UnitTableCellRenderer(this.peopleTableModel));
        this.peopleTable.setRowSelectionAllowed(true);
        this.peopleTable.setSelectionMode(2);
        this.peopleTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int[] selectedRows = MembersPanel.this.peopleTable.getSelectedRows();
                if (selectedRows.length > 0) {
                    if (e.getValueIsAdjusting()) {
                        MembersPanel.this.membersTable.clearSelection();
                        boolean failedRow = false;
                        for (int selectedRow : selectedRows) {
                            if (!MembersPanel.this.peopleTableModel.isFailureRow(selectedRow)) continue;
                            failedRow = true;
                        }
                        if (failedRow) {
                            MembersPanel.this.errorMessageLabel.setText("One or more selected people cannot be used on the mission (see red cells).");
                            MembersPanel.this.addButton.setEnabled(false);
                        } else if (selectedRows.length > MembersPanel.this.getRemainingRoverCapacity()) {
                            MembersPanel.this.errorMessageLabel.setText("Not enough rover capacity to hold selected people.");
                            MembersPanel.this.addButton.setEnabled(false);
                        } else {
                            MembersPanel.this.errorMessageLabel.setText(" ");
                            MembersPanel.this.addButton.setEnabled(true);
                        }
                    }
                } else {
                    MembersPanel.this.addButton.setEnabled(false);
                    MembersPanel.this.errorMessageLabel.setText(" ");
                }
            }
        });
        peopleScrollPane.setViewportView(this.peopleTable);
        this.errorMessageLabel = new JLabel(" ", 0);
        this.errorMessageLabel.setForeground(Color.RED);
        this.errorMessageLabel.setAlignmentX(0.5f);
        this.add(this.errorMessageLabel);
        this.add(Box.createVerticalStrut(10));
        JPanel buttonPane = new JPanel(new FlowLayout(1, 20, 0));
        buttonPane.setAlignmentX(0.5f);
        this.add(buttonPane);
        this.addButton = new JButton("Add Members");
        this.addButton.setEnabled(false);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedRows = MembersPanel.this.peopleTable.getSelectedRows();
                ConcurrentLinkedQueue<Person> people = new ConcurrentLinkedQueue<Person>();
                for (int selectedRow : selectedRows) {
                    people.add((Person)MembersPanel.this.peopleTableModel.getUnit(selectedRow));
                }
                MembersPanel.this.peopleTableModel.removePeople(people);
                MembersPanel.this.membersTableModel.addPeople(people);
                MembersPanel.this.updateRoverCapacityLabel();
            }
        });
        buttonPane.add(this.addButton);
        this.removeButton = new JButton("Remove Members");
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedRows = MembersPanel.this.membersTable.getSelectedRows();
                ConcurrentLinkedQueue<Person> people = new ConcurrentLinkedQueue<Person>();
                for (int selectedRow : selectedRows) {
                    people.add((Person)MembersPanel.this.membersTableModel.getUnit(selectedRow));
                }
                MembersPanel.this.peopleTableModel.addPeople(people);
                MembersPanel.this.membersTableModel.removePeople(people);
                MembersPanel.this.updateRoverCapacityLabel();
            }
        });
        buttonPane.add(this.removeButton);
        this.add(Box.createVerticalStrut(10));
        this.roverCapacityLabel = new JLabel("Remaining rover capacity: ");
        this.roverCapacityLabel.setAlignmentX(0.5f);
        this.add(this.roverCapacityLabel);
        this.add(Box.createVerticalStrut(10));
        JLabel membersLabel = new JLabel("Mission Members");
        membersLabel.setAlignmentX(0.5f);
        this.add(membersLabel);
        JPanel membersPane = new JPanel(new BorderLayout(0, 0));
        membersPane.setPreferredSize(new Dimension(300, 150));
        membersPane.setAlignmentX(0.5f);
        this.add(membersPane);
        JScrollPane membersScrollPane = new JScrollPane();
        membersPane.add((Component)membersScrollPane, "Center");
        this.membersTableModel = new MembersTableModel();
        this.membersTable = new JTable(this.membersTableModel);
        this.membersTable.setRowSelectionAllowed(true);
        this.membersTable.setSelectionMode(2);
        this.membersTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int[] selectedRows = MembersPanel.this.membersTable.getSelectedRows();
                if (selectedRows.length > 0) {
                    if (e.getValueIsAdjusting()) {
                        MembersPanel.this.peopleTable.clearSelection();
                        MembersPanel.this.removeButton.setEnabled(true);
                    }
                } else {
                    MembersPanel.this.removeButton.setEnabled(false);
                }
            }
        });
        membersScrollPane.setViewportView(this.membersTable);
    }

    @Override
    String getPanelName() {
        return NAME;
    }

    @Override
    boolean commitChanges() {
        ConcurrentLinkedQueue<Person> people = new ConcurrentLinkedQueue<Person>();
        for (int x = 0; x < this.membersTableModel.getRowCount(); ++x) {
            people.add((Person)this.membersTableModel.getUnit(x));
        }
        this.getWizard().getMissionData().setMembers(people);
        return true;
    }

    @Override
    void clearInfo() {
        this.peopleTable.clearSelection();
        this.membersTable.clearSelection();
        this.errorMessageLabel.setText(" ");
    }

    @Override
    void updatePanel() {
        this.peopleTableModel.updateTable();
        this.membersTableModel.updateTable();
        this.updateRoverCapacityLabel();
    }

    void updateRoverCapacityLabel() {
        String type = this.getWizard().getMissionData().getType();
        if ("Building Construction".equals(type)) {
            this.roverCapacityLabel.setText(" ");
        } else if ("Building Salvage".equals(type)) {
            this.roverCapacityLabel.setText(" ");
        } else {
            this.roverCapacityLabel.setText("Remaining rover capacity: " + this.getRemainingRoverCapacity());
        }
    }

    int getRemainingRoverCapacity() {
        String type = this.getWizard().getMissionData().getType();
        if ("Building Construction".equals(type)) {
            return Integer.MAX_VALUE;
        }
        if ("Building Salvage".equals(type)) {
            return Integer.MAX_VALUE;
        }
        int roverCapacity = this.getWizard().getMissionData().getRover().getCrewCapacity();
        int memberNum = this.membersTableModel.getRowCount();
        return roverCapacity - memberNum;
    }

    private class MembersTableModel
    extends UnitTableModel {
        private MembersTableModel() {
            this.columns.add("Name");
            this.columns.add("Job");
            this.columns.add("Current Mission");
            this.columns.add("Performance");
            this.columns.add("Health");
        }

        @Override
        public Object getValueAt(int row, int column) {
            String result = "unknown";
            if (row < this.units.size()) {
                Person person = (Person)this.getUnit(row);
                try {
                    if (column == 0) {
                        result = person.getName();
                    } else if (column == 1) {
                        result = person.getMind().getJob().getName();
                    } else if (column == 2) {
                        Mission mission = person.getMind().getMission();
                        result = mission != null ? mission.getName() : "none";
                    } else if (column == 3) {
                        result = (int)(person.getPerformanceRating() * 100.0) + "%";
                    } else if (column == 4) {
                        result = person.getPhysicalCondition().getHealthSituation();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return result;
        }

        @Override
        void updateTable() {
            this.units.clear();
            this.fireTableDataChanged();
        }

        @Override
        boolean isFailureCell(int row, int column) {
            return false;
        }

        void addPeople(Collection<Person> people) {
            for (Person person : people) {
                if (this.units.contains(person)) continue;
                this.units.add(person);
            }
            this.units = CollectionUtils.sortByName((Collection)this.units);
            this.fireTableDataChanged();
            MembersPanel.this.getWizard().setButtons(this.units.size() > 0);
        }

        void removePeople(Collection<Person> people) {
            for (Person person : people) {
                if (!this.units.contains(person)) continue;
                this.units.remove(person);
            }
            this.fireTableDataChanged();
            MembersPanel.this.getWizard().setButtons(this.units.size() > 0);
        }
    }

    private class PeopleTableModel
    extends UnitTableModel {
        private PeopleTableModel() {
            this.columns.add("Name");
            this.columns.add("Job");
            this.columns.add("Current Mission");
            this.columns.add("Performance");
            this.columns.add("Health");
        }

        @Override
        public Object getValueAt(int row, int column) {
            String result = "unknown";
            if (row < this.units.size()) {
                Person person = (Person)this.getUnit(row);
                try {
                    if (column == 0) {
                        result = person.getName();
                    } else if (column == 1) {
                        result = person.getMind().getJob().getName();
                    } else if (column == 2) {
                        Mission mission = person.getMind().getMission();
                        result = mission != null ? mission.getName() : "none";
                    } else if (column == 3) {
                        result = (int)(person.getPerformanceRating() * 100.0) + "%";
                    } else if (column == 4) {
                        result = person.getPhysicalCondition().getHealthSituation();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return result;
        }

        @Override
        void updateTable() {
            this.units.clear();
            MissionDataBean missionData = MembersPanel.this.getWizard().getMissionData();
            Settlement settlement = missionData.getStartingSettlement();
            if ("Building Construction".equals(missionData.getType())) {
                settlement = missionData.getConstructionSettlement();
            } else if ("Building Salvage".equals(missionData.getType())) {
                settlement = missionData.getSalvageSettlement();
            }
            Collection people = CollectionUtils.sortByName((Collection)settlement.getInhabitants());
            Iterator i = people.iterator();
            while (i.hasNext()) {
                this.units.add(i.next());
            }
            this.fireTableDataChanged();
        }

        @Override
        boolean isFailureCell(int row, int column) {
            boolean result = false;
            if (row < this.units.size()) {
                Person person = (Person)this.getUnit(row);
                if (column == 2 && person.getMind().getMission() != null) {
                    return true;
                }
            }
            return result;
        }

        void addPeople(Collection<Person> people) {
            for (Person person : people) {
                if (this.units.contains(person)) continue;
                this.units.add(person);
            }
            this.units = CollectionUtils.sortByName((Collection)this.units);
            this.fireTableDataChanged();
        }

        void removePeople(Collection<Person> people) {
            for (Person person : people) {
                if (!this.units.contains(person)) continue;
                this.units.remove(person);
            }
            this.fireTableDataChanged();
        }
    }
}

