/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission.create;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.IntPoint;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.mars.ExploredLocation;
import org.mars_sim.msp.core.mars.SurfaceFeatures;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.NumberCellRenderer;
import org.mars_sim.msp.ui.swing.tool.map.EllipseLayer;
import org.mars_sim.msp.ui.swing.tool.map.ExploredSiteMapLayer;
import org.mars_sim.msp.ui.swing.tool.map.MapPanel;
import org.mars_sim.msp.ui.swing.tool.map.MapUtils;
import org.mars_sim.msp.ui.swing.tool.map.MineralMapLayer;
import org.mars_sim.msp.ui.swing.tool.map.UnitIconMapLayer;
import org.mars_sim.msp.ui.swing.tool.map.UnitLabelMapLayer;
import org.mars_sim.msp.ui.swing.tool.mission.create.CreateMissionWizard;
import org.mars_sim.msp.ui.swing.tool.mission.create.WizardPanel;

public class MiningSitePanel
extends WizardPanel {
    private static final String NAME = "Mining Site";
    private static final double RANGE_MODIFIER = 0.95;
    private static final double CLICK_RANGE = 50.0;
    private MapPanel mapPane;
    private UnitIconMapLayer unitIconLayer;
    private UnitLabelMapLayer unitLabelLayer;
    private EllipseLayer ellipseLayer;
    private ExploredSiteMapLayer exploredSiteLayer;
    private MineralMapLayer mineralLayer;
    private JLabel longitudeLabel;
    private JLabel latitudeLabel;
    private JLabel errorMessageLabel;
    private ExploredLocation selectedSite;
    private DefaultTableModel concentrationTableModel;

    MiningSitePanel(CreateMissionWizard wizard) {
        super(wizard);
        String[] mineralTypes;
        this.setLayout(new BorderLayout(20, 20));
        this.setBorder(new MarsPanelBorder());
        JLabel titleLabel = new JLabel("Select explored site (yellow flag) to mine.", 0);
        titleLabel.setFont(titleLabel.getFont().deriveFont(1));
        this.add((Component)titleLabel, "North");
        JPanel leftPanel = new JPanel(new BorderLayout(0, 0));
        this.add((Component)leftPanel, "Center");
        JPanel centerPanel = new JPanel(new FlowLayout(1, 0, 0));
        leftPanel.add((Component)centerPanel, "Center");
        this.mapPane = new MapPanel();
        this.mineralLayer = new MineralMapLayer(this.mapPane);
        this.mapPane.addMapLayer(this.mineralLayer);
        this.unitIconLayer = new UnitIconMapLayer(this.mapPane);
        this.mapPane.addMapLayer(this.unitIconLayer);
        this.unitLabelLayer = new UnitLabelMapLayer();
        this.mapPane.addMapLayer(this.unitLabelLayer);
        this.ellipseLayer = new EllipseLayer(Color.GREEN);
        this.mapPane.addMapLayer(this.ellipseLayer);
        this.exploredSiteLayer = new ExploredSiteMapLayer(this.mapPane);
        this.mapPane.addMapLayer(this.exploredSiteLayer);
        this.exploredSiteLayer.setDisplayMined(false);
        this.exploredSiteLayer.setDisplayReserved(false);
        this.mapPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                MiningSitePanel.this.mouseSelection(event.getX(), event.getY());
            }
        });
        this.mapPane.setMaximumSize(this.mapPane.getPreferredSize());
        centerPanel.add(this.mapPane);
        JPanel legendPane = new JPanel(new BorderLayout(0, 0));
        leftPanel.add((Component)legendPane, "South");
        JLabel mineralLegendLabel = new JLabel("Mineral Legend", 0);
        mineralLegendLabel.setFont(mineralLegendLabel.getFont().deriveFont(1));
        legendPane.add((Component)mineralLegendLabel, "North");
        JScrollPane mineralLegendScrollPane = new JScrollPane();
        legendPane.add((Component)mineralLegendScrollPane, "Center");
        MineralTableModel mineralTableModel = new MineralTableModel();
        JTable mineralLegendTable = new JTable(mineralTableModel);
        mineralLegendTable.setPreferredScrollableViewportSize(new Dimension(300, 50));
        mineralLegendTable.setCellSelectionEnabled(false);
        mineralLegendTable.setDefaultRenderer(Color.class, new ColorTableCellRenderer());
        mineralLegendScrollPane.setViewportView(mineralLegendTable);
        JPanel selectedSitePane = new JPanel();
        selectedSitePane.setBorder(new MarsPanelBorder());
        selectedSitePane.setPreferredSize(new Dimension(250, -1));
        selectedSitePane.setLayout(new BoxLayout(selectedSitePane, 1));
        this.add((Component)selectedSitePane, "East");
        JLabel selectedSiteLabel = new JLabel("Selected Mining Site", 0);
        selectedSiteLabel.setAlignmentX(0.0f);
        selectedSitePane.add(selectedSiteLabel);
        selectedSitePane.add(Box.createVerticalStrut(10));
        this.longitudeLabel = new JLabel("Longitude: ", 2);
        this.longitudeLabel.setAlignmentX(0.0f);
        selectedSitePane.add(this.longitudeLabel);
        this.latitudeLabel = new JLabel("Latitude: ", 2);
        this.latitudeLabel.setAlignmentX(0.0f);
        selectedSitePane.add(this.latitudeLabel);
        selectedSitePane.add(Box.createVerticalStrut(10));
        JLabel mineralConcentrationLabel = new JLabel("Estimated Mineral Concentrations:", 2);
        mineralConcentrationLabel.setAlignmentX(0.0f);
        selectedSitePane.add(mineralConcentrationLabel);
        selectedSitePane.add(Box.createVerticalStrut(10));
        this.concentrationTableModel = new DefaultTableModel();
        this.concentrationTableModel.addColumn("Mineral");
        this.concentrationTableModel.addColumn("Concentration %");
        for (String mineralType : mineralTypes = Simulation.instance().getMars().getSurfaceFeatures().getMineralMap().getMineralTypeNames()) {
            this.concentrationTableModel.addRow(new Object[]{mineralType, 0.0});
        }
        JTable mineralConcentrationTable = new JTable(this.concentrationTableModel);
        mineralConcentrationTable.getColumnModel().getColumn(1).setCellRenderer(new NumberCellRenderer(2));
        selectedSitePane.add(mineralConcentrationTable.getTableHeader());
        selectedSitePane.add(mineralConcentrationTable);
        selectedSitePane.add(Box.createVerticalGlue());
        this.errorMessageLabel = new JLabel(" ", 0);
        this.errorMessageLabel.setForeground(Color.RED);
        this.errorMessageLabel.setFont(this.errorMessageLabel.getFont().deriveFont(1));
        this.add((Component)this.errorMessageLabel, "South");
    }

    @Override
    String getPanelName() {
        return NAME;
    }

    @Override
    boolean commitChanges() {
        if (this.selectedSite != null) {
            this.getWizard().getMissionData().setMiningSite(this.selectedSite);
            return true;
        }
        return false;
    }

    @Override
    void clearInfo() {
        this.getWizard().setButtons(false);
        this.longitudeLabel.setText("Longitude: ");
        this.latitudeLabel.setText("Latitude: ");
        for (int x = 0; x < this.concentrationTableModel.getRowCount(); ++x) {
            this.concentrationTableModel.setValueAt(new Double(0.0), x, 1);
        }
    }

    @Override
    void updatePanel() {
        try {
            ArrayList<Settlement> unitsToDisplay = new ArrayList<Settlement>(1);
            unitsToDisplay.add(this.getWizard().getMissionData().getStartingSettlement());
            this.unitIconLayer.setUnitsToDisplay(unitsToDisplay);
            this.unitLabelLayer.setUnitsToDisplay(unitsToDisplay);
            this.ellipseLayer.setEllipseDetails(new IntPoint(150, 150), new IntPoint(150, 150), this.convertRadiusToMapPixels(this.getRoverRange()) * 2);
            this.ellipseLayer.setDisplayEllipse(true);
            this.selectMiningSite(null);
            this.mapPane.showMap(this.getCenterCoords());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void selectMiningSite(ExploredLocation site) {
        block7: {
            this.selectedSite = site;
            this.exploredSiteLayer.setSelectedSite(site);
            if (site != null) {
                this.longitudeLabel.setText("Longitude: " + site.getLocation().getFormattedLongitudeString());
                this.latitudeLabel.setText("Latitude: " + site.getLocation().getFormattedLatitudeString());
                Map estimatedConcentrations = site.getEstimatedMineralConcentrations();
                for (int x = 0; x < this.concentrationTableModel.getRowCount(); ++x) {
                    String mineralType = (String)this.concentrationTableModel.getValueAt(x, 0);
                    Double concentration = (Double)estimatedConcentrations.get(mineralType);
                    this.concentrationTableModel.setValueAt(concentration, x, 1);
                }
                try {
                    if (this.getCenterCoords().getDistance(site.getLocation()) <= this.getRoverRange()) {
                        this.errorMessageLabel.setText(" ");
                        this.getWizard().setButtons(true);
                        break block7;
                    }
                    this.errorMessageLabel.setText("Selected mining site is out of rover range.");
                    this.getWizard().setButtons(false);
                }
                catch (Exception exception) {}
            } else {
                this.longitudeLabel.setText("Longitude: ");
                this.latitudeLabel.setText("Latitude: ");
                for (int x = 0; x < this.concentrationTableModel.getRowCount(); ++x) {
                    this.concentrationTableModel.setValueAt(new Double(0.0), x, 1);
                }
                this.errorMessageLabel.setText(" ");
                this.getWizard().setButtons(false);
            }
        }
    }

    private double getRoverRange() {
        return this.getWizard().getMissionData().getRover().getRange() * 0.95 / 2.0;
    }

    private Coordinates getCenterCoords() {
        return this.getWizard().getMissionData().getStartingSettlement().getCoordinates();
    }

    private int convertRadiusToMapPixels(double radius) {
        return MapUtils.getPixelDistance(radius, "surface map");
    }

    private void mouseSelection(int xLoc, int yLoc) {
        Coordinates center = this.getCenterCoords();
        if (center != null) {
            int xValue = xLoc - 150 - 1 + this.exploredSiteLayer.getIconWidth() / 2;
            int yValue = yLoc - 150 - 1 + this.exploredSiteLayer.getIconHeight() / 2;
            Coordinates clickedPosition = center.convertRectToSpherical((double)xValue, (double)yValue, 458.3662361046586);
            ExploredLocation closestSite = null;
            double closestRange = Double.MAX_VALUE;
            SurfaceFeatures surfaceFeatures = Simulation.instance().getMars().getSurfaceFeatures();
            for (ExploredLocation site : surfaceFeatures.getExploredLocations()) {
                double clickRange;
                if (site.isReserved() || site.isMined() || !site.isExplored() || !((clickRange = site.getLocation().getDistance(clickedPosition)) <= 50.0) || !(clickRange < closestRange)) continue;
                closestSite = site;
                closestRange = clickRange;
            }
            if (closestSite != null) {
                this.selectMiningSite(closestSite);
            }
        }
    }

    private static class ColorTableCellRenderer
    implements TableCellRenderer {
        private ColorTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null && value instanceof Color) {
                Color color = (Color)value;
                JPanel colorPanel = new JPanel();
                colorPanel.setOpaque(true);
                colorPanel.setBackground(color);
                return colorPanel;
            }
            return null;
        }
    }

    private class MineralTableModel
    extends AbstractTableModel {
        private Map<String, Color> mineralColors = null;
        private List<String> mineralNames = null;

        private MineralTableModel() {
            this.mineralColors = MiningSitePanel.this.mineralLayer.getMineralColors();
            this.mineralNames = new ArrayList<String>(this.mineralColors.keySet());
        }

        @Override
        public int getRowCount() {
            return this.mineralNames.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Class<Object> dataType = super.getColumnClass(columnIndex);
            if (columnIndex == 0) {
                dataType = String.class;
            }
            if (columnIndex == 1) {
                dataType = Color.class;
            }
            return dataType;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Mineral";
            }
            if (columnIndex == 1) {
                return "Color";
            }
            return "unknown";
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row < this.getRowCount()) {
                String mineralName = this.mineralNames.get(row);
                if (column == 0) {
                    return mineralName;
                }
                if (column == 1) {
                    return this.mineralColors.get(mineralName);
                }
                return "unknown";
            }
            return "unknown";
        }
    }
}

