/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission.create;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.mars.ExploredLocation;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.mission.AreologyStudyFieldMission;
import org.mars_sim.msp.core.person.ai.mission.BiologyStudyFieldMission;
import org.mars_sim.msp.core.person.ai.mission.BuildingConstructionMission;
import org.mars_sim.msp.core.person.ai.mission.BuildingSalvageMission;
import org.mars_sim.msp.core.person.ai.mission.CollectIce;
import org.mars_sim.msp.core.person.ai.mission.CollectRegolith;
import org.mars_sim.msp.core.person.ai.mission.EmergencySupplyMission;
import org.mars_sim.msp.core.person.ai.mission.Exploration;
import org.mars_sim.msp.core.person.ai.mission.Mining;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.MissionManager;
import org.mars_sim.msp.core.person.ai.mission.RescueSalvageVehicle;
import org.mars_sim.msp.core.person.ai.mission.Trade;
import org.mars_sim.msp.core.person.ai.mission.TravelToSettlement;
import org.mars_sim.msp.core.science.ScientificStudy;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.construction.ConstructionSite;
import org.mars_sim.msp.core.structure.construction.ConstructionStageInfo;
import org.mars_sim.msp.core.structure.goods.Good;
import org.mars_sim.msp.core.vehicle.GroundVehicle;
import org.mars_sim.msp.core.vehicle.LightUtilityVehicle;
import org.mars_sim.msp.core.vehicle.Rover;
import org.mars_sim.msp.core.vehicle.Vehicle;

class MissionDataBean {
    static final String TRAVEL_MISSION = "Travel to Settlement";
    static final String EXPLORATION_MISSION = "Mineral Exploration";
    static final String ICE_MISSION = "Ice Prospecting";
    static final String REGOLITH_MISSION = "Regolith Prospecting";
    static final String RESCUE_MISSION = "Rescue/Salvage Vehicle";
    static final String TRADE_MISSION = "Trade";
    static final String MINING_MISSION = "Mining";
    static final String CONSTRUCTION_MISSION = "Building Construction";
    static final String AREOLOGY_FIELD_MISSION = "Areology Study Field Mission";
    static final String BIOLOGY_FIELD_MISSION = "Biology Study Field Mission";
    static final String SALVAGE_MISSION = "Building Salvage";
    static final String EMERGENCY_SUPPLY_MISSION = "Emergency Supply Mission";
    private String type;
    private String description;
    private Settlement startingSettlement;
    private Rover rover;
    private Collection<Person> members;
    private Settlement destinationSettlement;
    private Rover rescueRover;
    private LightUtilityVehicle luv;
    private Coordinates iceCollectionSite;
    private Coordinates regolithCollectionSite;
    private Coordinates[] explorationSites;
    private ExploredLocation miningSite;
    private Map<Good, Integer> sellGoods;
    private Map<Good, Integer> buyGoods;
    private Settlement constructionSettlement;
    private ConstructionSite constructionSite;
    private ConstructionStageInfo constructionStageInfo;
    private double constructionSiteXLoc;
    private double constructionSiteYLoc;
    private double constructionSiteFacing;
    private List<GroundVehicle> constructionVehicles;
    private Settlement salvageSettlement;
    private ConstructionSite salvageSite;
    private Building salvageBuilding;
    private List<GroundVehicle> salvageVehicles;
    private Coordinates fieldSite;
    private Person leadResearcher;
    private ScientificStudy study;
    private Map<Good, Integer> emergencyGoods;

    MissionDataBean() {
    }

    void createMission() {
        ArrayList<Coordinates> collectionSites;
        TravelToSettlement mission = null;
        if (TRAVEL_MISSION.equals(this.type)) {
            mission = new TravelToSettlement(this.members, this.startingSettlement, this.destinationSettlement, this.rover, this.description);
        } else if (RESCUE_MISSION.equals(this.type)) {
            mission = new RescueSalvageVehicle(this.members, this.startingSettlement, (Vehicle)this.rescueRover, this.rover, this.description);
        } else if (ICE_MISSION.equals(this.type)) {
            collectionSites = new ArrayList<Coordinates>(1);
            collectionSites.add(this.iceCollectionSite);
            mission = new CollectIce(this.members, this.startingSettlement, collectionSites, this.rover, this.description);
        } else if (REGOLITH_MISSION.equals(this.type)) {
            collectionSites = new ArrayList(1);
            collectionSites.add(this.regolithCollectionSite);
            mission = new CollectRegolith(this.members, this.startingSettlement, collectionSites, this.rover, this.description);
        } else if (EXPLORATION_MISSION.equals(this.type)) {
            collectionSites = new ArrayList(this.explorationSites.length);
            collectionSites.addAll(Arrays.asList(this.explorationSites));
            mission = new Exploration(this.members, this.startingSettlement, collectionSites, this.rover, this.description);
        } else if (TRADE_MISSION.equals(this.type)) {
            mission = new Trade(this.members, this.startingSettlement, this.destinationSettlement, this.rover, this.description, this.sellGoods, this.buyGoods);
        } else if (MINING_MISSION.equals(this.type)) {
            mission = new Mining(this.members, this.startingSettlement, this.miningSite, this.rover, this.luv, this.description);
        } else if (CONSTRUCTION_MISSION.equals(this.type)) {
            mission = new BuildingConstructionMission(this.members, this.constructionSettlement, this.constructionSite, this.constructionStageInfo, this.constructionSiteXLoc, this.constructionSiteYLoc, this.constructionSiteFacing, this.constructionVehicles);
        } else if (AREOLOGY_FIELD_MISSION.equals(this.type)) {
            mission = new AreologyStudyFieldMission(this.members, this.startingSettlement, this.leadResearcher, this.study, this.rover, this.fieldSite, this.description);
        } else if (BIOLOGY_FIELD_MISSION.equals(this.type)) {
            mission = new BiologyStudyFieldMission(this.members, this.startingSettlement, this.leadResearcher, this.study, this.rover, this.fieldSite, this.description);
        } else if (SALVAGE_MISSION.equals(this.type)) {
            mission = new BuildingSalvageMission(this.members, this.salvageSettlement, this.salvageBuilding, this.salvageSite, this.salvageVehicles);
        } else if (EMERGENCY_SUPPLY_MISSION.equals(this.type)) {
            mission = new EmergencySupplyMission(this.members, this.startingSettlement, this.destinationSettlement, this.emergencyGoods, this.rover, this.description);
        } else {
            throw new IllegalStateException("mission type: " + this.type + " unknown");
        }
        MissionManager manager = Simulation.instance().getMissionManager();
        manager.addMission((Mission)mission);
    }

    static String[] getMissionTypes() {
        String[] result = new String[]{TRAVEL_MISSION, EXPLORATION_MISSION, ICE_MISSION, REGOLITH_MISSION, AREOLOGY_FIELD_MISSION, BIOLOGY_FIELD_MISSION, RESCUE_MISSION, TRADE_MISSION, MINING_MISSION, CONSTRUCTION_MISSION, SALVAGE_MISSION, EMERGENCY_SUPPLY_MISSION};
        return result;
    }

    static String getMissionDescription(String missionType) {
        String result = "";
        if (missionType.equals(TRAVEL_MISSION)) {
            result = "Travel To Settlement";
        } else if (missionType.equals(EXPLORATION_MISSION)) {
            result = EXPLORATION_MISSION;
        } else if (missionType.equals(ICE_MISSION)) {
            result = ICE_MISSION;
        } else if (missionType.equals(REGOLITH_MISSION)) {
            result = REGOLITH_MISSION;
        } else if (missionType.equals(RESCUE_MISSION)) {
            result = RESCUE_MISSION;
        } else if (missionType.equals(TRADE_MISSION)) {
            result = "Trade with Settlement";
        } else if (missionType.equals(MINING_MISSION)) {
            result = MINING_MISSION;
        } else if (missionType.equals(CONSTRUCTION_MISSION)) {
            result = "Construct Building";
        } else if (missionType.equals(AREOLOGY_FIELD_MISSION)) {
            result = AREOLOGY_FIELD_MISSION;
        } else if (missionType.equals(BIOLOGY_FIELD_MISSION)) {
            result = BIOLOGY_FIELD_MISSION;
        } else if (missionType.equals(SALVAGE_MISSION)) {
            result = "Salvage Building";
        } else if (missionType.equals(EMERGENCY_SUPPLY_MISSION)) {
            result = "Deliver Emergency Supplies";
        }
        return result;
    }

    String getType() {
        return this.type;
    }

    void setType(String type) {
        this.type = type;
    }

    String getDescription() {
        return this.description;
    }

    void setDescription(String description) {
        this.description = description;
    }

    Settlement getStartingSettlement() {
        return this.startingSettlement;
    }

    void setStartingSettlement(Settlement startingSettlement) {
        this.startingSettlement = startingSettlement;
    }

    Rover getRover() {
        return this.rover;
    }

    void setRover(Rover rover) {
        this.rover = rover;
    }

    Collection<Person> getMembers() {
        return this.members;
    }

    void setMembers(Collection<Person> members) {
        this.members = members;
    }

    Settlement getDestinationSettlement() {
        return this.destinationSettlement;
    }

    void setDestinationSettlement(Settlement destinationSettlement) {
        this.destinationSettlement = destinationSettlement;
    }

    Rover getRescueRover() {
        return this.rescueRover;
    }

    void setRescueRover(Rover rescueRover) {
        this.rescueRover = rescueRover;
    }

    Coordinates getIceCollectionSite() {
        return this.iceCollectionSite;
    }

    void setIceCollectionSite(Coordinates iceCollectionSite) {
        this.iceCollectionSite = iceCollectionSite;
    }

    Coordinates getRegolithCollectionSite() {
        return this.regolithCollectionSite;
    }

    void setRegolithCollectionSite(Coordinates regolithCollectionSite) {
        this.regolithCollectionSite = regolithCollectionSite;
    }

    Coordinates[] getExplorationSites() {
        return this.explorationSites;
    }

    void setExplorationSites(Coordinates[] explorationSites) {
        this.explorationSites = explorationSites;
    }

    Map<Good, Integer> getSellGoods() {
        return this.sellGoods;
    }

    void setSellGoods(Map<Good, Integer> sellGoods) {
        this.sellGoods = sellGoods;
    }

    Map<Good, Integer> getBuyGoods() {
        return this.buyGoods;
    }

    void setBuyGoods(Map<Good, Integer> buyGoods) {
        this.buyGoods = buyGoods;
    }

    LightUtilityVehicle getLUV() {
        return this.luv;
    }

    void setLUV(LightUtilityVehicle luv) {
        this.luv = luv;
    }

    ExploredLocation getMiningSite() {
        return this.miningSite;
    }

    void setMiningSite(ExploredLocation miningSite) {
        this.miningSite = miningSite;
    }

    Settlement getSalvageSettlement() {
        return this.salvageSettlement;
    }

    void setSalvageSettlement(Settlement salvageSettlement) {
        this.salvageSettlement = salvageSettlement;
    }

    ConstructionSite getSalvageSite() {
        return this.salvageSite;
    }

    void setSalvageSite(ConstructionSite salvageSite) {
        this.salvageSite = salvageSite;
    }

    Building getSalvageBuilding() {
        return this.salvageBuilding;
    }

    void setSalvageBuilding(Building salvageBuilding) {
        this.salvageBuilding = salvageBuilding;
    }

    List<GroundVehicle> getSalvageVehicles() {
        return this.salvageVehicles;
    }

    void setSalvageVehicles(List<GroundVehicle> salvageVehicles) {
        this.salvageVehicles = salvageVehicles;
    }

    Settlement getConstructionSettlement() {
        return this.constructionSettlement;
    }

    void setConstructionSettlement(Settlement constructionSettlement) {
        this.constructionSettlement = constructionSettlement;
    }

    ConstructionSite getConstructionSite() {
        return this.constructionSite;
    }

    void setConstructionSite(ConstructionSite constructionSite) {
        this.constructionSite = constructionSite;
    }

    ConstructionStageInfo getConstructionStageInfo() {
        return this.constructionStageInfo;
    }

    void setConstructionStageInfo(ConstructionStageInfo constructionStageInfo) {
        this.constructionStageInfo = constructionStageInfo;
    }

    double getConstructionSiteXLocation() {
        return this.constructionSiteXLoc;
    }

    void setConstructionSiteXLocation(double constructionSiteXLoc) {
        this.constructionSiteXLoc = constructionSiteXLoc;
    }

    double getConstructionSiteYLocation() {
        return this.constructionSiteYLoc;
    }

    void setConstructionSiteYLocation(double constructionSiteYLoc) {
        this.constructionSiteYLoc = constructionSiteYLoc;
    }

    double getConstructionSiteFacing() {
        return this.constructionSiteFacing;
    }

    void setConstructionSiteFacing(double constructionSiteFacing) {
        this.constructionSiteFacing = constructionSiteFacing;
    }

    List<GroundVehicle> getConstructionVehicles() {
        return this.constructionVehicles;
    }

    void setConstructionVehicles(List<GroundVehicle> constructionVehicles) {
        this.constructionVehicles = constructionVehicles;
    }

    Coordinates getFieldSite() {
        return this.fieldSite;
    }

    void setFieldSite(Coordinates fieldSite) {
        this.fieldSite = fieldSite;
    }

    Person getLeadResearcher() {
        return this.leadResearcher;
    }

    void setLeadResearcher(Person leadResearcher) {
        this.leadResearcher = leadResearcher;
    }

    ScientificStudy getStudy() {
        return this.study;
    }

    void setScientificStudy(ScientificStudy study) {
        this.study = study;
    }

    Map<Good, Integer> getEmergencyGoods() {
        return this.emergencyGoods;
    }

    void setEmergencyGoods(Map<Good, Integer> emergencyGoods) {
        this.emergencyGoods = emergencyGoods;
    }
}

